/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.refactoring;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleRenameModuleHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler", "isAvailableOnDataContext"));
        }
        Module module = GradleRenameModuleHandler.getGradleModule(dataContext);
        return module != null && GradleRenameModuleHandler.getModuleRootDir(module) != null;
    }

    @Nullable
    private static VirtualFile getModuleRootDir(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler", "getModuleRootDir"));
        }
        File moduleFilePath = new File(module.getModuleFilePath());
        return VfsUtil.findFileByIoFile((File)moduleFilePath.getParentFile(), (boolean)true);
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler", "isRenaming"));
        }
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file, @NotNull DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler", "invoke"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler", "invoke"));
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @NotNull DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler", "invoke"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler", "invoke"));
        }
        Module module = GradleRenameModuleHandler.getGradleModule(dataContext);
        assert (module != null);
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.module.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)module.getName(), (InputValidator)new MyInputValidator(module));
    }

    @Nullable
    private static Module getGradleModule(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler", "getGradleModule"));
        }
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (module != null && (AndroidGradleFacet.getInstance(module) != null || Projects.isGradleProjectModule(module))) {
            return module;
        }
        return null;
    }

    @NotNull
    public String getActionTitle() {
        String string = RefactoringBundle.message((String)"rename.module.title");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler", "getActionTitle"));
        }
        return string;
    }

    private static String getNewPath(@NotNull String oldPath, @NotNull String newName) {
        String newPath;
        if (oldPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldPath", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler", "getNewPath"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler", "getNewPath"));
        }
        List segments = Splitter.on((String)":").splitToList((CharSequence)oldPath);
        ArrayList modifiableSegments = Lists.newArrayList((Iterable)segments);
        int segmentCount = modifiableSegments.size();
        if (segmentCount == 0) {
            newPath = ":" + newName.trim();
        } else {
            modifiableSegments.set(segmentCount - 1, newName);
            newPath = Joiner.on((String)":").join((Iterable)modifiableSegments);
        }
        return newPath;
    }

    private static void reset(@NotNull List<GradleBuildModel> buildModels) {
        if (buildModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModels", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler", "reset"));
        }
        for (GradleBuildModel buildModel : buildModels) {
            buildModel.resetState();
        }
    }

    private static class MyInputValidator
    implements InputValidator {
        @NotNull
        private final Module myModule;

        public MyInputValidator(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler$MyInputValidator", "<init>"));
            }
            this.myModule = module;
        }

        public boolean checkInput(@Nullable String inputString) {
            return inputString != null && inputString.length() > 0 && !inputString.equals(this.myModule.getName()) && !inputString.contains(":");
        }

        public boolean canClose(final @NotNull String inputString) {
            if (inputString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputString", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler$MyInputValidator", "canClose"));
            }
            final Project project = this.myModule.getProject();
            final GradleSettingsModel settingsModel = GradleSettingsModel.get(project);
            if (settingsModel == null) {
                Messages.showErrorDialog((Project)project, (String)"settings.gradle file not found", (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return true;
            }
            final VirtualFile moduleRoot = GradleRenameModuleHandler.getModuleRootDir(this.myModule);
            assert (moduleRoot != null);
            if (Projects.isGradleProjectModule(this.myModule)) {
                Messages.showErrorDialog((Project)project, (String)"Can't rename root module", (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return true;
            }
            final String oldModuleGradlePath = GradleSettingsFile.getModuleGradlePath(this.myModule);
            if (oldModuleGradlePath == null) {
                return true;
            }
            final ArrayList modifiedBuildModels = Lists.newArrayList();
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                GradleBuildModel buildModel = GradleBuildModel.get(module);
                if (buildModel == null) continue;
                DependenciesModel dependenciesModel = buildModel.dependencies();
                if (dependenciesModel != null) {
                    for (ModuleDependencyModel dependency : dependenciesModel.modules()) {
                        if (!oldModuleGradlePath.equals(dependency.path())) continue;
                        dependency.setPath(GradleRenameModuleHandler.getNewPath(dependency.path(), inputString));
                    }
                }
                if (!buildModel.isModified()) continue;
                modifiedBuildModels.add(buildModel);
            }
            String msg = IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{this.myModule.getName()});
            WriteCommandAction<Boolean> action = new WriteCommandAction<Boolean>(project, msg, new PsiFile[0]){

                protected void run(@NotNull Result<Boolean> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler$MyInputValidator$1", "run"));
                    }
                    result.setResult((Object)true);
                    if (!settingsModel.modulePaths().contains(oldModuleGradlePath)) {
                        Messages.showErrorDialog((Project)project, (String)("Can't find module '" + MyInputValidator.this.myModule.getName() + "' in settings.gradle"), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                        GradleRenameModuleHandler.reset(modifiedBuildModels);
                        return;
                    }
                    ModifiableModuleModel modifiableModel = ModuleManager.getInstance((Project)project).getModifiableModel();
                    try {
                        modifiableModel.renameModule(MyInputValidator.this.myModule, inputString);
                    }
                    catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                        Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"error.module.already.exists", (Object[])new Object[]{inputString}), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                        GradleRenameModuleHandler.reset(modifiedBuildModels);
                        return;
                    }
                    settingsModel.replaceModulePath(oldModuleGradlePath, GradleRenameModuleHandler.getNewPath(oldModuleGradlePath, inputString));
                    try {
                        moduleRoot.rename((Object)this, inputString);
                    }
                    catch (IOException e) {
                        Messages.showErrorDialog((Project)project, (String)("Rename folder failed: " + e.getMessage()), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                        result.setResult((Object)false);
                        GradleRenameModuleHandler.reset(modifiedBuildModels);
                        return;
                    }
                    modifiableModel.commit();
                    for (GradleBuildModel buildModel : modifiedBuildModels) {
                        buildModel.applyChanges();
                    }
                    settingsModel.applyChanges();
                    UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

                        public void undo() throws UnexpectedUndoException {
                            GradleProjectImporter.getInstance().requestProjectSync(project, null);
                        }

                        public void redo() throws UnexpectedUndoException {
                            GradleProjectImporter.getInstance().requestProjectSync(project, null);
                        }
                    });
                    result.setResult((Object)true);
                }
            };
            if (((Boolean)action.execute().getResultObject()).booleanValue()) {
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
                return true;
            }
            return false;
        }
    }
}

