/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProductFlavorModel
extends GradleDslBlockModel {
    @NonNls
    private static final String APPLICATION_ID = "applicationId";
    @NonNls
    private static final String CONSUMER_PROGUARD_FILES = "consumerProguardFiles";
    @NonNls
    private static final String DIMENSION = "dimension";
    @NonNls
    private static final String MANIFEST_PLACEHOLDERS = "manifestPlaceholders";
    @NonNls
    private static final String MAX_SDK_VERSION = "maxSdkVersion";
    @NonNls
    private static final String MIN_SDK_VERSION = "minSdkVersion";
    @NonNls
    private static final String MULTI_DEX_ENABLED = "multiDexEnabled";
    @NonNls
    private static final String PROGUARD_FILES = "proguardFiles";
    @NonNls
    private static final String RES_CONFIGS = "resConfigs";
    @NonNls
    private static final String RES_VALUES = "resValues";
    @NonNls
    private static final String TARGET_SDK_VERSION = "targetSdkVersion";
    @NonNls
    private static final String TEST_APPLICATION_ID = "testApplicationId";
    @NonNls
    private static final String TEST_FUNCTIONAL_TEST = "testFunctionalTest";
    @NonNls
    private static final String TEST_HANDLE_PROFILING = "testHandleProfiling";
    @NonNls
    private static final String TEST_INSTRUMENTATION_RUNNER = "testInstrumentationRunner";
    @NonNls
    private static final String TEST_INSTRUMENTATION_RUNNER_ARGUMENTS = "testInstrumentationRunnerArguments";
    @NonNls
    private static final String USE_JACK = "useJack";
    @NonNls
    private static final String VERSION_CODE = "versionCode";
    @NonNls
    private static final String VERSION_NAME = "versionName";

    public ProductFlavorModel(@NotNull ProductFlavorDslElement dslElement) {
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "<init>"));
        }
        super(dslElement);
    }

    @NotNull
    public String name() {
        String string = this.myDslElement.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "name"));
        }
        return string;
    }

    @Nullable
    public String applicationId() {
        return this.myDslElement.getProperty(APPLICATION_ID, String.class);
    }

    @NotNull
    public ProductFlavorModel setApplicationId(@NotNull String applicationId) {
        if (applicationId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", APPLICATION_ID, "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setApplicationId"));
        }
        this.myDslElement.setNewLiteral(APPLICATION_ID, applicationId);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setApplicationId"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeApplicationId() {
        this.myDslElement.removeProperty(APPLICATION_ID);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeApplicationId"));
        }
        return productFlavorModel;
    }

    @Nullable
    public List<String> consumerProguardFiles() {
        return this.myDslElement.getListProperty(CONSUMER_PROGUARD_FILES, String.class);
    }

    @NotNull
    public ProductFlavorModel addConsumerProguardFile(@NotNull String consumerProguardFile) {
        if (consumerProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumerProguardFile", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "addConsumerProguardFile"));
        }
        this.myDslElement.addToNewLiteralList(CONSUMER_PROGUARD_FILES, consumerProguardFile);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "addConsumerProguardFile"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeConsumerProguardFile(@NotNull String consumerProguardFile) {
        if (consumerProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumerProguardFile", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeConsumerProguardFile"));
        }
        this.myDslElement.removeFromExpressionList(CONSUMER_PROGUARD_FILES, consumerProguardFile);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeConsumerProguardFile"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeAllConsumerProguardFiles() {
        this.myDslElement.removeProperty(CONSUMER_PROGUARD_FILES);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeAllConsumerProguardFiles"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel replaceConsumerProguardFile(@NotNull String oldConsumerProguardFile, @NotNull String newConsumerProguardFile) {
        if (oldConsumerProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldConsumerProguardFile", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "replaceConsumerProguardFile"));
        }
        if (newConsumerProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newConsumerProguardFile", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "replaceConsumerProguardFile"));
        }
        this.myDslElement.replaceInExpressionList(CONSUMER_PROGUARD_FILES, oldConsumerProguardFile, newConsumerProguardFile);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "replaceConsumerProguardFile"));
        }
        return productFlavorModel;
    }

    @Nullable
    public String dimension() {
        return this.myDslElement.getProperty(DIMENSION, String.class);
    }

    @NotNull
    public ProductFlavorModel setDimension(@NotNull String dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", DIMENSION, "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setDimension"));
        }
        this.myDslElement.setNewLiteral(DIMENSION, dimension);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setDimension"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeDimension() {
        this.myDslElement.removeProperty(DIMENSION);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeDimension"));
        }
        return productFlavorModel;
    }

    @Nullable
    public Map<String, Object> manifestPlaceholders() {
        return this.myDslElement.getMapProperty(MANIFEST_PLACEHOLDERS, Object.class);
    }

    @NotNull
    public ProductFlavorModel setManifestPlaceholder(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setManifestPlaceholder"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setManifestPlaceholder"));
        }
        this.myDslElement.setInNewLiteralMap(MANIFEST_PLACEHOLDERS, name, value);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setManifestPlaceholder"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel setManifestPlaceholder(@NotNull String name, int value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setManifestPlaceholder"));
        }
        this.myDslElement.setInNewLiteralMap(MANIFEST_PLACEHOLDERS, name, value);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setManifestPlaceholder"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel setManifestPlaceholder(@NotNull String name, boolean value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setManifestPlaceholder"));
        }
        this.myDslElement.setInNewLiteralMap(MANIFEST_PLACEHOLDERS, name, value);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setManifestPlaceholder"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeManifestPlaceholder(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeManifestPlaceholder"));
        }
        this.myDslElement.removeFromExpressionMap(MANIFEST_PLACEHOLDERS, name);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeManifestPlaceholder"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeAllManifestPlaceholders() {
        this.myDslElement.removeProperty(MANIFEST_PLACEHOLDERS);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeAllManifestPlaceholders"));
        }
        return productFlavorModel;
    }

    @Nullable
    public Integer maxSdkVersion() {
        return this.myDslElement.getProperty(MAX_SDK_VERSION, Integer.class);
    }

    @NotNull
    public ProductFlavorModel setMaxSdkVersion(int maxSdkVersion) {
        this.myDslElement.setNewLiteral(MAX_SDK_VERSION, maxSdkVersion);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setMaxSdkVersion"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeMaxSdkVersion() {
        this.myDslElement.removeProperty(MAX_SDK_VERSION);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeMaxSdkVersion"));
        }
        return productFlavorModel;
    }

    @Nullable
    public String minSdkVersion() {
        Integer intValue = this.myDslElement.getProperty(MIN_SDK_VERSION, Integer.class);
        return intValue != null ? intValue.toString() : this.myDslElement.getProperty(MIN_SDK_VERSION, String.class);
    }

    @NotNull
    public ProductFlavorModel setMinSdkVersion(int minSdkVersion) {
        this.myDslElement.setNewLiteral(MIN_SDK_VERSION, minSdkVersion);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setMinSdkVersion"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel setMinSdkVersion(@NotNull String minSdkVersion) {
        if (minSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", MIN_SDK_VERSION, "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setMinSdkVersion"));
        }
        this.myDslElement.setNewLiteral(MIN_SDK_VERSION, minSdkVersion);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setMinSdkVersion"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeMinSdkVersion() {
        this.myDslElement.removeProperty(MIN_SDK_VERSION);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeMinSdkVersion"));
        }
        return productFlavorModel;
    }

    @Nullable
    public Boolean multiDexEnabled() {
        return this.myDslElement.getProperty(MULTI_DEX_ENABLED, Boolean.class);
    }

    @NotNull
    public ProductFlavorModel setMultiDexEnabled(boolean multiDexEnabled) {
        this.myDslElement.setNewLiteral(MULTI_DEX_ENABLED, multiDexEnabled);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setMultiDexEnabled"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeMultiDexEnabled() {
        this.myDslElement.removeProperty(MULTI_DEX_ENABLED);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeMultiDexEnabled"));
        }
        return productFlavorModel;
    }

    @Nullable
    public List<String> proguardFiles() {
        return this.myDslElement.getListProperty(PROGUARD_FILES, String.class);
    }

    @NotNull
    public ProductFlavorModel addProguardFile(@NotNull String proguardFile) {
        if (proguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proguardFile", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "addProguardFile"));
        }
        this.myDslElement.addToNewLiteralList(PROGUARD_FILES, proguardFile);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "addProguardFile"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeProguardFile(@NotNull String proguardFile) {
        if (proguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proguardFile", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeProguardFile"));
        }
        this.myDslElement.removeFromExpressionList(PROGUARD_FILES, proguardFile);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeProguardFile"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeAllProguardFiles() {
        this.myDslElement.removeProperty(PROGUARD_FILES);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeAllProguardFiles"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel replaceProguardFile(@NotNull String oldProguardFile, @NotNull String newProguardFile) {
        if (oldProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldProguardFile", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "replaceProguardFile"));
        }
        if (newProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newProguardFile", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "replaceProguardFile"));
        }
        this.myDslElement.replaceInExpressionList(PROGUARD_FILES, oldProguardFile, newProguardFile);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "replaceProguardFile"));
        }
        return productFlavorModel;
    }

    @Nullable
    public List<String> resConfigs() {
        return this.myDslElement.getListProperty(RES_CONFIGS, String.class);
    }

    @NotNull
    public ProductFlavorModel addResConfig(@NotNull String resConfig) {
        if (resConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resConfig", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "addResConfig"));
        }
        this.myDslElement.addToNewLiteralList(RES_CONFIGS, resConfig);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "addResConfig"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeResConfig(@NotNull String resConfig) {
        if (resConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resConfig", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeResConfig"));
        }
        this.myDslElement.removeFromExpressionList(RES_CONFIGS, resConfig);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeResConfig"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeAllResConfigs() {
        this.myDslElement.removeProperty(RES_CONFIGS);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeAllResConfigs"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel replaceResConfig(@NotNull String oldResConfig, @NotNull String newResConfig) {
        if (oldResConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldResConfig", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "replaceResConfig"));
        }
        if (newResConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newResConfig", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "replaceResConfig"));
        }
        this.myDslElement.replaceInExpressionList(RES_CONFIGS, oldResConfig, newResConfig);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "replaceResConfig"));
        }
        return productFlavorModel;
    }

    @Nullable
    public List<ResValue> resValues() {
        GradleDslElementList resValues = this.myDslElement.getProperty(RES_VALUES, GradleDslElementList.class);
        if (resValues == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (GradleDslElement resValue : resValues.getElements()) {
            GradleDslExpressionList listElement;
            List<String> values;
            if (!(resValue instanceof GradleDslExpressionList) || (values = (listElement = (GradleDslExpressionList)resValue).getValues(String.class)).size() != 3) continue;
            result.add(new ResValue(values.get(0), values.get(1), values.get(2)));
        }
        return result;
    }

    @NotNull
    public ProductFlavorModel addResValue(@NotNull ResValue resValue) {
        if (resValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resValue", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "addResValue"));
        }
        GradleDslElementList elementList = this.myDslElement.getProperty(RES_VALUES, GradleDslElementList.class);
        if (elementList == null) {
            elementList = new GradleDslElementList(this.myDslElement, RES_VALUES);
            this.myDslElement.setNewElement(RES_VALUES, elementList);
        }
        elementList.addNewElement(resValue.toLiteralListElement(this.myDslElement));
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "addResValue"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeResValue(@NotNull ResValue resValue) {
        if (resValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resValue", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeResValue"));
        }
        GradleDslElementList elementList = this.myDslElement.getProperty(RES_VALUES, GradleDslElementList.class);
        if (elementList != null) {
            for (GradleDslExpressionList element : elementList.getElements(GradleDslExpressionList.class)) {
                List<String> values = element.getValues(String.class);
                if (values.size() != 3 || !resValue.type().equals(values.get(0)) || !resValue.name().equals(values.get(1)) || !resValue.value().equals(values.get(2))) continue;
                elementList.removeElement(element);
            }
        }
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeResValue"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeAllResValues() {
        this.myDslElement.removeProperty(RES_VALUES);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeAllResValues"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel replaceResValue(@NotNull ResValue oldResValue, @NotNull ResValue newResValue) {
        if (oldResValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldResValue", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "replaceResValue"));
        }
        if (newResValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newResValue", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "replaceResValue"));
        }
        GradleDslElementList elementList = this.myDslElement.getProperty(RES_VALUES, GradleDslElementList.class);
        if (elementList != null) {
            for (GradleDslExpressionList element : elementList.getElements(GradleDslExpressionList.class)) {
                List<GradleDslExpression> gradleDslLiterals = element.getExpressions();
                if (gradleDslLiterals.size() != 3 || !oldResValue.type().equals(gradleDslLiterals.get(0).getValue()) || !oldResValue.name().equals(gradleDslLiterals.get(1).getValue()) || !oldResValue.value().equals(gradleDslLiterals.get(2).getValue())) continue;
                gradleDslLiterals.get(0).setValue(newResValue.type());
                gradleDslLiterals.get(1).setValue(newResValue.name());
                gradleDslLiterals.get(2).setValue(newResValue.value());
            }
        }
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "replaceResValue"));
        }
        return productFlavorModel;
    }

    @Nullable
    public String targetSdkVersion() {
        Integer intValue = this.myDslElement.getProperty(TARGET_SDK_VERSION, Integer.class);
        return intValue != null ? intValue.toString() : this.myDslElement.getProperty(TARGET_SDK_VERSION, String.class);
    }

    @NotNull
    public ProductFlavorModel setTargetSdkVersion(int targetSdkVersion) {
        this.myDslElement.setNewLiteral(TARGET_SDK_VERSION, targetSdkVersion);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setTargetSdkVersion"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel setTargetSdkVersion(@NotNull String targetSdkVersion) {
        if (targetSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TARGET_SDK_VERSION, "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setTargetSdkVersion"));
        }
        this.myDslElement.setNewLiteral(TARGET_SDK_VERSION, targetSdkVersion);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setTargetSdkVersion"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeTargetSdkVersion() {
        this.myDslElement.removeProperty(TARGET_SDK_VERSION);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeTargetSdkVersion"));
        }
        return productFlavorModel;
    }

    @Nullable
    public String testApplicationId() {
        return this.myDslElement.getProperty(TEST_APPLICATION_ID, String.class);
    }

    @NotNull
    public ProductFlavorModel setTestApplicationId(@NotNull String testApplicationId) {
        if (testApplicationId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TEST_APPLICATION_ID, "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setTestApplicationId"));
        }
        this.myDslElement.setNewLiteral(TEST_APPLICATION_ID, testApplicationId);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setTestApplicationId"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeTestApplicationId() {
        this.myDslElement.removeProperty(TEST_APPLICATION_ID);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeTestApplicationId"));
        }
        return productFlavorModel;
    }

    @Nullable
    public Boolean testFunctionalTest() {
        return this.myDslElement.getProperty(TEST_FUNCTIONAL_TEST, Boolean.class);
    }

    @NotNull
    public ProductFlavorModel setTestFunctionalTest(boolean testFunctionalTest) {
        this.myDslElement.setNewLiteral(TEST_FUNCTIONAL_TEST, testFunctionalTest);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setTestFunctionalTest"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeTestFunctionalTest() {
        this.myDslElement.removeProperty(TEST_FUNCTIONAL_TEST);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeTestFunctionalTest"));
        }
        return productFlavorModel;
    }

    @Nullable
    public Boolean testHandleProfiling() {
        return this.myDslElement.getProperty(TEST_HANDLE_PROFILING, Boolean.class);
    }

    @NotNull
    public ProductFlavorModel setTestHandleProfiling(boolean testHandleProfiling) {
        this.myDslElement.setNewLiteral(TEST_HANDLE_PROFILING, testHandleProfiling);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setTestHandleProfiling"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeTestHandleProfiling() {
        this.myDslElement.removeProperty(TEST_HANDLE_PROFILING);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeTestHandleProfiling"));
        }
        return productFlavorModel;
    }

    @Nullable
    public String testInstrumentationRunner() {
        return this.myDslElement.getProperty(TEST_INSTRUMENTATION_RUNNER, String.class);
    }

    @NotNull
    public ProductFlavorModel setTestInstrumentationRunner(@NotNull String testInstrumentationRunner) {
        if (testInstrumentationRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TEST_INSTRUMENTATION_RUNNER, "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setTestInstrumentationRunner"));
        }
        this.myDslElement.setNewLiteral(TEST_INSTRUMENTATION_RUNNER, testInstrumentationRunner);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setTestInstrumentationRunner"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeTestInstrumentationRunner() {
        this.myDslElement.removeProperty(TEST_INSTRUMENTATION_RUNNER);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeTestInstrumentationRunner"));
        }
        return productFlavorModel;
    }

    @Nullable
    public Map<String, String> testInstrumentationRunnerArguments() {
        return this.myDslElement.getMapProperty(TEST_INSTRUMENTATION_RUNNER_ARGUMENTS, String.class);
    }

    @NotNull
    public ProductFlavorModel setTestInstrumentationRunnerArgument(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setTestInstrumentationRunnerArgument"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setTestInstrumentationRunnerArgument"));
        }
        this.myDslElement.setInNewLiteralMap(TEST_INSTRUMENTATION_RUNNER_ARGUMENTS, name, value);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setTestInstrumentationRunnerArgument"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeTestInstrumentationRunnerArgument(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeTestInstrumentationRunnerArgument"));
        }
        this.myDslElement.removeFromExpressionMap(TEST_INSTRUMENTATION_RUNNER_ARGUMENTS, name);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeTestInstrumentationRunnerArgument"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeAllTestInstrumentationRunnerArguments() {
        this.myDslElement.removeProperty(TEST_INSTRUMENTATION_RUNNER_ARGUMENTS);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeAllTestInstrumentationRunnerArguments"));
        }
        return productFlavorModel;
    }

    @Nullable
    public Boolean useJack() {
        return this.myDslElement.getProperty(USE_JACK, Boolean.class);
    }

    @NotNull
    public ProductFlavorModel setUseJack(boolean useJack) {
        this.myDslElement.setNewLiteral(USE_JACK, useJack);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setUseJack"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeUseJack() {
        this.myDslElement.removeProperty(USE_JACK);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeUseJack"));
        }
        return productFlavorModel;
    }

    @Nullable
    public String versionCode() {
        Integer intValue = this.myDslElement.getProperty(VERSION_CODE, Integer.class);
        return intValue != null ? intValue.toString() : this.myDslElement.getProperty(VERSION_CODE, String.class);
    }

    @NotNull
    public ProductFlavorModel setVersionCode(int versionCode) {
        this.myDslElement.setNewLiteral(VERSION_CODE, versionCode);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setVersionCode"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel setVersionCode(@NotNull String versionCode) {
        if (versionCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", VERSION_CODE, "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setVersionCode"));
        }
        this.myDslElement.setNewLiteral(VERSION_CODE, versionCode);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setVersionCode"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeVersionCode() {
        this.myDslElement.removeProperty(VERSION_CODE);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeVersionCode"));
        }
        return productFlavorModel;
    }

    @Nullable
    public String versionName() {
        return this.myDslElement.getProperty(VERSION_NAME, String.class);
    }

    @NotNull
    public ProductFlavorModel setVersionName(@NotNull String versionName) {
        if (versionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", VERSION_NAME, "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setVersionName"));
        }
        this.myDslElement.setNewLiteral(VERSION_NAME, versionName);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "setVersionName"));
        }
        return productFlavorModel;
    }

    @NotNull
    public ProductFlavorModel removeVersionName() {
        this.myDslElement.removeProperty(VERSION_NAME);
        ProductFlavorModel productFlavorModel = this;
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel", "removeVersionName"));
        }
        return productFlavorModel;
    }

    public static final class ResValue {
        @NotNull
        public static final String RES_VALUE_ATTRIBUTE_NAME = "resValue";
        @NotNull
        private final String myType;
        @NotNull
        private final String myName;
        @NotNull
        private final String myValue;

        public ResValue(@NotNull String type, @NotNull String name, @NotNull String value) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel$ResValue", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel$ResValue", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel$ResValue", "<init>"));
            }
            this.myType = type;
            this.myName = name;
            this.myValue = value;
        }

        @NotNull
        public String type() {
            String string = this.myType;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel$ResValue", "type"));
            }
            return string;
        }

        @NotNull
        public String name() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel$ResValue", "name"));
            }
            return string;
        }

        @NotNull
        public String value() {
            String string = this.myValue;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel$ResValue", "value"));
            }
            return string;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myType, this.myName, this.myValue});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResValue)) {
                return false;
            }
            ResValue other = (ResValue)o;
            return this.myType.equals(other.myType) && this.myName.equals(other.myName) && this.myValue.equals(other.myValue);
        }

        public String toString() {
            return String.format("Type: %1$s, Name: %2$s, Value: %3$s", this.myType, this.myName, this.myValue);
        }

        @NotNull
        private GradleDslExpressionList toLiteralListElement(@NotNull GradleDslElement parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel$ResValue", "toLiteralListElement"));
            }
            GradleDslLiteral typeElement = new GradleDslLiteral(parent, RES_VALUE_ATTRIBUTE_NAME);
            typeElement.setValue(this.myType);
            GradleDslLiteral nameElement = new GradleDslLiteral(parent, RES_VALUE_ATTRIBUTE_NAME);
            nameElement.setValue(this.myName);
            GradleDslLiteral valueElement = new GradleDslLiteral(parent, RES_VALUE_ATTRIBUTE_NAME);
            valueElement.setValue(this.myValue);
            GradleDslExpressionList gradleDslExpressionList = new GradleDslExpressionList(parent, RES_VALUE_ATTRIBUTE_NAME);
            gradleDslExpressionList.addNewExpression(typeElement);
            gradleDslExpressionList.addNewExpression(nameElement);
            gradleDslExpressionList.addNewExpression(valueElement);
            GradleDslExpressionList gradleDslExpressionList2 = gradleDslExpressionList;
            if (gradleDslExpressionList2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/ProductFlavorModel$ResValue", "toLiteralListElement"));
            }
            return gradleDslExpressionList2;
        }
    }
}

