/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.compiler;

import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;

public class AndroidGradleBuildTargetScopeProvider
extends BuildTargetScopeProvider {
    public static final String TARGET_ID = "android_gradle_build_target";
    public static final String TARGET_TYPE_ID = "android_gradle_build_target_type";

    @NotNull
    public List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> getBuildTargetScopes(@NotNull CompileScope baseScope, @NotNull CompilerFilter filter, @NotNull Project project, boolean forceBuild) {
        if (baseScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseScope", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        if (!Projects.requiresAndroidModel(project)) {
            List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildTargetScopeProvider", "getBuildTargetScopes"));
            }
            return list;
        }
        BuildSettings buildSettings = BuildSettings.getInstance(project);
        String runConfigurationTypeId = (String)baseScope.getUserData(CompileStepBeforeRun.RUN_CONFIGURATION_TYPE_ID);
        buildSettings.setRunConfigurationTypeId(runConfigurationTypeId);
        if (baseScope instanceof ProjectCompileScope) {
            BuildMode buildMode;
            BuildMode buildMode2 = buildMode = forceBuild ? BuildMode.REBUILD : BuildMode.ASSEMBLE;
            if (buildSettings.getBuildMode() == null) {
                buildSettings.setBuildMode(buildMode);
            }
            Module[] modulesToBuild = ModuleManager.getInstance((Project)project).getModules();
            buildSettings.setModulesToBuild(modulesToBuild);
        } else if (baseScope instanceof ModuleCompileScope) {
            String userDataString = ((ModuleCompileScope)baseScope).getUserDataString();
            Module[] modulesToBuild = userDataString.contains("RUN_CONFIGURATION") ? baseScope.getAffectedModules() : Projects.getModulesToBuildFromSelection(project, null);
            buildSettings.setModulesToBuild(modulesToBuild);
            buildSettings.setBuildMode(BuildMode.ASSEMBLE);
        } else if (baseScope instanceof CompositeScope) {
            buildSettings.setModulesToBuild(Projects.getModulesToBuildFromSelection(project, null));
            buildSettings.setBuildMode(BuildMode.COMPILE_JAVA);
        }
        CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope = CmdlineProtoUtil.createTargetsScope((String)TARGET_TYPE_ID, Collections.singletonList(TARGET_ID), (boolean)forceBuild);
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list = Collections.singletonList(scope);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        return list;
    }
}

