/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.bmp.pixelparsers;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.bmp.BmpHeaderInfo;
import org.apache.sanselan.formats.bmp.pixelparsers.PixelParser;

public class PixelParserRle
extends PixelParser {
    public PixelParserRle(BmpHeaderInfo bhi, byte[] ColorTable, byte[] ImageData) {
        super(bhi, ColorTable, ImageData);
    }

    private int getSamplesPerByte() throws ImageReadException, IOException {
        if (this.bhi.bitsPerPixel == 8) {
            return 1;
        }
        if (this.bhi.bitsPerPixel == 4) {
            return 2;
        }
        throw new ImageReadException("BMP RLE: bad BitsPerPixel: " + this.bhi.bitsPerPixel);
    }

    private int[] convertDataToSamples(int data) throws ImageReadException, IOException {
        int[] rgbs;
        if (this.bhi.bitsPerPixel == 8) {
            rgbs = new int[]{this.getColorTableRGB(data)};
        } else if (this.bhi.bitsPerPixel == 4) {
            rgbs = new int[2];
            int sample1 = data >> 4;
            int sample2 = 0xF & data;
            rgbs[0] = this.getColorTableRGB(sample1);
            rgbs[1] = this.getColorTableRGB(sample2);
        } else {
            throw new ImageReadException("BMP RLE: bad BitsPerPixel: " + this.bhi.bitsPerPixel);
        }
        return rgbs;
    }

    private int processByteOfData(int[] rgbs, int repeat, int x, int y, int width, int height, DataBuffer db, BufferedImage bi) throws ImageReadException {
        int pixels_written = 0;
        for (int i = 0; i < repeat; ++i) {
            if (x >= 0 && x < width && y >= 0 && y < height) {
                int rgb = rgbs[i % rgbs.length];
                db.setElem(y * this.bhi.width + x, rgb);
            } else {
                System.out.println("skipping bad pixel (" + x + "," + y + ")");
            }
            ++x;
            ++pixels_written;
        }
        return pixels_written;
    }

    @Override
    public void processImage(BufferedImage bi) throws ImageReadException, IOException {
        DataBuffer db = bi.getRaster().getDataBuffer();
        int count = 0;
        int width = this.bhi.width;
        int height = this.bhi.height;
        int x = 0;
        int y = height - 1;
        boolean done = false;
        block5: while (!done) {
            ++count;
            int a = 0xFF & this.bfp.readByte("RLE (" + x + "," + y + ") a", this.is, "BMP: Bad RLE");
            int b = 0xFF & this.bfp.readByte("RLE (" + x + "," + y + ")  b", this.is, "BMP: Bad RLE");
            if (a == 0) {
                switch (b) {
                    case 0: {
                        --y;
                        x = 0;
                        continue block5;
                    }
                    case 1: {
                        done = true;
                        continue block5;
                    }
                    case 2: {
                        int c = 0xFF & this.bfp.readByte("RLE c", this.is, "BMP: Bad RLE");
                        int d = 0xFF & this.bfp.readByte("RLE d", this.is, "BMP: Bad RLE");
                        continue block5;
                    }
                }
                int SamplesPerByte = this.getSamplesPerByte();
                int size = b / SamplesPerByte;
                if (b % SamplesPerByte > 0) {
                    ++size;
                }
                if (size % 2 != 0) {
                    ++size;
                }
                byte[] bytes = this.bfp.readByteArray("bytes", size, this.is, "RLE: Absolute Mode");
                int remaining = b;
                int i = 0;
                while (remaining > 0) {
                    int[] samples = this.convertDataToSamples(0xFF & bytes[i]);
                    int towrite = Math.min(remaining, SamplesPerByte);
                    int written = this.processByteOfData(samples, towrite, x, y, width, height, db, bi);
                    x += written;
                    remaining -= written;
                    ++i;
                }
                continue;
            }
            int[] rgbs = this.convertDataToSamples(b);
            x += this.processByteOfData(rgbs, a, x, y, width, height, db, bi);
        }
    }
}

