/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFileJsonTypeAdapter;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourceFilePositionJsonSerializer;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.SourcePositionJsonTypeAdapter;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class MergingLogPersistUtil {
    private static final SourceFileJsonTypeAdapter mSourceFileJsonTypeAdapter = new SourceFileJsonTypeAdapter();
    private static final SourcePositionJsonTypeAdapter mSourcePositionJsonTypeAdapter = new SourcePositionJsonTypeAdapter();
    private static final SourceFilePositionJsonSerializer mSourceFilePositionJsonTypeAdapter = new SourceFilePositionJsonSerializer();
    private static final String KEY_OUTPUT_FILE = "outputFile";
    private static final String KEY_FROM = "from";
    private static final String KEY_TO = "to";
    private static final String KEY_MERGED = "merged";
    private static final String KEY_SOURCE = "source";
    private static final String KEY_MAP = "map";
    private static final String INDENT_STRING = "    ";

    private static File getMultiFile(File folder, String shard) {
        return new File(new File(folder, "multi"), shard + ".json");
    }

    private static File getSingleFile(File folder, String shard) {
        return new File(new File(folder, "single"), shard + ".json");
    }

    static void saveToMultiFile(File folder, String shard, Map<SourceFile, Map<SourcePosition, SourceFilePosition>> map) throws IOException {
        File file = MergingLogPersistUtil.getMultiFile(folder, shard);
        file.getParentFile().mkdir();
        JsonWriter out = new JsonWriter((Writer)Files.newWriter((File)file, (Charset)Charsets.UTF_8));
        out.setIndent(INDENT_STRING);
        out.beginArray();
        for (Map.Entry<SourceFile, Map<SourcePosition, SourceFilePosition>> entry : map.entrySet()) {
            out.beginObject().name(KEY_OUTPUT_FILE);
            mSourceFileJsonTypeAdapter.write(out, entry.getKey());
            out.name(KEY_MAP);
            out.beginArray();
            for (Map.Entry<SourcePosition, SourceFilePosition> innerEntry : entry.getValue().entrySet()) {
                out.beginObject();
                out.name(KEY_TO);
                mSourcePositionJsonTypeAdapter.write(out, innerEntry.getKey());
                out.name(KEY_FROM);
                mSourceFilePositionJsonTypeAdapter.write(out, innerEntry.getValue());
                out.endObject();
            }
            out.endArray();
            out.endObject();
        }
        out.endArray();
        out.close();
    }

    static Map<SourceFile, Map<SourcePosition, SourceFilePosition>> loadFromMultiFile(File folder, String shard) {
        ConcurrentMap map = Maps.newConcurrentMap();
        JsonReader reader = null;
        File file = MergingLogPersistUtil.getMultiFile(folder, shard);
        if (!file.exists()) {
            return map;
        }
        try {
            reader = new JsonReader((Reader)Files.newReader((File)file, (Charset)Charsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            return map;
        }
        try {
            reader.beginArray();
            while (reader.peek() != JsonToken.END_ARRAY) {
                reader.beginObject();
                SourceFile toFile = SourceFile.UNKNOWN;
                LinkedHashMap innerMap = Maps.newLinkedHashMap();
                while (reader.peek() != JsonToken.END_OBJECT) {
                    String name = reader.nextName();
                    if (name.equals(KEY_OUTPUT_FILE)) {
                        toFile = mSourceFileJsonTypeAdapter.read(reader);
                        continue;
                    }
                    if (name.equals(KEY_MAP)) {
                        reader.beginArray();
                        while (reader.peek() != JsonToken.END_ARRAY) {
                            reader.beginObject();
                            SourceFilePosition from = null;
                            SourcePosition to = null;
                            while (reader.peek() != JsonToken.END_OBJECT) {
                                String innerName = reader.nextName();
                                if (innerName.equals(KEY_FROM)) {
                                    from = mSourceFilePositionJsonTypeAdapter.read(reader);
                                    continue;
                                }
                                if (innerName.equals(KEY_TO)) {
                                    to = mSourcePositionJsonTypeAdapter.read(reader);
                                    continue;
                                }
                                throw new IOException(String.format("Unexpected property: %s", innerName));
                            }
                            if (from == null || to == null) {
                                throw new IOException("Each record must contain both from and to.");
                            }
                            innerMap.put(to, from);
                            reader.endObject();
                        }
                        reader.endArray();
                        continue;
                    }
                    throw new IOException(String.format("Unexpected property: %s", name));
                }
                map.put(toFile, innerMap);
                reader.endObject();
            }
            reader.endArray();
            reader.close();
            return map;
        }
        catch (IOException e) {
            try {
                reader.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }

    static void saveToSingleFile(File folder, String shard, Map<SourceFile, SourceFile> map) throws IOException {
        File file = MergingLogPersistUtil.getSingleFile(folder, shard);
        file.getParentFile().mkdir();
        JsonWriter out = new JsonWriter((Writer)Files.newWriter((File)file, (Charset)Charsets.UTF_8));
        out.setIndent(INDENT_STRING);
        out.beginArray();
        for (Map.Entry<SourceFile, SourceFile> entry : map.entrySet()) {
            out.beginObject();
            out.name(KEY_MERGED);
            mSourceFileJsonTypeAdapter.write(out, entry.getKey());
            out.name(KEY_SOURCE);
            mSourceFileJsonTypeAdapter.write(out, entry.getValue());
            out.endObject();
        }
        out.endArray();
        out.close();
    }

    static Map<SourceFile, SourceFile> loadFromSingleFile(File folder, String shard) {
        ConcurrentMap fileMap = Maps.newConcurrentMap();
        JsonReader reader = null;
        File file = MergingLogPersistUtil.getSingleFile(folder, shard);
        if (!file.exists()) {
            return fileMap;
        }
        try {
            reader = new JsonReader((Reader)Files.newReader((File)file, (Charset)Charsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            return fileMap;
        }
        try {
            reader.beginArray();
            while (reader.peek() != JsonToken.END_ARRAY) {
                reader.beginObject();
                SourceFile merged = SourceFile.UNKNOWN;
                SourceFile source = SourceFile.UNKNOWN;
                while (reader.peek() != JsonToken.END_OBJECT) {
                    String name = reader.nextName();
                    if (name.equals(KEY_MERGED)) {
                        merged = mSourceFileJsonTypeAdapter.read(reader);
                        continue;
                    }
                    if (name.equals(KEY_SOURCE)) {
                        source = mSourceFileJsonTypeAdapter.read(reader);
                        continue;
                    }
                    throw new IOException(String.format("Unexpected property: %s", name));
                }
                reader.endObject();
                fileMap.put(merged, source);
            }
            reader.endArray();
            return fileMap;
        }
        catch (IOException e) {
            try {
                reader.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }
}

