/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config;

import com.intellij.cvsSupport2.config.AbstractConfiguration;
import com.intellij.cvsSupport2.ui.experts.importToCvs.FileExtension;
import com.intellij.openapi.components.ServiceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ImportConfiguration
extends AbstractConfiguration {
    public String VENDOR;
    public String RELEASE_TAG;
    public String LOG_MESSAGE;
    public boolean CHECKOUT_AFTER_IMPORT = true;
    public String KEYWORD_SUBSTITUTION_WRAPPERS = "";
    public boolean MAKE_NEW_FILES_READ_ONLY = false;

    public static ImportConfiguration getInstance() {
        return (ImportConfiguration)ServiceManager.getService(ImportConfiguration.class);
    }

    public ImportConfiguration() {
        super("ImportConfiguration");
    }

    public Collection<FileExtension> getExtensions() {
        String[] wrappers;
        if (this.KEYWORD_SUBSTITUTION_WRAPPERS == null || this.KEYWORD_SUBSTITUTION_WRAPPERS.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<FileExtension> result = new ArrayList<FileExtension>();
        for (String wrapper : wrappers = this.KEYWORD_SUBSTITUTION_WRAPPERS.split(";")) {
            String[] extAndSubstitution = wrapper.split(" ");
            if (extAndSubstitution.length != 2) continue;
            result.add(new FileExtension(extAndSubstitution[0], extAndSubstitution[1]));
        }
        return result;
    }

    public void setExtensions(List<FileExtension> items) {
        StringBuilder buffer = new StringBuilder();
        for (FileExtension extension : items) {
            buffer.append(extension.getExtension());
            buffer.append(" ");
            buffer.append(extension.getKeywordSubstitution().getSubstitution().toString());
            buffer.append(";");
        }
        this.KEYWORD_SUBSTITUTION_WRAPPERS = buffer.toString();
    }
}

