/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.shrinker;

import com.android.builder.shrinker.ClassLookupException;
import com.android.builder.shrinker.ShrinkerGraph;
import com.google.common.collect.Lists;
import com.google.common.collect.TreeTraverser;
import java.util.ArrayList;
import java.util.Collections;

public class TypeHierarchyTraverser<T>
extends TreeTraverser<T> {
    private final ShrinkerGraph<T> mGraph;

    public TypeHierarchyTraverser(ShrinkerGraph<T> graph) {
        this.mGraph = graph;
    }

    public Iterable<T> children(T klass) {
        try {
            ArrayList result = Lists.newArrayList();
            T superclass = this.mGraph.getSuperclass(klass);
            if (superclass != null) {
                result.add(superclass);
            }
            Collections.addAll(result, this.mGraph.getInterfaces(klass));
            return result;
        }
        catch (ClassLookupException e) {
            if (!e.getClassName().startsWith("sun/misc/Unsafe")) {
                System.out.println("Invalid class reference: " + e.getClassName());
            }
            return Collections.emptyList();
        }
    }
}

