/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.gradleplugin.foundation.GradlePluginLord;
import org.gradle.gradleplugin.userinterface.AlternateUIInteraction;
import org.gradle.gradleplugin.userinterface.swing.generic.OutputPanel;

public class OutputTab
extends OutputPanel {
    private static final Logger LOGGER = Logging.getLogger(OutputTab.class);
    private JPanel mainPanel = new JPanel();
    private JLabel mainTextLabel;
    private JLabel pinnedLabel;
    private JLabel closeLabel;
    private static ImageIcon closeIcon;
    private static ImageIcon closeHighlightIcon;
    private static ImageIcon pinnedIcon;

    public OutputTab(GradlePluginLord gradlePluginLord, OutputPanel.OutputPanelParent parent, String header, AlternateUIInteraction alternateUIInteraction) {
        super(gradlePluginLord, parent, alternateUIInteraction);
        this.mainPanel.setOpaque(false);
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 0));
        this.mainTextLabel = new JLabel(header);
        if (pinnedIcon == null) {
            pinnedIcon = this.getImageIconResource("/org/gradle/gradleplugin/userinterface/swing/generic/pin.png");
        }
        this.pinnedLabel = new JLabel(pinnedIcon);
        this.pinnedLabel.setVisible(this.isPinned());
        this.setupCloseLabel();
        this.mainPanel.add(this.mainTextLabel);
        this.mainPanel.add(Box.createHorizontalStrut(5));
        this.mainPanel.add(this.pinnedLabel);
        this.mainPanel.add(this.closeLabel);
    }

    private void setupCloseLabel() {
        if (closeIcon == null) {
            closeIcon = this.getImageIconResource("close.png");
            closeHighlightIcon = this.getImageIconResource("close-highlight.png");
        }
        this.closeLabel = new JLabel(closeIcon);
        this.closeLabel.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                OutputTab.this.closeLabel.setIcon(closeHighlightIcon);
            }

            public void mouseExited(MouseEvent e) {
                OutputTab.this.closeLabel.setIcon(closeIcon);
            }

            public void mouseClicked(MouseEvent e) {
                OutputTab.this.close();
            }
        });
    }

    private BufferedImage getImageResource(String imageResourceName) {
        InputStream inputStream = this.getClass().getResourceAsStream(imageResourceName);
        if (inputStream != null) {
            try {
                BufferedImage image = ImageIO.read(inputStream);
                return image;
            }
            catch (IOException e) {
                LOGGER.error("Reading image " + imageResourceName, (Throwable)e);
            }
        }
        return null;
    }

    private ImageIcon getImageIconResource(String imageIconResourceName) {
        BufferedImage image = this.getImageResource(imageIconResourceName);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    public void reset() {
        super.reset();
        this.closeLabel.setEnabled(true);
    }

    public Component getTabHeader() {
        return this.mainPanel;
    }

    public void setTabHeaderText(String newText) {
        this.mainTextLabel.setText(newText);
    }

    public boolean close() {
        this.closeLabel.setEnabled(false);
        boolean result = super.close();
        if (result) {
            this.closeLabel.setEnabled(true);
        }
        return result;
    }

    public void setPinned(boolean pinned) {
        this.pinnedLabel.setVisible(pinned);
        super.setPinned(pinned);
    }
}

