/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.api.LibraryVariant;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.LibraryVariantImpl;
import com.android.build.gradle.internal.api.LibraryVariantOutputImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.LibVariantOutputData;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.internal.reflect.Instantiator;

public class LibraryVariantFactory
implements VariantFactory {
    private Instantiator instantiator;
    private final AndroidConfig extension;
    private final AndroidBuilder androidBuilder;

    public LibraryVariantFactory(Instantiator instantiator, AndroidBuilder androidBuilder, AndroidConfig extension) {
        this.instantiator = instantiator;
        this.androidBuilder = androidBuilder;
        this.extension = extension;
    }

    @Override
    public BaseVariantData createVariantData(GradleVariantConfiguration variantConfiguration, TaskManager taskManager) {
        return new LibraryVariantData(this.extension, taskManager, variantConfiguration, this.androidBuilder.getErrorReporter());
    }

    @Override
    public LibraryVariant createVariantApi(BaseVariantData<? extends BaseVariantOutputData> variantData, ReadOnlyObjectProvider readOnlyObjectProvider) {
        LibraryVariantImpl variant = (LibraryVariantImpl)this.instantiator.newInstance(LibraryVariantImpl.class, new Object[]{variantData, this.androidBuilder, readOnlyObjectProvider});
        List<? extends BaseVariantOutputData> outputList = variantData.getOutputs();
        ArrayList apiOutputList = Lists.newArrayListWithCapacity((int)outputList.size());
        for (BaseVariantOutputData baseVariantOutputData : outputList) {
            LibVariantOutputData libOutput = (LibVariantOutputData)baseVariantOutputData;
            LibraryVariantOutputImpl output = (LibraryVariantOutputImpl)this.instantiator.newInstance(LibraryVariantOutputImpl.class, new Object[]{libOutput});
            apiOutputList.add(output);
        }
        variant.addOutputs((List)apiOutputList);
        return variant;
    }

    @Override
    public VariantType getVariantConfigurationType() {
        return VariantType.LIBRARY;
    }

    @Override
    public boolean isLibrary() {
        return true;
    }

    @Override
    public boolean hasTestScope() {
        return true;
    }

    @Override
    public void validateModel(VariantModel model) {
        if (model.getDefaultConfig().getProductFlavor().getApplicationId() != null) {
            throw new GradleException("Library projects cannot set applicationId. applicationId is set to '" + model.getDefaultConfig().getProductFlavor().getApplicationId() + "' in default config.");
        }
        if (model.getDefaultConfig().getProductFlavor().getApplicationIdSuffix() != null) {
            throw new GradleException("Library projects cannot set applicationIdSuffix. applicationIdSuffix is set to '" + model.getDefaultConfig().getProductFlavor().getApplicationIdSuffix() + "' in default config.");
        }
        for (BuildTypeData buildTypeData : model.getBuildTypes().values()) {
            if (buildTypeData.getBuildType().getApplicationIdSuffix() == null) continue;
            throw new GradleException("Library projects cannot set applicationIdSuffix. applicationIdSuffix is set to '" + buildTypeData.getBuildType().getApplicationIdSuffix() + "' in build type '" + buildTypeData.getBuildType().getName() + "'.");
        }
        for (ProductFlavorData productFlavorData : model.getProductFlavors().values()) {
            if (productFlavorData.getProductFlavor().getApplicationId() != null) {
                throw new GradleException("Library projects cannot set applicationId. applicationId is set to '" + productFlavorData.getProductFlavor().getApplicationId() + "' in flavor '" + productFlavorData.getProductFlavor().getName() + "'.");
            }
            if (productFlavorData.getProductFlavor().getApplicationIdSuffix() == null) continue;
            throw new GradleException("Library projects cannot set applicationIdSuffix. applicationIdSuffix is set to '" + productFlavorData.getProductFlavor().getApplicationIdSuffix() + "' in flavor '" + productFlavorData.getProductFlavor().getName() + "'.");
        }
    }

    @Override
    public void preVariantWork(Project project) {
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
        buildTypes.create("release");
    }
}

