/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.builder.testing.MockableJarGenerator;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class MockableAndroidJarTask
extends DefaultTask {
    private File mAndroidJar;
    private File mOutputFile;
    private boolean mReturnDefaultValues;

    @TaskAction
    public void createMockableJar() throws IOException {
        File outputFile = this.getOutputFile();
        if (outputFile.exists()) {
            return;
        }
        MockableJarGenerator generator = new MockableJarGenerator(this.getReturnDefaultValues());
        this.getLogger().info(String.format("Creating %s from %s.", outputFile.getAbsolutePath(), this.getAndroidJar().getAbsolutePath()));
        generator.createMockableJar(this.getAndroidJar(), outputFile);
    }

    @Input
    public boolean getReturnDefaultValues() {
        return this.mReturnDefaultValues;
    }

    public void setReturnDefaultValues(boolean returnDefaultValues) {
        this.mReturnDefaultValues = returnDefaultValues;
    }

    @OutputFile
    public File getOutputFile() {
        return this.mOutputFile;
    }

    public void setOutputFile(File outputFile) {
        this.mOutputFile = outputFile;
    }

    @InputFile
    public File getAndroidJar() {
        return this.mAndroidJar;
    }

    public void setAndroidJar(File androidJar) {
        this.mAndroidJar = androidJar;
    }

    public static class ConfigAction
    implements TaskConfigAction<MockableAndroidJarTask> {
        final GlobalScope scope;

        public ConfigAction(GlobalScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return "mockableAndroidJar";
        }

        @Override
        public Class<MockableAndroidJarTask> getType() {
            return MockableAndroidJarTask.class;
        }

        @Override
        public void execute(MockableAndroidJarTask task) {
            task.setGroup("build");
            task.setDescription("Creates a version of android.jar that's suitable for unit tests.");
            task.setReturnDefaultValues(this.scope.getExtension().getTestOptions().getUnitTests().isReturnDefaultValues());
            ConventionMappingHelper.map((Task)task, "androidJar", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    Preconditions.checkNotNull((Object)ConfigAction.this.scope.getAndroidBuilder().getTarget(), (Object)"ensureTargetSetup not called");
                    return new File(ConfigAction.this.scope.getAndroidBuilder().getTarget().getPath(1));
                }
            });
            task.setOutputFile(this.scope.getMockableAndroidJarFile());
        }
    }
}

