/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.google.common.base.Charsets;
import java.util.Locale;
import org.gradle.api.JavaVersion;

public class CompileOptions {
    private JavaVersion sourceCompatibility;
    private JavaVersion targetCompatibility;
    private String encoding = Charsets.UTF_8.name();
    private JavaVersion defaultJavaVersion = JavaVersion.VERSION_1_6;
    private boolean ndkCygwinMode = false;
    private static final String VERSION_PREFIX = "VERSION_";

    public void setSourceCompatibility(Object sourceCompatibility) {
        this.sourceCompatibility = CompileOptions.convert(sourceCompatibility);
    }

    public JavaVersion getSourceCompatibility() {
        return this.sourceCompatibility != null ? this.sourceCompatibility : this.defaultJavaVersion;
    }

    public void setTargetCompatibility(Object targetCompatibility) {
        this.targetCompatibility = CompileOptions.convert(targetCompatibility);
    }

    public JavaVersion getTargetCompatibility() {
        return this.targetCompatibility != null ? this.targetCompatibility : this.defaultJavaVersion;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setDefaultJavaVersion(JavaVersion defaultJavaVersion) {
        this.defaultJavaVersion = defaultJavaVersion;
    }

    public JavaVersion getDefaultJavaVersion() {
        return this.defaultJavaVersion;
    }

    private static JavaVersion convert(Object version) {
        String versionString;
        if (version instanceof String && (versionString = (String)version).toUpperCase(Locale.ENGLISH).startsWith(VERSION_PREFIX)) {
            version = versionString.substring(VERSION_PREFIX.length()).replace('_', '.');
        }
        return JavaVersion.toVersion((Object)version);
    }
}

