/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.profile.ExecutionType;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class ApplicationTaskManager
extends TaskManager {
    public ApplicationTaskManager(Project project, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, DependencyManager dependencyManager, ToolingModelBuilderRegistry toolingRegistry) {
        super(project, androidBuilder, dataBindingBuilder, extension, sdkHandler, dependencyManager, toolingRegistry);
    }

    @Override
    public void createTasksForVariantData(final TaskFactory tasks, final BaseVariantData<? extends BaseVariantOutputData> variantData) {
        assert (variantData instanceof ApplicationVariantData);
        ApplicationVariantData appVariantData = (ApplicationVariantData)variantData;
        final VariantScope variantScope = variantData.getScope();
        this.createAnchorTasks(tasks, variantScope);
        this.createCheckManifestTask(tasks, variantScope);
        this.handleMicroApp(tasks, variantScope);
        this.createDependencyStreams(variantScope);
        ThreadRecorder.get().record(ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_MANIFEST_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createMergeAppManifestsTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.APP_TASK_MANAGER_CREATE_GENERATE_RES_VALUES_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createGenerateResValuesTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.APP_TASK_MANAGER_CREATE_CREATE_RENDERSCRIPT_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createRenderscriptTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_RESOURCES_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createMergeResourcesTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_ASSETS_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createMergeAssetsTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.APP_TASK_MANAGER_CREATE_BUILD_CONFIG_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createBuildConfigTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.APP_TASK_MANAGER_CREATE_PROCESS_RES_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createProcessResTask(tasks, variantScope, true);
                ApplicationTaskManager.this.createProcessJavaResTasks(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.APP_TASK_MANAGER_CREATE_AIDL_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createAidlTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.APP_TASK_MANAGER_CREATE_COMPILE_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                AndroidTask<JavaCompile> javacTask = ApplicationTaskManager.this.createJavacTask(tasks, variantScope);
                if (variantData.getVariantConfiguration().getUseJack()) {
                    ApplicationTaskManager.this.createJackTask(tasks, variantScope);
                } else {
                    TaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
                    TaskManager.createJarTask(tasks, variantScope);
                    ApplicationTaskManager.this.createPostCompilationTasks(tasks, variantScope);
                }
                return null;
            }
        }, new Recorder.Property[0]);
        if (this.extension.getDataBinding().isEnabled()) {
            this.createDataBindingTasks(tasks, variantScope);
        }
        if (this.isNdkTaskNeeded) {
            ThreadRecorder.get().record(ExecutionType.APP_TASK_MANAGER_CREATE_NDK_TASK, (Recorder.Block)new Recorder.Block<Void>(){

                public Void call() {
                    ApplicationTaskManager.this.createNdkTasks(variantScope);
                    return null;
                }
            }, new Recorder.Property[0]);
        } else if (variantData.compileTask != null) {
            variantData.compileTask.dependsOn(new Object[]{this.getNdkBuildable(variantData)});
        } else {
            variantScope.getCompileTask().dependsOn(tasks, this.getNdkBuildable(variantData));
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        ThreadRecorder.get().record(ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_JNILIBS_FOLDERS_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createMergeJniLibFoldersTasks(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        if (variantData.getSplitHandlingPolicy().equals((Object)BaseVariantData.SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY)) {
            if (this.getExtension().getBuildToolsRevision().getMajor() < 21) {
                throw new RuntimeException("Pure splits can only be used with buildtools 21 and later");
            }
            ThreadRecorder.get().record(ExecutionType.APP_TASK_MANAGER_CREATE_SPLIT_TASK, (Recorder.Block)new Recorder.Block<Void>(){

                public Void call() {
                    ApplicationTaskManager.this.createSplitResourcesTasks(variantScope);
                    ApplicationTaskManager.this.createSplitAbiTasks(variantScope);
                    return null;
                }
            }, new Recorder.Property[0]);
        }
        ThreadRecorder.get().record(ExecutionType.APP_TASK_MANAGER_CREATE_PACKAGING_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createPackagingTask(tasks, variantScope, true);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.APP_TASK_MANAGER_CREATE_LINT_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createLintTasks(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
    }

    @Override
    protected Set<QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    private void handleMicroApp(TaskFactory tasks, VariantScope scope) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        if (((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isEmbedMicroApp()) {
            List<String> wearConfigNames = variantData.getWearConfigNames();
            for (String configName : wearConfigNames) {
                Configuration config = (Configuration)this.project.getConfigurations().findByName(configName);
                if (config == null) continue;
                Set file = config.getFiles();
                int count = file.size();
                if (count == 1) {
                    this.createGenerateMicroApkDataTask(tasks, scope, config);
                    return;
                }
                if (count <= 1) continue;
                throw new RuntimeException(String.format("Configuration '%s' resolves to more than one apk.", configName));
            }
        }
    }
}

