/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GroovyArgListSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(PsiElement e) {
        return e instanceof GrArgumentList || e.getParent() instanceof GrReferenceExpression && e.getParent().getParent() instanceof GrCall;
    }

    public List<TextRange> select(PsiElement element, CharSequence editorText, int cursorOffset, Editor editor) {
        PsiElement parent;
        GrArgumentList args;
        TextRange range;
        List result = super.select(element, editorText, cursorOffset, editor);
        if (element instanceof GrArgumentList && (range = (args = (GrArgumentList)element).getTextRange()).contains(cursorOffset)) {
            PsiElement leftParen = args.getLeftParen();
            PsiElement rightParen = args.getRightParen();
            if (leftParen != null) {
                int leftOffset = leftParen.getTextOffset();
                if (rightParen != null) {
                    if (leftOffset + 1 < rightParen.getTextOffset()) {
                        int rightOffset = rightParen.getTextRange().getEndOffset();
                        range = new TextRange(leftParen.getTextRange().getStartOffset() + 1, rightOffset - 1);
                        result.add(range);
                    }
                } else {
                    range = new TextRange(leftParen.getTextRange().getStartOffset() + 1, element.getTextRange().getEndOffset());
                    result.add(range);
                }
            }
        }
        if ((parent = element.getParent()) instanceof GrReferenceExpression) {
            GrArgumentList argumentList = ((GrCall)parent.getParent()).getArgumentList();
            PsiElement refName = ((GrReferenceExpression)parent).getReferenceNameElement();
            if (argumentList != null && refName == element) {
                result.add(new TextRange(refName.getTextRange().getStartOffset(), argumentList.getTextRange().getEndOffset()));
            }
        }
        return result;
    }
}

