/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.jps.incremental.groovy.JpsGroovySettings;

@State(name="GroovyCompilerProjectConfiguration", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/groovyc.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class GroovyCompilerConfiguration
implements PersistentStateComponent<JpsGroovySettings>,
Disposable {
    private String myConfigScript = "";
    private String myHeapSize = "400";
    private boolean myInvokeDynamic = false;
    public boolean transformsOk = false;
    private final ExcludedEntriesConfiguration myExcludeFromStubGeneration = new ExcludedEntriesConfiguration();

    public JpsGroovySettings getState() {
        JpsGroovySettings bean = new JpsGroovySettings();
        bean.heapSize = this.myHeapSize;
        bean.configScript = this.myConfigScript;
        bean.invokeDynamic = this.myInvokeDynamic;
        bean.transformsOk = this.transformsOk;
        this.myExcludeFromStubGeneration.writeExternal(bean.excludes);
        return bean;
    }

    public static ExcludesConfiguration getExcludeConfiguration(Project project) {
        return GroovyCompilerConfiguration.getInstance((Project)project).myExcludeFromStubGeneration;
    }

    public ExcludesConfiguration getExcludeFromStubGeneration() {
        return this.myExcludeFromStubGeneration;
    }

    public void loadState(JpsGroovySettings state) {
        this.myHeapSize = state.heapSize;
        this.myConfigScript = state.configScript;
        this.myInvokeDynamic = state.invokeDynamic;
        this.transformsOk = state.transformsOk;
        this.myExcludeFromStubGeneration.readExternal(state.excludes);
    }

    public static GroovyCompilerConfiguration getInstance(Project project) {
        return (GroovyCompilerConfiguration)ServiceManager.getService((Project)project, GroovyCompilerConfiguration.class);
    }

    public String getHeapSize() {
        return this.myHeapSize;
    }

    public boolean isInvokeDynamic() {
        return this.myInvokeDynamic;
    }

    public void setHeapSize(String heapSize) {
        this.myHeapSize = heapSize;
    }

    public void setInvokeDynamic(boolean invokeDynamic) {
        this.myInvokeDynamic = invokeDynamic;
    }

    public String getConfigScript() {
        return this.myConfigScript;
    }

    public void setConfigScript(String configScript) {
        this.myConfigScript = configScript;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myExcludeFromStubGeneration);
    }
}

