/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.wagon;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ResourceException;
import org.gradle.internal.resource.local.LocalResource;

public class RepositoryTransportWagonAdapter {
    private final RepositoryTransport transport;
    private final URI rootUri;

    public RepositoryTransportWagonAdapter(RepositoryTransport transport, URI rootUri) {
        this.transport = transport;
        this.rootUri = rootUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRemoteFile(File destination, String resourceName) throws ResourceException, ResourceDoesNotExistException {
        URI uriForResource = this.getUriForResource(resourceName);
        ExternalResource resource = this.transport.getRepository().getResource(uriForResource);
        if (resource == null) {
            return false;
        }
        try {
            resource.writeTo(destination);
        }
        finally {
            resource.close();
        }
        return true;
    }

    public void putRemoteFile(LocalResource localResource, String resourceName) throws IOException {
        this.transport.getRepository().withProgressLogging().put(localResource, this.getUriForResource(resourceName));
    }

    private URI getUriForResource(String resource) {
        ExternalResourceName resourceName = new ExternalResourceName(this.rootUri, resource);
        return resourceName.getUri();
    }
}

