/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.tool.reflection.InjectedBindingClass;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.TypeUtil;
import android.databinding.tool.reflection.annotation.AnnotationAnalyzer;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;

public abstract class ModelAnalyzer {
    public static final String[] LIST_CLASS_NAMES = new String[]{"java.util.List", "android.util.SparseArray", "android.util.SparseBooleanArray", "android.util.SparseIntArray", "android.util.SparseLongArray", "android.util.LongSparseArray", "android.support.v4.util.LongSparseArray"};
    public static final String MAP_CLASS_NAME = "java.util.Map";
    public static final String STRING_CLASS_NAME = "java.lang.String";
    public static final String OBJECT_CLASS_NAME = "java.lang.Object";
    public static final String OBSERVABLE_CLASS_NAME = "android.databinding.Observable";
    public static final String OBSERVABLE_LIST_CLASS_NAME = "android.databinding.ObservableList";
    public static final String OBSERVABLE_MAP_CLASS_NAME = "android.databinding.ObservableMap";
    public static final String[] OBSERVABLE_FIELDS = new String[]{"android.databinding.ObservableBoolean", "android.databinding.ObservableByte", "android.databinding.ObservableChar", "android.databinding.ObservableShort", "android.databinding.ObservableInt", "android.databinding.ObservableLong", "android.databinding.ObservableFloat", "android.databinding.ObservableDouble", "android.databinding.ObservableField", "android.databinding.ObservableParcelable"};
    public static final String VIEW_DATA_BINDING = "android.databinding.ViewDataBinding";
    public static final String VIEW_STUB_CLASS_NAME = "android.view.ViewStub";
    private ModelClass[] mListTypes;
    private ModelClass mMapType;
    private ModelClass mStringType;
    private ModelClass mObjectType;
    private ModelClass mObservableType;
    private ModelClass mObservableListType;
    private ModelClass mObservableMapType;
    private ModelClass[] mObservableFieldTypes;
    private ModelClass mViewBindingType;
    private ModelClass mViewStubType;
    private static ModelAnalyzer sAnalyzer;
    private final Map<String, InjectedBindingClass> mInjectedClasses = new HashMap<String, InjectedBindingClass>();

    protected void setInstance(ModelAnalyzer analyzer) {
        sAnalyzer = analyzer;
    }

    public ModelClass findCommonParentOf(ModelClass modelClass1, ModelClass modelClass2) {
        return this.findCommonParentOf(modelClass1, modelClass2, true);
    }

    public ModelClass findCommonParentOf(ModelClass modelClass1, ModelClass modelClass2, boolean failOnError) {
        ModelClass curr;
        for (curr = modelClass1; curr != null && !curr.isAssignableFrom(modelClass2); curr = curr.getSuperclass()) {
        }
        if (curr == null) {
            if (modelClass1.isObject() && modelClass2.isInterface()) {
                return modelClass1;
            }
            if (modelClass2.isObject() && modelClass1.isInterface()) {
                return modelClass2;
            }
            ModelClass primitive1 = modelClass1.unbox();
            ModelClass primitive2 = modelClass2.unbox();
            if (!modelClass1.equals(primitive1) || !modelClass2.equals(primitive2)) {
                return this.findCommonParentOf(primitive1, primitive2, failOnError);
            }
        }
        if (failOnError) {
            Preconditions.checkNotNull(curr, "must be able to find a common parent for " + modelClass1 + " and " + modelClass2, new Object[0]);
        }
        return curr;
    }

    public abstract ModelClass loadPrimitive(String var1);

    public static ModelAnalyzer getInstance() {
        return sAnalyzer;
    }

    public static void setProcessingEnvironment(ProcessingEnvironment processingEnvironment) {
        if (sAnalyzer != null) {
            throw new IllegalStateException("processing env is already created, you cannot change class loader after that");
        }
        L.d("setting processing env to %s", processingEnvironment);
        sAnalyzer = new AnnotationAnalyzer(processingEnvironment);
    }

    public String applyImports(String className, Map<String, String> imports) {
        String rest;
        String qualifier;
        int dotIndex;
        className = className.trim();
        int numDimensions = 0;
        String generic = null;
        while (className.endsWith("[]")) {
            ++numDimensions;
            className = className.substring(0, className.length() - 2);
        }
        int lastCharIndex = className.length() - 1;
        if ('>' == className.charAt(lastCharIndex)) {
            int open = className.indexOf(60);
            if (open == -1) {
                L.e("un-matching generic syntax for %s", className);
                return className;
            }
            generic = this.applyImports(className.substring(open + 1, lastCharIndex), imports);
            className = className.substring(0, open);
        }
        if ((dotIndex = className.indexOf(46)) == -1) {
            qualifier = className;
            rest = null;
        } else {
            qualifier = className.substring(0, dotIndex);
            rest = className.substring(dotIndex);
        }
        String expandedQualifier = imports.get(qualifier);
        String result = expandedQualifier != null ? (rest == null ? expandedQualifier : expandedQualifier + rest) : className;
        if (generic != null) {
            result = result + "<" + this.applyImports(generic, imports) + ">";
        }
        while (numDimensions-- > 0) {
            result = result + "[]";
        }
        return result;
    }

    public String getDefaultValue(String className) {
        if ("int".equals(className)) {
            return "0";
        }
        if ("short".equals(className)) {
            return "0";
        }
        if ("long".equals(className)) {
            return "0L";
        }
        if ("float".equals(className)) {
            return "0f";
        }
        if ("double".equals(className)) {
            return "0.0";
        }
        if ("boolean".equals(className)) {
            return "false";
        }
        if ("char".equals(className)) {
            return "'\\u0000'";
        }
        if ("byte".equals(className)) {
            return "0";
        }
        return "null";
    }

    public final ModelClass findClass(String className, Map<String, String> imports) {
        if (this.mInjectedClasses.containsKey(className)) {
            return this.mInjectedClasses.get(className);
        }
        return this.findClassInternal(className, imports);
    }

    public abstract ModelClass findClassInternal(String var1, Map<String, String> var2);

    public abstract ModelClass findClass(Class var1);

    public abstract TypeUtil createTypeUtil();

    public ModelClass injectViewDataBinding(String className, Map<String, String> variables2, Map<String, String> fields) {
        InjectedBindingClass injectedClass = new InjectedBindingClass(className, VIEW_DATA_BINDING, variables2, fields);
        this.mInjectedClasses.put(className, injectedClass);
        return injectedClass;
    }

    ModelClass[] getListTypes() {
        if (this.mListTypes == null) {
            this.mListTypes = new ModelClass[LIST_CLASS_NAMES.length];
            for (int i = 0; i < this.mListTypes.length; ++i) {
                ModelClass modelClass = this.findClass(LIST_CLASS_NAMES[i], null);
                if (modelClass == null) continue;
                this.mListTypes[i] = modelClass.erasure();
            }
        }
        return this.mListTypes;
    }

    public ModelClass getMapType() {
        if (this.mMapType == null) {
            this.mMapType = this.loadClassErasure(MAP_CLASS_NAME);
        }
        return this.mMapType;
    }

    ModelClass getStringType() {
        if (this.mStringType == null) {
            this.mStringType = this.findClass(STRING_CLASS_NAME, null);
        }
        return this.mStringType;
    }

    ModelClass getObjectType() {
        if (this.mObjectType == null) {
            this.mObjectType = this.findClass(OBJECT_CLASS_NAME, null);
        }
        return this.mObjectType;
    }

    ModelClass getObservableType() {
        if (this.mObservableType == null) {
            this.mObservableType = this.findClass(OBSERVABLE_CLASS_NAME, null);
        }
        return this.mObservableType;
    }

    ModelClass getObservableListType() {
        if (this.mObservableListType == null) {
            this.mObservableListType = this.loadClassErasure(OBSERVABLE_LIST_CLASS_NAME);
        }
        return this.mObservableListType;
    }

    ModelClass getObservableMapType() {
        if (this.mObservableMapType == null) {
            this.mObservableMapType = this.loadClassErasure(OBSERVABLE_MAP_CLASS_NAME);
        }
        return this.mObservableMapType;
    }

    ModelClass getViewDataBindingType() {
        if (this.mViewBindingType == null) {
            this.mViewBindingType = this.findClass(VIEW_DATA_BINDING, null);
        }
        return this.mViewBindingType;
    }

    protected ModelClass[] getObservableFieldTypes() {
        if (this.mObservableFieldTypes == null) {
            this.mObservableFieldTypes = new ModelClass[OBSERVABLE_FIELDS.length];
            for (int i = 0; i < OBSERVABLE_FIELDS.length; ++i) {
                this.mObservableFieldTypes[i] = this.loadClassErasure(OBSERVABLE_FIELDS[i]);
            }
        }
        return this.mObservableFieldTypes;
    }

    ModelClass getViewStubType() {
        if (this.mViewStubType == null) {
            this.mViewStubType = this.findClass(VIEW_STUB_CLASS_NAME, null);
        }
        return this.mViewStubType;
    }

    private ModelClass loadClassErasure(String className) {
        return this.findClass(className, null).erasure();
    }
}

