/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtilRt;
import java.io.File;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathUtil {
    private PathUtil() {
    }

    @Nullable
    public static String getLocalPath(@Nullable VirtualFile file) {
        if (file == null || !file.isValid()) {
            return null;
        }
        if (file.getFileSystem().getProtocol().equals("jar") && file.getParent() != null) {
            return null;
        }
        return PathUtil.getLocalPath(file.getPath());
    }

    @NotNull
    public static String getLocalPath(@NotNull String path2) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathUtil", "getLocalPath"));
        }
        String string = FileUtil.toSystemDependentName((String)StringUtil.trimEnd((String)path2, (String)"!/"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getLocalPath"));
        }
        return string;
    }

    @NotNull
    public static VirtualFile getLocalFile(@NotNull VirtualFile file) {
        VirtualFile localFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/PathUtil", "getLocalFile"));
        }
        if (!file.isValid()) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getLocalFile"));
            }
            return virtualFile;
        }
        if (file.getFileSystem() instanceof LocalFileProvider && (localFile = ((LocalFileProvider)((Object)file.getFileSystem())).getLocalVirtualFileFor(file)) != null) {
            VirtualFile virtualFile = localFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getLocalFile"));
            }
            return virtualFile;
        }
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getLocalFile"));
        }
        return virtualFile;
    }

    @NotNull
    public static String getJarPathForClass(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/PathUtil", "getJarPathForClass"));
        }
        String pathForClass = PathManager.getJarPathForClass((Class)aClass);
        assert (pathForClass != null) : aClass;
        String string = pathForClass;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getJarPathForClass"));
        }
        return string;
    }

    @NotNull
    public static String toPresentableUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/PathUtil", "toPresentableUrl"));
        }
        String string = PathUtil.getLocalPath(VirtualFileManager.extractPath(url));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "toPresentableUrl"));
        }
        return string;
    }

    public static String getCanonicalPath(@NonNls String path2) {
        return FileUtil.toCanonicalPath((String)path2);
    }

    @NotNull
    public static String getFileName(@NotNull String path2) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathUtil", "getFileName"));
        }
        String string = PathUtilRt.getFileName((String)path2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getFileName"));
        }
        return string;
    }

    @Nullable
    public static String getFileExtension(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/PathUtil", "getFileExtension"));
        }
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return name.substring(index + 1);
    }

    @NotNull
    public static String getParentPath(@NotNull String path2) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathUtil", "getParentPath"));
        }
        String string = PathUtilRt.getParentPath((String)path2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getParentPath"));
        }
        return string;
    }

    @NotNull
    public static String suggestFileName(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/PathUtil", "suggestFileName"));
        }
        String string = PathUtilRt.suggestFileName((String)text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "suggestFileName"));
        }
        return string;
    }

    @NotNull
    public static String suggestFileName(@NotNull String text, boolean allowDots, boolean allowSpaces) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/PathUtil", "suggestFileName"));
        }
        String string = PathUtilRt.suggestFileName((String)text, (boolean)allowDots, (boolean)allowSpaces);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "suggestFileName"));
        }
        return string;
    }

    public static boolean isValidFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/util/PathUtil", "isValidFileName"));
        }
        return PathUtilRt.isValidFileName((String)fileName);
    }

    @Contract(value="null -> null; !null -> !null")
    public static String toSystemIndependentName(@Nullable String path2) {
        return path2 == null ? null : FileUtilRt.toSystemIndependentName((String)path2);
    }

    @Contract(value="null -> null; !null -> !null")
    public static String toSystemDependentName(@Nullable String path2) {
        return path2 == null ? null : FileUtilRt.toSystemDependentName((String)path2);
    }

    @NotNull
    public static String driveLetterToLowerCase(@NotNull String path2) {
        File file;
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathUtil", "driveLetterToLowerCase"));
        }
        if (SystemInfo.isWindows && path2.length() >= 2 && Character.isUpperCase(path2.charAt(0)) && path2.charAt(1) == ':' && (file = new File(path2)).isAbsolute()) {
            String string = Character.toLowerCase(path2.charAt(0)) + path2.substring(1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "driveLetterToLowerCase"));
            }
            return string;
        }
        String string = path2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "driveLetterToLowerCase"));
        }
        return string;
    }

    @NotNull
    public static String makeFileName(@NotNull String name, @Nullable String extension) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/PathUtil", "makeFileName"));
        }
        String string = name + (StringUtil.isEmpty((String)extension) ? "" : "." + extension);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "makeFileName"));
        }
        return string;
    }
}

