/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.contentAnnotation;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.contentAnnotation.ContentAnnotationCache;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotation;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotationSettings;
import com.intellij.openapi.vcs.diff.DiffMixin;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.util.Date;
import org.jetbrains.annotations.Nullable;

public class VcsContentAnnotationImpl
implements VcsContentAnnotation {
    private final Project myProject;
    private final VcsContentAnnotationSettings mySettings;
    private final ContentAnnotationCache myContentAnnotationCache;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotationImpl");

    public static VcsContentAnnotation getInstance(Project project) {
        return ServiceManager.getService(project, VcsContentAnnotation.class);
    }

    public VcsContentAnnotationImpl(Project project, VcsContentAnnotationSettings settings, ContentAnnotationCache contentAnnotationCache) {
        this.myProject = project;
        this.mySettings = settings;
        this.myContentAnnotationCache = contentAnnotationCache;
    }

    @Override
    @Nullable
    public VcsRevisionNumber fileRecentlyChanged(VirtualFile vf) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance(this.myProject);
        AbstractVcs vcs = vcsManager.getVcsFor(vf);
        if (vcs == null) {
            return null;
        }
        if (vcs.getDiffProvider() instanceof DiffMixin) {
            VcsRevisionDescription description = ((DiffMixin)((Object)vcs.getDiffProvider())).getCurrentRevisionDescription(vf);
            Date date = description.getRevisionDate();
            return this.isRecent(date) ? description.getRevisionNumber() : null;
        }
        return null;
    }

    private boolean isRecent(Date date) {
        return date.getTime() > System.currentTimeMillis() - this.mySettings.getLimit();
    }

    @Override
    public boolean intervalRecentlyChanged(VirtualFile file, TextRange lineInterval, VcsRevisionNumber currentRevisionNumber) {
        FileAnnotation fileAnnotation;
        ThreeState isRecent;
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance(this.myProject);
        AbstractVcs vcs = vcsManager.getVcsFor(file);
        if (vcs == null || vcs.getDiffProvider() == null) {
            return false;
        }
        if (currentRevisionNumber == null) {
            currentRevisionNumber = vcs.getDiffProvider().getCurrentRevision(file);
            assert (currentRevisionNumber != null);
        }
        if (!ThreeState.UNSURE.equals((Object)(isRecent = this.myContentAnnotationCache.isRecent(file, vcs.getKeyInstanceMethod(), currentRevisionNumber, lineInterval, System.currentTimeMillis() - this.mySettings.getLimit())))) {
            return ThreeState.YES.equals((Object)isRecent);
        }
        try {
            fileAnnotation = vcs.getCachingAnnotationProvider().annotate(file);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            return false;
        }
        this.myContentAnnotationCache.register(file, vcs.getKeyInstanceMethod(), currentRevisionNumber, fileAnnotation);
        for (int i = lineInterval.getStartOffset(); i <= lineInterval.getEndOffset(); ++i) {
            Date lineDate = fileAnnotation.getLineDate(i);
            if (lineDate == null || !this.isRecent(lineDate)) continue;
            return true;
        }
        return false;
    }
}

