/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.SideEffectInstructionChecker;

public class EvaluationShrinker
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final boolean DEBUG_RESULTS = false;
    private static final boolean DEBUG = false;
    private static final int UNSUPPORTED = -1;
    private static final int NOP = 0;
    private static final int POP = 87;
    private static final int POP2 = 88;
    private static final int DUP = 89;
    private static final int DUP_X1 = 90;
    private static final int DUP_X2 = 91;
    private static final int DUP2 = 92;
    private static final int DUP2_X1 = 93;
    private static final int DUP2_X2 = 94;
    private static final int SWAP = 95;
    private static final int MOV_X2 = 22363;
    private static final int MOV2_X1 = 22621;
    private static final int MOV2_X2 = 22622;
    private static final int POP_X1 = 22367;
    private static final int POP_X2 = 5724253;
    private static final int POP_X3 = -1;
    private static final int POP2_X1 = 5789531;
    private static final int POP2_X2 = 0x58585E;
    private static final int POP3 = 22360;
    private static final int POP4 = 22616;
    private static final int POP_DUP = 22871;
    private static final int POP_SWAP_POP = 0x575F57;
    private static final int POP2_SWAP_POP = 5726040;
    private static final int SWAP_DUP_X1 = 23135;
    private static final int SWAP_DUP_X1_SWAP = 0x5F5A5F;
    private static final int SWAP_POP_DUP = 5855071;
    private static final int SWAP_POP_DUP_X1 = 5920607;
    private static final int DUP_X2_POP2 = 22619;
    private static final int DUP2_X1_POP3 = 5724253;
    private static final int DUP2_X2_POP3 = 5724254;
    private static final int DUP2_X2_SWAP_POP = 5726046;
    private final InstructionVisitor extraDeletedInstructionVisitor;
    private final InstructionVisitor extraAddedInstructionVisitor;
    private final PartialEvaluator partialEvaluator;
    private final PartialEvaluator simplePartialEvaluator = new PartialEvaluator();
    private final SideEffectInstructionChecker sideEffectInstructionChecker = new SideEffectInstructionChecker(true, true);
    private final MyUnusedParameterSimplifier unusedParameterSimplifier = new MyUnusedParameterSimplifier();
    private final MyProducerMarker producerMarker = new MyProducerMarker();
    private final MyVariableInitializationMarker variableInitializationMarker = new MyVariableInitializationMarker();
    private final MyStackConsistencyFixer stackConsistencyFixer = new MyStackConsistencyFixer();
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(false, false);
    private boolean[][] stacksNecessaryAfter = new boolean[1024][16];
    private boolean[][] stacksSimplifiedBefore = new boolean[1024][16];
    private boolean[] instructionsNecessary = new boolean[1024];
    private int maxMarkedOffset;

    public EvaluationShrinker() {
        this(new PartialEvaluator(), null, null);
    }

    public EvaluationShrinker(PartialEvaluator partialEvaluator, InstructionVisitor extraDeletedInstructionVisitor, InstructionVisitor extraAddedInstructionVisitor) {
        this.partialEvaluator = partialEvaluator;
        this.extraDeletedInstructionVisitor = extraDeletedInstructionVisitor;
        this.extraAddedInstructionVisitor = extraAddedInstructionVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while shrinking instructions after partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            System.err.println("Not optimizing this method");
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        Instruction instruction;
        int offset;
        this.initializeNecessary(codeAttribute);
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        this.simplePartialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int codeLength = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(codeLength);
        for (int offset2 = 0; offset2 < codeLength; ++offset2) {
            if (!this.partialEvaluator.isTraced(offset2)) continue;
            Instruction instruction2 = InstructionFactory.create(codeAttribute.code, offset2);
            instruction2.accept(clazz, method, codeAttribute, offset2, this.unusedParameterSimplifier);
        }
        this.maxMarkedOffset = -1;
        int superInitializationOffset = this.partialEvaluator.superInitializationOffset();
        if (superInitializationOffset != -2) {
            this.markInstruction(superInitializationOffset);
        }
        for (offset = 0; offset < codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset)) continue;
            instruction = InstructionFactory.create(codeAttribute.code, offset);
            if (instruction.opcode == -89 && ((BranchInstruction)instruction).branchOffset == 0) {
                this.markInstruction(offset);
                continue;
            }
            if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, instruction)) continue;
            this.markInstruction(offset);
        }
        while (this.maxMarkedOffset >= 0) {
            offset = this.maxMarkedOffset;
            this.maxMarkedOffset = offset - 1;
            if (!this.partialEvaluator.isTraced(offset)) continue;
            if (this.isInstructionNecessary(offset)) {
                instruction = InstructionFactory.create(codeAttribute.code, offset);
                instruction.accept(clazz, method, codeAttribute, offset, this.producerMarker);
            }
            this.markStraddlingBranches(offset, this.partialEvaluator.branchTargets(offset), true);
            this.markStraddlingBranches(offset, this.partialEvaluator.branchOrigins(offset), false);
        }
        for (offset = 0; offset < codeLength; ++offset) {
            if (!this.isInstructionNecessary(offset)) continue;
            instruction = InstructionFactory.create(codeAttribute.code, offset);
            instruction.accept(clazz, method, codeAttribute, offset, this.variableInitializationMarker);
        }
        this.maxMarkedOffset = codeLength - 1;
        while (this.maxMarkedOffset >= 0) {
            offset = this.maxMarkedOffset;
            this.maxMarkedOffset = offset - 1;
            if (!this.partialEvaluator.isTraced(offset)) continue;
            instruction = InstructionFactory.create(codeAttribute.code, offset);
            instruction.accept(clazz, method, codeAttribute, offset, this.stackConsistencyFixer);
            this.markStraddlingBranches(offset, this.partialEvaluator.branchTargets(offset), true);
            this.markStraddlingBranches(offset, this.partialEvaluator.branchOrigins(offset), false);
        }
        for (offset = 0; offset < codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset) || this.isInstructionNecessary(offset) || !this.isAllSmallerThanOrEqual(this.partialEvaluator.branchTargets(offset), offset) || this.isAnyUnnecessaryInstructionBranchingOver(this.lastNecessaryInstructionOffset(offset), offset)) continue;
            this.replaceByInfiniteLoop(clazz, offset);
        }
        for (offset = 0; offset < codeLength; ++offset) {
            int nextOffset;
            if (!this.isInstructionNecessary(offset) || !this.partialEvaluator.isSubroutineInvocation(offset) || this.isInstructionNecessary(nextOffset = offset + (instruction = InstructionFactory.create(codeAttribute.code, offset)).length(offset))) continue;
            this.replaceByInfiniteLoop(clazz, nextOffset);
        }
        offset = 0;
        do {
            instruction = InstructionFactory.create(codeAttribute.code, offset);
            if (this.isInstructionNecessary(offset)) continue;
            this.codeAttributeEditor.clearModifications(offset);
            this.codeAttributeEditor.deleteInstruction(offset);
            if (this.extraDeletedInstructionVisitor == null) continue;
            instruction.accept(clazz, method, codeAttribute, offset, this.extraDeletedInstructionVisitor);
        } while ((offset += instruction.length(offset)) < codeLength);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    private void markVariableProducers(int consumerOffset, int variableIndex) {
        InstructionOffsetValue producerOffsets = this.partialEvaluator.getVariablesBefore(consumerOffset).getProducerValue(variableIndex).instructionOffsetValue();
        if (producerOffsets != null) {
            int offsetCount = producerOffsets.instructionOffsetCount();
            for (int offsetIndex = 0; offsetIndex < offsetCount; ++offsetIndex) {
                int offset = producerOffsets.instructionOffset(offsetIndex);
                this.markInstruction(offset);
            }
        }
    }

    private void markVariableInitializersBefore(int consumerOffset, int variableIndex) {
        InstructionOffsetValue producerOffsets = this.simplePartialEvaluator.getVariablesBefore(consumerOffset).getProducerValue(variableIndex).instructionOffsetValue();
        int offsetCount = producerOffsets.instructionOffsetCount();
        for (int offsetIndex = 0; offsetIndex < offsetCount; ++offsetIndex) {
            int producerOffset = producerOffsets.instructionOffset(offsetIndex);
            if (producerOffset >= consumerOffset) continue;
            this.markVariableInitializersAfter(producerOffset, variableIndex);
        }
    }

    private void markVariableInitializersAfter(int producerOffset, int variableIndex) {
        if (!this.isInstructionNecessary(producerOffset)) {
            if (this.isVariableInitialization(producerOffset, variableIndex)) {
                this.markInstruction(producerOffset);
            } else {
                this.markVariableInitializersBefore(producerOffset, variableIndex);
            }
        }
    }

    private void markStackProducers(Clazz clazz, int consumerOffset, Instruction consumer) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(consumerOffset);
        int stackSize = tracedStack.size();
        int popCount = consumer.stackPopCount(clazz);
        for (int stackIndex = stackSize - popCount; stackIndex < stackSize; ++stackIndex) {
            this.markStackEntryProducers(consumerOffset, stackIndex);
        }
    }

    private void conditionallyMarkStackEntryProducers(int consumerOffset, int consumerTopStackIndex, int producerTopStackIndex) {
        int consumerBottomStackIndex = this.partialEvaluator.getStackAfter(consumerOffset).size() - consumerTopStackIndex - 1;
        if (this.isStackEntryNecessaryAfter(consumerOffset, consumerBottomStackIndex)) {
            int producerBottomStackIndex = this.partialEvaluator.getStackBefore(consumerOffset).size() - producerTopStackIndex - 1;
            this.markStackEntryProducers(consumerOffset, producerBottomStackIndex);
        }
    }

    private void markStackEntryProducers(int consumerOffset, int stackIndex) {
        if (!this.isStackSimplifiedBefore(consumerOffset, stackIndex)) {
            this.markStackEntryProducers(this.partialEvaluator.getStackBefore(consumerOffset).getBottomProducerValue(stackIndex).instructionOffsetValue(), stackIndex);
        }
    }

    private void markStackEntryProducers(InstructionOffsetValue producerOffsets, int stackIndex) {
        if (producerOffsets != null) {
            int offsetCount = producerOffsets.instructionOffsetCount();
            for (int offsetIndex = 0; offsetIndex < offsetCount; ++offsetIndex) {
                int offset = producerOffsets.instructionOffset(offsetIndex);
                this.markStackEntryAfter(offset, stackIndex);
                this.markInstruction(offset);
            }
        }
    }

    private void markInitialization(int newInstructionOffset) {
        int initializationOffset = this.partialEvaluator.initializationOffset(newInstructionOffset);
        TracedStack tracedStack = this.partialEvaluator.getStackAfter(newInstructionOffset);
        this.markStackEntryAfter(initializationOffset, tracedStack.size() - 1);
        this.markInstruction(initializationOffset);
    }

    private void markStraddlingBranches(int instructionOffset, InstructionOffsetValue branchOffsets, boolean isPointingToTargets) {
        if (branchOffsets != null) {
            int branchCount = branchOffsets.instructionOffsetCount();
            for (int branchIndex = 0; branchIndex < branchCount; ++branchIndex) {
                int branchOffset = branchOffsets.instructionOffset(branchIndex);
                if (isPointingToTargets) {
                    this.markStraddlingBranch(instructionOffset, branchOffset, instructionOffset, branchOffset);
                    continue;
                }
                this.markStraddlingBranch(instructionOffset, branchOffset, branchOffset, instructionOffset);
            }
        }
    }

    private void markStraddlingBranch(int instructionOffsetStart, int instructionOffsetEnd, int branchOrigin, int branchTarget) {
        if (!this.isInstructionNecessary(branchOrigin) && this.isAnyInstructionNecessary(instructionOffsetStart, instructionOffsetEnd)) {
            this.markInstruction(branchOrigin);
        }
    }

    private void insertPushInstructions(int offset, boolean replace, boolean before, int computationalType) {
        this.markInstruction(offset);
        SimpleInstruction replacementInstruction = new SimpleInstruction(this.pushOpcode(computationalType));
        this.insertInstruction(offset, replace, before, replacementInstruction);
    }

    private byte pushOpcode(int computationalType) {
        switch (computationalType) {
            case 1: {
                return 3;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 14;
            }
            case 5: 
            case 6: {
                return 1;
            }
        }
        throw new IllegalArgumentException("No push opcode for computational type [" + computationalType + "]");
    }

    private void insertPopInstructions(int offset, boolean replace, boolean before, int popCount) {
        this.markInstruction(offset);
        switch (popCount) {
            case 1: {
                SimpleInstruction popInstruction = new SimpleInstruction(87);
                this.insertInstruction(offset, replace, before, popInstruction);
                break;
            }
            case 2: {
                SimpleInstruction popInstruction = new SimpleInstruction(88);
                this.insertInstruction(offset, replace, before, popInstruction);
                break;
            }
            default: {
                Instruction[] popInstructions = new Instruction[popCount / 2 + popCount % 2];
                SimpleInstruction popInstruction = new SimpleInstruction(88);
                for (int index = 0; index < popCount / 2; ++index) {
                    popInstructions[index] = popInstruction;
                }
                if (popCount % 2 == 1) {
                    popInstruction = new SimpleInstruction(87);
                    popInstructions[popCount / 2] = popInstruction;
                }
                this.insertInstructions(offset, replace, before, popInstruction, popInstructions);
                break;
            }
        }
    }

    private void insertInstruction(int offset, boolean replace, boolean before, Instruction instruction) {
        if (replace) {
            this.codeAttributeEditor.replaceInstruction(offset, instruction);
        } else {
            if (before) {
                this.codeAttributeEditor.insertBeforeInstruction(offset, instruction);
            } else {
                this.codeAttributeEditor.insertAfterInstruction(offset, instruction);
            }
            if (this.extraAddedInstructionVisitor != null) {
                instruction.accept(null, null, null, offset, this.extraAddedInstructionVisitor);
            }
        }
    }

    private void insertInstructions(int offset, boolean replace, boolean before, Instruction instruction, Instruction[] instructions) {
        block5: {
            block4: {
                if (!replace) break block4;
                this.codeAttributeEditor.replaceInstruction(offset, instructions);
                if (this.extraAddedInstructionVisitor == null) break block5;
                for (int index = 1; index < instructions.length; ++index) {
                    instructions[index].accept(null, null, null, offset, this.extraAddedInstructionVisitor);
                }
                break block5;
            }
            if (before) {
                this.codeAttributeEditor.insertBeforeInstruction(offset, instructions);
            } else {
                this.codeAttributeEditor.insertAfterInstruction(offset, instructions);
            }
            for (int index = 0; index < instructions.length; ++index) {
                if (this.extraAddedInstructionVisitor == null) continue;
                instructions[index].accept(null, null, null, offset, this.extraAddedInstructionVisitor);
            }
        }
    }

    private void replaceByStaticInvocation(Clazz clazz, int offset, ConstantInstruction constantInstruction) {
        ConstantInstruction replacementInstruction = new ConstantInstruction(-72, constantInstruction.constantIndex);
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
    }

    private void replaceByInfiniteLoop(Clazz clazz, int offset) {
        this.markInstruction(offset);
        BranchInstruction replacementInstruction = new BranchInstruction(-89, 0);
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
    }

    private boolean isDupOrSwap(Instruction instruction) {
        return instruction.opcode >= 89 && instruction.opcode <= 95;
    }

    private boolean isPop(Instruction instruction) {
        return instruction.opcode == 87 || instruction.opcode == 88;
    }

    private boolean isAnyUnnecessaryInstructionBranchingOver(int instructionOffset1, int instructionOffset2) {
        for (int offset = instructionOffset1; offset < instructionOffset2; ++offset) {
            if (!this.partialEvaluator.isTraced(offset) || this.isInstructionNecessary(offset) || !this.isAnyLargerThan(this.partialEvaluator.branchTargets(offset), instructionOffset2)) continue;
            return true;
        }
        return false;
    }

    private boolean isAllSmallerThanOrEqual(InstructionOffsetValue instructionOffsets, int instructionOffset) {
        int branchCount;
        if (instructionOffsets != null && (branchCount = instructionOffsets.instructionOffsetCount()) > 0) {
            for (int branchIndex = 0; branchIndex < branchCount; ++branchIndex) {
                if (instructionOffsets.instructionOffset(branchIndex) <= instructionOffset) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isAnyLargerThan(InstructionOffsetValue instructionOffsets, int instructionOffset) {
        int branchCount;
        if (instructionOffsets != null && (branchCount = instructionOffsets.instructionOffsetCount()) > 0) {
            for (int branchIndex = 0; branchIndex < branchCount; ++branchIndex) {
                if (instructionOffsets.instructionOffset(branchIndex) <= instructionOffset) continue;
                return true;
            }
        }
        return false;
    }

    private void initializeNecessary(CodeAttribute codeAttribute) {
        int offset;
        int codeLength = codeAttribute.u4codeLength;
        int maxLocals = codeAttribute.u2maxLocals;
        int maxStack = codeAttribute.u2maxStack;
        if (this.stacksNecessaryAfter.length < codeLength || this.stacksNecessaryAfter[0].length < maxStack) {
            this.stacksNecessaryAfter = new boolean[codeLength][maxStack];
        } else {
            for (offset = 0; offset < codeLength; ++offset) {
                Arrays.fill(this.stacksNecessaryAfter[offset], 0, maxStack, false);
            }
        }
        if (this.stacksSimplifiedBefore.length < codeLength || this.stacksSimplifiedBefore[0].length < maxStack) {
            this.stacksSimplifiedBefore = new boolean[codeLength][maxStack];
        } else {
            for (offset = 0; offset < codeLength; ++offset) {
                Arrays.fill(this.stacksSimplifiedBefore[offset], 0, maxStack, false);
            }
        }
        if (this.instructionsNecessary.length < codeLength) {
            this.instructionsNecessary = new boolean[codeLength];
        } else {
            Arrays.fill(this.instructionsNecessary, 0, codeLength, false);
        }
    }

    private boolean isVariableInitialization(int instructionOffset, int variableIndex) {
        Value valueBefore = this.simplePartialEvaluator.getVariablesBefore(instructionOffset).getValue(variableIndex);
        if (valueBefore == null) {
            return true;
        }
        Value valueAfter = this.simplePartialEvaluator.getVariablesAfter(instructionOffset).getValue(variableIndex);
        if (valueAfter.computationalType() != valueBefore.computationalType()) {
            return true;
        }
        if (!(valueAfter.computationalType() != 5 || valueAfter.referenceValue().isNull() != 1 && valueAfter.referenceValue().getType().equals(valueBefore.referenceValue().getType()))) {
            return true;
        }
        Value producersBefore = this.simplePartialEvaluator.getVariablesBefore(instructionOffset).getProducerValue(variableIndex);
        return producersBefore.instructionOffsetValue().instructionOffsetCount() == 1 && producersBefore.instructionOffsetValue().instructionOffset(0) == -1;
    }

    private void markStackEntryAfter(int instructionOffset, int stackIndex) {
        if (!this.isStackEntryNecessaryAfter(instructionOffset, stackIndex)) {
            this.stacksNecessaryAfter[instructionOffset][stackIndex] = true;
            if (this.maxMarkedOffset < instructionOffset) {
                this.maxMarkedOffset = instructionOffset;
            }
        }
    }

    private boolean isStackEntriesPresentBefore(int instructionOffset, int stackIndex1, int stackIndex2) {
        boolean present1 = this.isStackEntryPresentBefore(instructionOffset, stackIndex1);
        boolean present2 = this.isStackEntryPresentBefore(instructionOffset, stackIndex2);
        return present1 || present2;
    }

    private boolean isStackEntryPresentBefore(int instructionOffset, int stackIndex) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(instructionOffset);
        InstructionOffsetValue producerOffsets = tracedStack.getBottomProducerValue(stackIndex).instructionOffsetValue();
        return this.isAnyStackEntryNecessaryAfter(producerOffsets, stackIndex);
    }

    private boolean isStackEntriesNecessaryAfter(int instructionOffset, int stackIndex1, int stackIndex2) {
        boolean present1 = this.isStackEntryNecessaryAfter(instructionOffset, stackIndex1);
        boolean present2 = this.isStackEntryNecessaryAfter(instructionOffset, stackIndex2);
        return present1 || present2;
    }

    private boolean isAnyStackEntryNecessaryAfter(InstructionOffsetValue instructionOffsets, int stackIndex) {
        int offsetCount = instructionOffsets.instructionOffsetCount();
        for (int offsetIndex = 0; offsetIndex < offsetCount; ++offsetIndex) {
            if (!this.isStackEntryNecessaryAfter(instructionOffsets.instructionOffset(offsetIndex), stackIndex)) continue;
            return true;
        }
        return false;
    }

    private boolean isStackEntryNecessaryAfter(int instructionOffset, int stackIndex) {
        return instructionOffset == -1 || this.stacksNecessaryAfter[instructionOffset][stackIndex];
    }

    private void markStackSimplificationBefore(int instructionOffset, int stackIndex) {
        this.stacksSimplifiedBefore[instructionOffset][stackIndex] = true;
    }

    private boolean isStackSimplifiedBefore(int instructionOffset, int stackIndex) {
        return this.stacksSimplifiedBefore[instructionOffset][stackIndex];
    }

    private void markInstruction(int instructionOffset) {
        if (!this.isInstructionNecessary(instructionOffset)) {
            this.instructionsNecessary[instructionOffset] = true;
            if (this.maxMarkedOffset < instructionOffset) {
                this.maxMarkedOffset = instructionOffset;
            }
        }
    }

    private boolean isAnyInstructionNecessary(int instructionOffset1, int instructionOffset2) {
        for (int instructionOffset = instructionOffset1; instructionOffset < instructionOffset2; ++instructionOffset) {
            if (!this.isInstructionNecessary(instructionOffset)) continue;
            return true;
        }
        return false;
    }

    private int lastNecessaryInstructionOffset(int instructionOffset) {
        for (int offset = instructionOffset - 1; offset >= 0; --offset) {
            if (!this.isInstructionNecessary(instructionOffset)) continue;
            return offset;
        }
        return 0;
    }

    private boolean isInstructionNecessary(int instructionOffset) {
        return instructionOffset == -1 || this.instructionsNecessary[instructionOffset];
    }

    private class MyStackConsistencyFixer
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyStackConsistencyFixer() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            if (EvaluationShrinker.this.isInstructionNecessary(offset)) {
                int pushCount;
                InstructionOffsetValue branchTargets;
                int popCount = instruction.stackPopCount(clazz);
                if (popCount > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackBefore(offset);
                    int stackSize = tracedStack.size();
                    int requiredPopCount = 0;
                    int requiredPushCount = 0;
                    for (int stackIndex = stackSize - popCount; stackIndex < stackSize; ++stackIndex) {
                        boolean stackSimplifiedBefore = EvaluationShrinker.this.isStackSimplifiedBefore(offset, stackIndex);
                        boolean stackEntryPresentBefore = EvaluationShrinker.this.isStackEntryPresentBefore(offset, stackIndex);
                        if (stackSimplifiedBefore) {
                            if (!EvaluationShrinker.this.isStackEntryPresentBefore(offset, stackIndex)) continue;
                            EvaluationShrinker.this.markStackEntryProducers(offset, stackIndex);
                            ++requiredPopCount;
                            continue;
                        }
                        if (stackEntryPresentBefore) {
                            EvaluationShrinker.this.markStackEntryProducers(offset, stackIndex);
                            continue;
                        }
                        ++requiredPushCount;
                    }
                    if (requiredPopCount > 0) {
                        EvaluationShrinker.this.insertPopInstructions(offset, false, true, popCount);
                    }
                    if (requiredPushCount > 0) {
                        if (requiredPushCount > (instruction.isCategory2() ? 2 : 1)) {
                            throw new IllegalArgumentException("Unsupported stack size increment [" + requiredPushCount + "] at [" + offset + "]");
                        }
                        EvaluationShrinker.this.insertPushInstructions(offset, false, true, tracedStack.getTop(0).computationalType());
                    }
                }
                if ((branchTargets = EvaluationShrinker.this.partialEvaluator.branchTargets(offset)) != null && branchTargets.instructionOffsetCount() == 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackBefore(offset);
                    int unpoppedStackSize = tracedStack.size() - popCount;
                    for (int stackIndex = 0; stackIndex < unpoppedStackSize; ++stackIndex) {
                        if (!EvaluationShrinker.this.isStackEntryPresentBefore(offset, stackIndex)) continue;
                        EvaluationShrinker.this.markStackEntryProducers(offset, stackIndex);
                    }
                }
                if ((pushCount = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackAfter(offset);
                    int stackSize = tracedStack.size();
                    int requiredPopCount = 0;
                    for (int stackIndex = stackSize - pushCount; stackIndex < stackSize; ++stackIndex) {
                        if (EvaluationShrinker.this.isStackEntryNecessaryAfter(offset, stackIndex)) continue;
                        ++requiredPopCount;
                    }
                    if (requiredPopCount > 0) {
                        EvaluationShrinker.this.insertPopInstructions(offset, false, false, requiredPopCount);
                    }
                }
            } else {
                int pushCount;
                int popCount = instruction.stackPopCount(clazz);
                if (popCount > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackBefore(offset);
                    int stackSize = tracedStack.size();
                    int expectedPopCount = 0;
                    for (int stackIndex = stackSize - popCount; stackIndex < stackSize; ++stackIndex) {
                        if (!EvaluationShrinker.this.isStackEntryPresentBefore(offset, stackIndex)) continue;
                        EvaluationShrinker.this.markStackEntryProducers(offset, stackIndex);
                        ++expectedPopCount;
                    }
                    if (expectedPopCount > 0) {
                        EvaluationShrinker.this.insertPopInstructions(offset, true, false, expectedPopCount);
                    }
                }
                if ((pushCount = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackAfter(offset);
                    int stackSize = tracedStack.size();
                    int expectedPushCount = 0;
                    for (int stackIndex = stackSize - pushCount; stackIndex < stackSize; ++stackIndex) {
                        if (!EvaluationShrinker.this.isStackEntryNecessaryAfter(offset, stackIndex)) continue;
                        ++expectedPushCount;
                    }
                    if (expectedPushCount > 0) {
                        EvaluationShrinker.this.insertPushInstructions(offset, true, false, tracedStack.getTop(0).computationalType());
                    }
                }
            }
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            if (EvaluationShrinker.this.isInstructionNecessary(offset) && EvaluationShrinker.this.isDupOrSwap(simpleInstruction)) {
                int topAfter;
                int topBefore;
                byte oldOpcode;
                int newOpcodes;
                int stackSizeBefore = EvaluationShrinker.this.partialEvaluator.getStackBefore(offset).size();
                int popCount = simpleInstruction.stackPopCount(clazz);
                if (popCount > 0) {
                    for (int stackIndex = stackSizeBefore - popCount; stackIndex < stackSizeBefore; ++stackIndex) {
                        if (!EvaluationShrinker.this.isStackEntryPresentBefore(offset, stackIndex)) continue;
                        EvaluationShrinker.this.markStackEntryProducers(offset, stackIndex);
                    }
                }
                if ((newOpcodes = this.fixDupSwap(offset, oldOpcode = simpleInstruction.opcode, topBefore = stackSizeBefore - 1, topAfter = EvaluationShrinker.this.partialEvaluator.getStackAfter(offset).size() - 1)) == -1) {
                    throw new UnsupportedOperationException("Can't handle " + simpleInstruction.toString() + " instruction at [" + offset + "]");
                }
                if ((newOpcodes & 0xFFFFFF00) == 0) {
                    byte newOpcode = (byte)newOpcodes;
                    if (newOpcode == 0) {
                        EvaluationShrinker.this.codeAttributeEditor.deleteInstruction(offset);
                        if (EvaluationShrinker.this.extraDeletedInstructionVisitor != null) {
                            EvaluationShrinker.this.extraDeletedInstructionVisitor.visitSimpleInstruction(null, null, null, offset, null);
                        }
                    } else if (newOpcode == oldOpcode) {
                        EvaluationShrinker.this.codeAttributeEditor.undeleteInstruction(offset);
                    } else {
                        SimpleInstruction replacementInstruction = new SimpleInstruction(newOpcode);
                        EvaluationShrinker.this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
                    }
                } else {
                    Instruction[] replacementInstructions = new Instruction[4];
                    int count = 0;
                    while (newOpcodes != 0) {
                        SimpleInstruction replacementInstruction = new SimpleInstruction((byte)newOpcodes);
                        replacementInstructions[count++] = replacementInstruction;
                        newOpcodes >>>= 8;
                    }
                    if (count < 4) {
                        Instruction[] newInstructions = new Instruction[count];
                        System.arraycopy(replacementInstructions, 0, newInstructions, 0, count);
                        replacementInstructions = newInstructions;
                    }
                    EvaluationShrinker.this.codeAttributeEditor.replaceInstruction(offset, replacementInstructions);
                }
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, offset, simpleInstruction);
            }
        }

        private int fixDupSwap(int instructionOffset, byte dupSwapOpcode, int topBefore, int topAfter) {
            switch (dupSwapOpcode) {
                case 89: {
                    return this.fixedDup(instructionOffset, topBefore, topAfter);
                }
                case 90: {
                    return this.fixedDup_x1(instructionOffset, topBefore, topAfter);
                }
                case 91: {
                    return this.fixedDup_x2(instructionOffset, topBefore, topAfter);
                }
                case 92: {
                    return this.fixedDup2(instructionOffset, topBefore, topAfter);
                }
                case 93: {
                    return this.fixedDup2_x1(instructionOffset, topBefore, topAfter);
                }
                case 94: {
                    return this.fixedDup2_x2(instructionOffset, topBefore, topAfter);
                }
                case 95: {
                    return this.fixedSwap(instructionOffset, topBefore, topAfter);
                }
            }
            throw new IllegalArgumentException("Not a dup/swap opcode [" + dupSwapOpcode + "]");
        }

        private int fixedDup(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.isStackEntryPresentBefore(instructionOffset, topBefore - 0);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 0);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            return stackEntryNecessary0 ? (stackEntryNecessary1 ? 89 : 0) : (stackEntryNecessary1 ? 0 : (stackEntryPresent0 ? 87 : 0));
        }

        private int fixedDup_x1(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.isStackEntryPresentBefore(instructionOffset, topBefore - 0);
            boolean stackEntryPresent1 = EvaluationShrinker.this.isStackEntryPresentBefore(instructionOffset, topBefore - 1);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 0);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            boolean stackEntryNecessary2 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 2);
            return stackEntryNecessary1 ? (stackEntryNecessary2 ? (stackEntryNecessary0 ? 90 : 95) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))) : (stackEntryPresent1 ? (stackEntryNecessary2 ? (stackEntryNecessary0 ? 5855071 : 22367) : (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87))) : (stackEntryNecessary2 ? (stackEntryNecessary0 ? 89 : 0) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))));
        }

        private int fixedDup_x2(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.isStackEntryPresentBefore(instructionOffset, topBefore - 0);
            boolean stackEntryPresent1 = EvaluationShrinker.this.isStackEntryPresentBefore(instructionOffset, topBefore - 1);
            boolean stackEntryPresent2 = EvaluationShrinker.this.isStackEntryPresentBefore(instructionOffset, topBefore - 2);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 0);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            boolean stackEntryNecessary2 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 2);
            boolean stackEntryNecessary3 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 3);
            return stackEntryNecessary1 ? (stackEntryNecessary2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? 91 : 22363) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))) : (stackEntryPresent2 ? (stackEntryNecessary3 ? -1 : (stackEntryNecessary0 ? 5724253 : (stackEntryPresent0 ? 0x575F57 : 22367))) : (stackEntryNecessary3 ? (stackEntryNecessary0 ? 90 : 95) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))))) : (stackEntryPresent1 ? (stackEntryNecessary2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? 5920607 : 22619) : (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87))) : (stackEntryPresent2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? -1 : 5789531) : (stackEntryNecessary0 ? 5789531 : (stackEntryPresent0 ? 22360 : 88))) : (stackEntryNecessary3 ? (stackEntryNecessary0 ? 5855071 : 22367) : (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87))))) : (stackEntryNecessary2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? 90 : 95) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))) : (stackEntryPresent2 ? (stackEntryNecessary3 ? (stackEntryNecessary0 ? 5855071 : 22367) : (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87))) : (stackEntryNecessary3 ? (stackEntryNecessary0 ? 89 : 0) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0))))));
        }

        private int fixedDup2(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.isStackEntryPresentBefore(instructionOffset, topBefore - 0);
            boolean stackEntryPresent1 = EvaluationShrinker.this.isStackEntryPresentBefore(instructionOffset, topBefore - 1);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 0);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            boolean stackEntryNecessary2 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 2);
            boolean stackEntryNecessary3 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 3);
            return stackEntryNecessary3 ? (stackEntryNecessary2 ? (stackEntryNecessary1 ? (stackEntryNecessary0 ? 92 : 23135) : (stackEntryNecessary0 ? 89 : 0)) : (stackEntryNecessary1 ? (stackEntryNecessary0 ? 0x5F5A5F : (stackEntryPresent0 ? 22871 : 89)) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0)))) : (stackEntryNecessary2 ? (stackEntryNecessary1 ? (stackEntryNecessary0 ? 90 : 95) : (stackEntryPresent1 ? (stackEntryNecessary0 ? 5855071 : 22367) : (stackEntryNecessary0 ? 87 : 0))) : (stackEntryNecessary1 ? (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0)) : (stackEntryPresent1 ? (stackEntryNecessary0 ? 22367 : (stackEntryPresent0 ? 88 : 87)) : (stackEntryNecessary0 ? 0 : (stackEntryPresent0 ? 87 : 0)))));
        }

        private int fixedDup2_x1(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntriesPresent01 = EvaluationShrinker.this.isStackEntriesPresentBefore(instructionOffset, topBefore - 0, topBefore - 1);
            boolean stackEntryPresent2 = EvaluationShrinker.this.isStackEntryPresentBefore(instructionOffset, topBefore - 2);
            boolean stackEntriesNecessary01 = EvaluationShrinker.this.isStackEntriesNecessaryAfter(instructionOffset, topAfter - 0, topAfter - 1);
            boolean stackEntryNecessary2 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 2);
            boolean stackEntriesNecessary34 = EvaluationShrinker.this.isStackEntriesNecessaryAfter(instructionOffset, topAfter - 3, topAfter - 4);
            return stackEntryNecessary2 ? (stackEntriesNecessary34 ? (stackEntriesNecessary01 ? 93 : 22621) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))) : (stackEntryPresent2 ? (stackEntriesNecessary34 ? (stackEntriesNecessary01 ? -1 : 5724253) : (stackEntriesNecessary01 ? 5724253 : (stackEntriesPresent01 ? 22360 : 87))) : (stackEntriesNecessary34 ? (stackEntriesNecessary01 ? 92 : 0) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))));
        }

        private int fixedDup2_x2(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntriesPresent01 = EvaluationShrinker.this.isStackEntriesPresentBefore(instructionOffset, topBefore - 0, topBefore - 1);
            boolean stackEntryPresent2 = EvaluationShrinker.this.isStackEntryPresentBefore(instructionOffset, topBefore - 2);
            boolean stackEntryPresent3 = EvaluationShrinker.this.isStackEntryPresentBefore(instructionOffset, topBefore - 3);
            boolean stackEntriesNecessary01 = EvaluationShrinker.this.isStackEntriesNecessaryAfter(instructionOffset, topAfter - 0, topAfter - 1);
            boolean stackEntryNecessary2 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 2);
            boolean stackEntryNecessary3 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 3);
            boolean stackEntriesNecessary45 = EvaluationShrinker.this.isStackEntriesNecessaryAfter(instructionOffset, topAfter - 4, topAfter - 5);
            return stackEntryNecessary2 ? (stackEntryNecessary3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? 94 : 22622) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))) : (stackEntryPresent3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? -1 : 5726046) : (stackEntriesNecessary01 ? -1 : (stackEntriesPresent01 ? 5726040 : 22367))) : (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? 93 : 22621) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))))) : (stackEntryPresent2 ? (stackEntryNecessary3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? -1 : 5724254) : (stackEntriesNecessary01 ? 5724253 : (stackEntriesPresent01 ? 22360 : 87))) : (stackEntryPresent3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? -1 : 0x58585E) : (stackEntriesNecessary01 ? 0x58585E : (stackEntriesPresent01 ? 22616 : 88))) : (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? -1 : 5724253) : (stackEntriesNecessary01 ? 5724253 : (stackEntriesPresent01 ? 22360 : 87))))) : (stackEntryNecessary3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? 93 : 22621) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))) : (stackEntryPresent3 ? (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? -1 : 5724253) : (stackEntriesNecessary01 ? 5724253 : (stackEntriesPresent01 ? 22360 : 87))) : (stackEntriesNecessary45 ? (stackEntriesNecessary01 ? 92 : 0) : (stackEntriesNecessary01 ? 0 : (stackEntriesPresent01 ? 88 : 0))))));
        }

        private int fixedSwap(int instructionOffset, int topBefore, int topAfter) {
            boolean stackEntryPresent0 = EvaluationShrinker.this.isStackEntryPresentBefore(instructionOffset, topBefore - 0);
            boolean stackEntryPresent1 = EvaluationShrinker.this.isStackEntryPresentBefore(instructionOffset, topBefore - 1);
            boolean stackEntryNecessary0 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 0);
            boolean stackEntryNecessary1 = EvaluationShrinker.this.isStackEntryNecessaryAfter(instructionOffset, topAfter - 1);
            return stackEntryNecessary0 ? (stackEntryNecessary1 ? 95 : (stackEntryPresent0 ? 87 : 0)) : (stackEntryPresent1 ? 22367 : 0);
        }
    }

    private class MyVariableInitializationMarker
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyVariableInitializationMarker() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            if (variableInstruction.isLoad()) {
                EvaluationShrinker.this.markVariableInitializersBefore(offset, variableInstruction.variableIndex);
            }
        }
    }

    private class MyProducerMarker
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyProducerMarker() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            EvaluationShrinker.this.markStackProducers(clazz, offset, instruction);
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case 89: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 1, 0);
                    break;
                }
                case 90: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 2, 0);
                    break;
                }
                case 91: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 2, 2);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 3, 0);
                    break;
                }
                case 92: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 2, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 3, 1);
                    break;
                }
                case 93: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 2, 2);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 3, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 4, 1);
                    break;
                }
                case 94: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 2, 2);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 3, 3);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 4, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 5, 1);
                    break;
                }
                case 95: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 0, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 1, 0);
                    break;
                }
                default: {
                    EvaluationShrinker.this.markStackProducers(clazz, offset, simpleInstruction);
                }
            }
        }

        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            if (variableInstruction.isLoad()) {
                EvaluationShrinker.this.markVariableProducers(offset, variableInstruction.variableIndex);
            } else {
                EvaluationShrinker.this.markStackProducers(clazz, offset, variableInstruction);
            }
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            if (constantInstruction.opcode == -69) {
                EvaluationShrinker.this.markInitialization(offset);
            }
            EvaluationShrinker.this.markStackProducers(clazz, offset, constantInstruction);
        }

        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            if (branchInstruction.opcode == -88 || branchInstruction.opcode == -55) {
                EvaluationShrinker.this.markStackEntryAfter(offset, 0);
            } else {
                EvaluationShrinker.this.markStackProducers(clazz, offset, branchInstruction);
            }
        }
    }

    private class MyUnusedParameterSimplifier
    extends SimplifiedVisitor
    implements InstructionVisitor,
    ConstantVisitor,
    MemberVisitor {
        private int invocationOffset;
        private ConstantInstruction invocationInstruction;

        private MyUnusedParameterSimplifier() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -74: 
                case -73: 
                case -72: 
                case -71: {
                    this.invocationOffset = offset;
                    this.invocationInstruction = constantInstruction;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                }
            }
        }

        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            refConstant.referencedMemberAccept(this);
        }

        public void visitAnyMember(Clazz clazz, Member member) {
        }

        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            int parameterSize = ParameterUsageMarker.getParameterSize(programMethod);
            if ((programMethod.getAccessFlags() & 8) == 0 && !ParameterUsageMarker.isParameterUsed(programMethod, 0)) {
                EvaluationShrinker.this.replaceByStaticInvocation(programClass, this.invocationOffset, this.invocationInstruction);
            }
            for (int index = 0; index < parameterSize; ++index) {
                if (ParameterUsageMarker.isParameterUsed(programMethod, index)) continue;
                TracedStack stack = EvaluationShrinker.this.partialEvaluator.getStackBefore(this.invocationOffset);
                int stackIndex = stack.size() - parameterSize + index;
                EvaluationShrinker.this.markStackSimplificationBefore(this.invocationOffset, stackIndex);
            }
        }
    }
}

