/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceNameRendererEx;
import com.google.gct.testing.CloudConfigurationHelper;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;

public class CloudDeviceNameRenderer
implements DeviceNameRendererEx {
    public boolean isApplicable(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/google/gct/testing/android/CloudDeviceNameRenderer", "isApplicable"));
        }
        return CloudConfigurationHelper.getCloudDeviceConfiguration(device) != null;
    }

    public void render(@NotNull IDevice device, @NotNull ColoredTextContainer component) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/google/gct/testing/android/CloudDeviceNameRenderer", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/google/gct/testing/android/CloudDeviceNameRenderer", "render"));
        }
        component.setIcon(CloudConfigurationHelper.getCloudDeviceIcon());
        String cloudDeviceConfiguration = CloudConfigurationHelper.getCloudDeviceConfiguration(device);
        if (device.getState() == IDevice.DeviceState.OFFLINE) {
            component.append("Launching " + cloudDeviceConfiguration, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        } else {
            component.append(cloudDeviceConfiguration, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @NotNull
    public String getName(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/google/gct/testing/android/CloudDeviceNameRenderer", "getName"));
        }
        String deviceName = CloudConfigurationHelper.getCloudDeviceConfiguration(device);
        if (deviceName == null) {
            throw new IllegalArgumentException("This device name renderer is not applicable to the given device: " + device);
        }
        String string = deviceName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudDeviceNameRenderer", "getName"));
        }
        return string;
    }
}

