/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtraTextDetector
extends ResourceXmlDetector {
    private boolean mFoundText;
    public static final Issue ISSUE = Issue.create((String)"ExtraText", (String)"Extraneous text in resource files", (String)"Layout resource files should only contain elements and attributes. Any XML text content found in the file is likely accidental (and potentially dangerous if the text resembles XML and the developer believes the text to be functional)", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, (Implementation)new Implementation(ExtraTextDetector.class, Scope.RESOURCE_FILE_SCOPE));

    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.ANIM || folderType == ResourceFolderType.ANIMATOR || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.COLOR;
    }

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void visitDocument(@NonNull XmlContext context, @NonNull Document document) {
        this.mFoundText = false;
        this.visitNode(context, document);
    }

    private void visitNode(XmlContext context, Node node) {
        int i;
        int n;
        short nodeType = node.getNodeType();
        if (nodeType == 3 && !this.mFoundText) {
            String text = node.getNodeValue();
            n = text.length();
            for (i = 0; i < n; ++i) {
                Position start;
                char c = text.charAt(i);
                if (Character.isWhitespace(c)) continue;
                String snippet = text.trim();
                int maxLength = 100;
                if (snippet.length() > maxLength) {
                    snippet = snippet.substring(0, maxLength) + "...";
                }
                Location location = context.getLocation(node);
                if (i > 0 && (start = location.getStart()) != null) {
                    int line = start.getLine();
                    int column = start.getColumn();
                    int offset = start.getOffset();
                    for (int j = 0; j < i; ++j) {
                        ++offset;
                        if (text.charAt(j) == '\n') {
                            if (line != -1) {
                                ++line;
                            }
                            if (column == -1) continue;
                            column = 0;
                            continue;
                        }
                        if (column == -1) continue;
                        ++column;
                    }
                    start = new DefaultPosition(line, column, offset);
                    location = Location.create((File)context.file, (Position)start, (Position)location.getEnd());
                }
                context.report(ISSUE, node, location, String.format("Unexpected text found in layout file: \"%1$s\"", snippet));
                this.mFoundText = true;
                break;
            }
        }
        NodeList childNodes = node.getChildNodes();
        n = childNodes.getLength();
        for (i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            this.visitNode(context, child);
        }
    }
}

