/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.sdklib.io.IFileOp;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.NoPreviewRevision;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

class PackageParserUtils {
    PackageParserUtils() {
    }

    public static FullRevision getPropertyFull(Properties props, String propKey) {
        String revStr = PackageParserUtils.getProperty(props, propKey, null);
        FullRevision rev = null;
        if (revStr != null) {
            try {
                rev = FullRevision.parseRevision(revStr);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return rev;
    }

    public static MajorRevision getPropertyMajor(Properties props, String propKey) {
        String revStr = PackageParserUtils.getProperty(props, propKey, null);
        MajorRevision rev = null;
        if (revStr != null) {
            try {
                rev = MajorRevision.parseRevision(revStr);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return rev;
    }

    public static NoPreviewRevision getPropertyNoPreview(Properties props, String propKey) {
        String revStr = PackageParserUtils.getProperty(props, propKey, null);
        NoPreviewRevision rev = null;
        if (revStr != null) {
            try {
                rev = NoPreviewRevision.parseRevision(revStr);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return rev;
    }

    public static String getProperty(Properties props, String propKey, String defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        return props.getProperty(propKey, defaultValue);
    }

    public static List<File> parseSkinFolder(File skinRootFolder, IFileOp fileOp) {
        if (fileOp.isDirectory(skinRootFolder)) {
            File[] files;
            ArrayList<File> skinList = new ArrayList<File>();
            for (File skinFolder : files = fileOp.listFiles(skinRootFolder)) {
                File layout;
                if (!fileOp.isDirectory(skinFolder) || !fileOp.isFile(layout = new File(skinFolder, "layout"))) continue;
                skinList.add(skinFolder);
            }
            Collections.sort(skinList);
            return skinList;
        }
        return Collections.emptyList();
    }
}

