/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.builder.core.DexOptions;
import com.android.builder.core.DexProcessBuilder;
import com.android.dx.command.dexer.DxContext;
import com.android.dx.command.dexer.Main;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;

public class DexWrapper {
    public static ProcessResult run(DexProcessBuilder processBuilder, DexOptions dexOptions, ProcessOutputHandler outputHandler) throws IOException, ProcessException {
        ProcessOutput output = outputHandler.createOutput();
        DxContext dxContext = new DxContext(output.getStandardOutput(), output.getErrorOutput());
        Main.Arguments args = DexWrapper.buildArguments(processBuilder, dexOptions);
        int res = new Main(dxContext).run(args);
        outputHandler.handleOutput(output);
        return new DexProcessResult(res);
    }

    private static Main.Arguments buildArguments(DexProcessBuilder processBuilder, DexOptions dexOptions) throws ProcessException {
        Main.Arguments args = new Main.Arguments();
        args.fileNames = (String[])Iterables.toArray(processBuilder.getFilesToAdd(null), String.class);
        if (processBuilder.getOutputFile().isDirectory() && !processBuilder.isMultiDex()) {
            args.outName = new File(processBuilder.getOutputFile(), "classes.dex").getPath();
            args.jarOutput = false;
        } else {
            String outputFileAbsolutePath;
            args.outName = outputFileAbsolutePath = processBuilder.getOutputFile().getAbsolutePath();
            args.jarOutput = outputFileAbsolutePath.endsWith(".jar");
        }
        args.multiDex = processBuilder.isMultiDex();
        if (processBuilder.getMainDexList() != null) {
            args.mainDexListFile = processBuilder.getMainDexList().getPath();
        }
        args.verbose = processBuilder.isVerbose();
        args.optimize = !processBuilder.isNoOptimize();
        args.numThreads = (Integer)Objects.firstNonNull((Object)dexOptions.getThreadCount(), (Object)4);
        args.forceJumbo = dexOptions.getJumboMode();
        return args;
    }

    private static class DexProcessResult
    implements ProcessResult {
        private int mExitValue;

        DexProcessResult(int exitValue) {
            this.mExitValue = exitValue;
        }

        public ProcessResult assertNormalExitValue() throws ProcessException {
            if (this.mExitValue != 0) {
                throw new ProcessException(String.format("Return code %d for dex process", this.mExitValue));
            }
            return this;
        }

        public int getExitValue() {
            return this.mExitValue;
        }

        public ProcessResult rethrowFailure() throws ProcessException {
            return this.assertNormalExitValue();
        }
    }
}

