/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.lw;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.lw.CompiledClassPropertiesProvider;
import com.intellij.uiDesigner.lw.ComponentVisitor;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.lw.LwIntroBooleanProperty;
import com.intellij.uiDesigner.lw.LwIntroIntProperty;
import com.intellij.uiDesigner.lw.LwIntroPrimitiveTypeProperty;
import com.intellij.uiDesigner.lw.LwIntrospectedProperty;
import com.intellij.uiDesigner.lw.LwXmlReader;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public abstract class LwComponent
implements IComponent {
    private String myId;
    private String myBinding;
    private final String myClassName;
    private LwContainer myParent;
    private final GridConstraints myConstraints;
    private Object myCustomLayoutConstraints;
    private final Rectangle myBounds;
    private final HashMap myIntrospectedProperty2Value;
    private Element myErrorComponentProperties;
    protected final HashMap myClientProperties;
    protected final HashMap myDelegeeClientProperties;
    private boolean myCustomCreate = false;
    private boolean myDefaultBinding = false;

    public LwComponent(String className) {
        if (className == null) {
            throw new IllegalArgumentException("className cannot be null");
        }
        this.myBounds = new Rectangle();
        this.myConstraints = new GridConstraints();
        this.myIntrospectedProperty2Value = new HashMap();
        this.myClassName = className;
        this.myClientProperties = new HashMap();
        this.myDelegeeClientProperties = new HashMap();
    }

    @Override
    public final String getId() {
        return this.myId;
    }

    public final void setId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.myId = id;
    }

    @Override
    public final String getBinding() {
        return this.myBinding;
    }

    public final void setBinding(String binding) {
        this.myBinding = binding;
    }

    @Override
    public final Object getCustomLayoutConstraints() {
        return this.myCustomLayoutConstraints;
    }

    public final void setCustomLayoutConstraints(Object customLayoutConstraints) {
        this.myCustomLayoutConstraints = customLayoutConstraints;
    }

    @Override
    public final String getComponentClassName() {
        return this.myClassName;
    }

    @Override
    public IProperty[] getModifiedProperties() {
        return this.getAssignedIntrospectedProperties();
    }

    public final Rectangle getBounds() {
        return (Rectangle)this.myBounds.clone();
    }

    @Override
    public final GridConstraints getConstraints() {
        return this.myConstraints;
    }

    @Override
    public boolean isCustomCreate() {
        return this.myCustomCreate;
    }

    public boolean isDefaultBinding() {
        return this.myDefaultBinding;
    }

    @Override
    public boolean accept(ComponentVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean areChildrenExclusive() {
        return false;
    }

    public final LwContainer getParent() {
        return this.myParent;
    }

    @Override
    public IContainer getParentContainer() {
        return this.myParent;
    }

    protected final void setParent(LwContainer parent) {
        this.myParent = parent;
    }

    public final void setBounds(Rectangle bounds) {
        this.myBounds.setBounds(bounds);
    }

    public final Object getPropertyValue(LwIntrospectedProperty property) {
        return this.myIntrospectedProperty2Value.get(property);
    }

    public final void setPropertyValue(LwIntrospectedProperty property, Object value) {
        this.myIntrospectedProperty2Value.put(property, value);
    }

    public final Element getErrorComponentProperties() {
        return this.myErrorComponentProperties;
    }

    public final LwIntrospectedProperty[] getAssignedIntrospectedProperties() {
        LwIntrospectedProperty[] properties = new LwIntrospectedProperty[this.myIntrospectedProperty2Value.size()];
        Iterator iterator = this.myIntrospectedProperty2Value.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            properties[i] = (LwIntrospectedProperty)iterator.next();
            ++i;
        }
        return properties;
    }

    protected final void readBase(Element element) {
        this.setId(LwXmlReader.getRequiredString(element, "id"));
        this.setBinding(element.getAttributeValue("binding"));
        this.myCustomCreate = LwXmlReader.getOptionalBoolean(element, "custom-create", false);
        this.myDefaultBinding = LwXmlReader.getOptionalBoolean(element, "default-binding", false);
    }

    protected final void readProperties(Element element, PropertiesProvider provider) {
        HashMap name2property;
        if (provider == null) {
            return;
        }
        Element propertiesElement = LwXmlReader.getChild(element, "properties");
        if (propertiesElement == null) {
            propertiesElement = new Element("properties", element.getNamespace());
        }
        if ((name2property = provider.getLwProperties(this.getComponentClassName())) == null) {
            this.myErrorComponentProperties = propertiesElement.clone();
            return;
        }
        List propertyElements = propertiesElement.getChildren();
        for (int i = 0; i < propertyElements.size(); ++i) {
            Element t = (Element)propertyElements.get(i);
            String name = t.getName();
            LwIntrospectedProperty property = (LwIntrospectedProperty)name2property.get(name);
            if (property == null) continue;
            try {
                Object value = property.read(t);
                this.setPropertyValue(property, value);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.readClientProperties(element);
    }

    private void readClientProperties(Element element) {
        Element propertiesElement = LwXmlReader.getChild(element, "clientProperties");
        if (propertiesElement == null) {
            return;
        }
        List clientPropertyList = propertiesElement.getChildren();
        for (int i = 0; i < clientPropertyList.size(); ++i) {
            Object value;
            LwIntrospectedProperty lwProp;
            Element prop = (Element)clientPropertyList.get(i);
            String propName = prop.getName();
            String className = LwXmlReader.getRequiredString(prop, "class");
            if (className.equals(Integer.class.getName())) {
                lwProp = new LwIntroIntProperty(propName);
            } else if (className.equals(Boolean.class.getName())) {
                lwProp = new LwIntroBooleanProperty(propName);
            } else if (className.equals(Double.class.getName())) {
                lwProp = new LwIntroPrimitiveTypeProperty(propName, Double.class);
            } else {
                Class<?> propClass;
                try {
                    propClass = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                lwProp = CompiledClassPropertiesProvider.propertyFromClass(propClass, propName);
            }
            if (lwProp == null) continue;
            try {
                value = ((LwIntrospectedProperty)lwProp).read(prop);
            }
            catch (Exception e) {
                continue;
            }
            this.myDelegeeClientProperties.put(propName, value);
        }
    }

    protected final void readConstraints(Element element) {
        LwContainer parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("component must be in LW tree: " + this);
        }
        parent.readConstraintsForChild(element, this);
    }

    public abstract void read(Element var1, PropertiesProvider var2) throws Exception;

    @Override
    public final Object getClientProperty(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        return this.myClientProperties.get(key);
    }

    @Override
    public final void putClientProperty(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.myClientProperties.put(key, value);
    }

    public HashMap getDelegeeClientProperties() {
        return this.myDelegeeClientProperties;
    }
}

