/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.sdklib.repositoryv2.meta.DetailsTypes;
import com.android.tools.idea.updater.configure.NodeStateHolder;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PlatformDetailsTreeNode
extends UpdaterTreeNode {
    private NodeStateHolder myStateHolder;
    private final ChangeListener myChangeListener;

    public PlatformDetailsTreeNode(@NotNull NodeStateHolder state, @Nullable ChangeListener changeListener) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/updater/configure/PlatformDetailsTreeNode", "<init>"));
        }
        this.myStateHolder = state;
        this.myStateHolder.setState(this.getInitialState());
        this.myChangeListener = changeListener;
    }

    @Override
    public NodeStateHolder.SelectedState getInitialState() {
        return this.myStateHolder.getPkg().isUpdate() ? NodeStateHolder.SelectedState.MIXED : (this.myStateHolder.getPkg().hasLocal() ? NodeStateHolder.SelectedState.INSTALLED : NodeStateHolder.SelectedState.NOT_INSTALLED);
    }

    @Override
    public NodeStateHolder.SelectedState getCurrentState() {
        return this.myStateHolder.getState();
    }

    @Override
    public int compareTo(UpdaterTreeNode o) {
        if (!(o instanceof PlatformDetailsTreeNode)) {
            return this.toString().compareTo(o.toString());
        }
        return this.myStateHolder.getPkg().compareTo(((PlatformDetailsTreeNode)o).myStateHolder.getPkg());
    }

    @Override
    protected void setState(NodeStateHolder.SelectedState state) {
        this.myStateHolder.setState(state);
        if (this.myChangeListener != null) {
            this.myChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlatformDetailsTreeNode)) {
            return false;
        }
        return this.myStateHolder.getPkg().equals(((PlatformDetailsTreeNode)obj).myStateHolder.getPkg());
    }

    @Override
    public boolean includeInSummary() {
        return this.myStateHolder.getPkg().getRepresentative().getTypeDetails() instanceof DetailsTypes.SourceDetailsType || this.myStateHolder.getPkg().getRepresentative().getTypeDetails() instanceof DetailsTypes.PlatformDetailsType;
    }

    @Override
    public boolean isPrimary() {
        return this.myStateHolder.getPkg().getRepresentative().getTypeDetails() instanceof DetailsTypes.PlatformDetailsType;
    }

    @Override
    public void customizeRenderer(UpdaterTreeNode.Renderer renderer, JTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        RepoPackage p = this.myStateHolder.getPkg().getRepresentative();
        String result = p.getDisplayName();
        if (p.obsolete()) {
            result = result + " (Obsolete)";
        }
        renderer.getTextRenderer().append(result, attributes);
    }

    @NotNull
    public UpdatablePackage getItem() {
        UpdatablePackage updatablePackage = this.myStateHolder.getPkg();
        if (updatablePackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/configure/PlatformDetailsTreeNode", "getItem"));
        }
        return updatablePackage;
    }

    @Override
    protected boolean canHaveMixedState() {
        return this.myStateHolder.getPkg().isUpdate();
    }

    @Override
    public String getStatusString() {
        if (this.getInitialState() == NodeStateHolder.SelectedState.NOT_INSTALLED) {
            return "Not installed";
        }
        if (this.getInitialState() == NodeStateHolder.SelectedState.MIXED) {
            return "Update Available: " + this.myStateHolder.getPkg().getRemote().getVersion();
        }
        return "Installed";
    }

    public RepoPackage getPackage() {
        return this.getItem().getRepresentative();
    }
}

