/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.annotations;

import com.android.build.gradle.tasks.annotations.ApiDatabase;
import com.android.build.gradle.tasks.annotations.TypedefCollector;
import com.android.build.gradle.tasks.annotations.TypedefRemover;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.xml.XmlEscapers;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Extractor {
    private static final boolean INCLUDE_TYPE_ARGS = false;
    private final boolean sortAnnotations;
    private final boolean includeClassRetentionAnnotations;
    private static final boolean INCLUDE_INFERRED_NULLABLE = false;
    public static final String ANDROID_ANNOTATIONS_PREFIX = "android.annotation.";
    public static final String ANDROID_NULLABLE = "android.annotation.Nullable";
    public static final String SUPPORT_NULLABLE = "android.support.annotation.Nullable";
    public static final String SUPPORT_KEEP = "android.support.annotation.Keep";
    public static final String RESOURCE_TYPE_ANNOTATIONS_SUFFIX = "Res";
    public static final String ANDROID_NOTNULL = "android.annotation.NonNull";
    public static final String SUPPORT_NOTNULL = "android.support.annotation.NonNull";
    public static final String ANDROID_INT_DEF = "android.annotation.IntDef";
    public static final String ANDROID_INT_RANGE = "android.annotation.IntRange";
    public static final String ANDROID_STRING_DEF = "android.annotation.StringDef";
    public static final String REQUIRES_PERMISSION = "android.support.annotation.RequiresPermission";
    public static final String ANDROID_REQUIRES_PERMISSION = "android.annotation.RequiresPermission";
    public static final String IDEA_NULLABLE = "org.jetbrains.annotations.Nullable";
    public static final String IDEA_NOTNULL = "org.jetbrains.annotations.NotNull";
    public static final String IDEA_MAGIC = "org.intellij.lang.annotations.MagicConstant";
    public static final String IDEA_CONTRACT = "org.jetbrains.annotations.Contract";
    public static final String IDEA_NON_NLS = "org.jetbrains.annotations.NonNls";
    public static final String ATTR_VAL = "val";
    private final Map<String, List<AnnotationData>> types = Maps.newHashMap();
    private final Set<String> irrelevantAnnotations = Sets.newHashSet();
    private final File classDir;
    private final Map<String, Map<String, List<Item>>> itemMap = Maps.newHashMap();
    private final ApiDatabase apiFilter;
    private final boolean displayInfo;
    private final Map<String, Integer> stats = Maps.newHashMap();
    private int filteredCount;
    private int mergedCount;
    private final Set<CompilationUnitDeclaration> processedFiles = Sets.newHashSetWithExpectedSize((int)100);
    private final Set<String> ignoredAnnotations = Sets.newHashSet();
    private boolean listIgnored;
    private Map<String, List<Annotation>> typedefs;
    private List<String> typedefClasses;
    private Map<String, Boolean> sourceRetention;
    private final List<Item> keepItems = Lists.newArrayList();

    public Extractor(ApiDatabase apiFilter, File classDir, boolean displayInfo, boolean includeClassRetentionAnnotations, boolean sortAnnotations) {
        this.apiFilter = apiFilter;
        this.listIgnored = apiFilter != null;
        this.classDir = classDir;
        this.displayInfo = displayInfo;
        this.includeClassRetentionAnnotations = includeClassRetentionAnnotations;
        this.sortAnnotations = sortAnnotations;
    }

    public void extractFromProjectSource(Collection<CompilationUnitDeclaration> units) {
        TypedefCollector collector = new TypedefCollector(units, false, true);
        this.typedefs = collector.getTypedefs();
        this.typedefClasses = collector.getNonPublicTypedefClasses();
        for (CompilationUnitDeclaration unit : units) {
            this.analyze(unit);
        }
    }

    public void removeTypedefClasses() {
        if (this.classDir != null && this.typedefClasses != null && !this.typedefClasses.isEmpty()) {
            boolean quiet = false;
            boolean verbose = false;
            boolean dryRun = false;
            TypedefRemover remover = new TypedefRemover(this, quiet, verbose, dryRun);
            remover.remove(this.classDir, this.typedefClasses);
        }
    }

    public void export(File annotationsZip, File proguardCfg) {
        if (proguardCfg != null) {
            if (this.keepItems.isEmpty()) {
                if (proguardCfg.exists()) {
                    proguardCfg.delete();
                }
            } else if (this.writeKeepRules(proguardCfg)) {
                this.info("ProGuard keep rules written to " + proguardCfg);
            }
        }
        if (annotationsZip != null) {
            if (this.itemMap.isEmpty()) {
                if (annotationsZip.exists()) {
                    annotationsZip.delete();
                }
            } else if (this.writeExternalAnnotations(annotationsZip)) {
                this.writeStats();
                this.info("Annotations written to " + annotationsZip);
            }
        }
    }

    public void writeStats() {
        if (!this.displayInfo) {
            return;
        }
        if (!this.stats.isEmpty()) {
            ArrayList annotations = Lists.newArrayList(this.stats.keySet());
            Collections.sort(annotations, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    int frequency1 = (Integer)Extractor.this.stats.get(s1);
                    int frequency2 = (Integer)Extractor.this.stats.get(s2);
                    int delta = frequency2 - frequency1;
                    if (delta != 0) {
                        return delta;
                    }
                    return s1.compareTo(s2);
                }
            });
            HashMap fqnToName = Maps.newHashMap();
            int max = 0;
            int count = 0;
            for (String fqn : annotations) {
                String name = fqn.substring(fqn.lastIndexOf(46) + 1);
                fqnToName.put(fqn, name);
                max = Math.max(max, name.length());
                count += this.stats.get(fqn).intValue();
            }
            StringBuilder sb = new StringBuilder(200);
            sb.append("Extracted ").append(count).append(" Annotations:");
            for (String fqn : annotations) {
                sb.append('\n');
                String name = (String)fqnToName.get(fqn);
                int n = max - name.length() + 1;
                for (int i = 0; i < n; ++i) {
                    sb.append(' ');
                }
                sb.append('@');
                sb.append(name);
                sb.append(':').append(' ');
                sb.append(Integer.toString(this.stats.get(fqn)));
            }
            if (sb.length() > 0) {
                this.info(sb.toString());
            }
        }
        if (this.filteredCount > 0) {
            this.info(this.filteredCount + " of these were filtered out (not in API database file)");
        }
        if (this.mergedCount > 0) {
            this.info(this.mergedCount + " additional annotations were merged in");
        }
    }

    void info(String message) {
        if (this.displayInfo) {
            System.out.println(message);
        }
    }

    static void error(String message) {
        System.err.println("Error: " + message);
    }

    static void warning(String message) {
        System.out.println("Warning: " + message);
    }

    private void analyze(CompilationUnitDeclaration unit) {
        if (this.processedFiles.contains(unit)) {
            return;
        }
        this.processedFiles.add(unit);
        AnnotationVisitor visitor = new AnnotationVisitor();
        unit.traverse((ASTVisitor)visitor, unit.scope);
    }

    private static ClassScope findClassScope(Scope scope) {
        while (scope != null) {
            if (scope instanceof ClassScope) {
                return (ClassScope)scope;
            }
            scope = scope.parent;
        }
        return null;
    }

    static String getFqn(Annotation annotation) {
        if (annotation.resolvedType != null) {
            return new String(annotation.resolvedType.readableName());
        }
        return null;
    }

    private static String getFqn(ClassScope scope) {
        TypeDeclaration typeDeclaration = scope.referenceType();
        if (typeDeclaration != null && typeDeclaration.binding != null) {
            return new String(typeDeclaration.binding.readableName());
        }
        return null;
    }

    private static String getFqn(MethodScope scope) {
        ClassScope classScope = Extractor.findClassScope((Scope)scope);
        if (classScope != null) {
            return Extractor.getFqn(classScope);
        }
        return null;
    }

    private static String getFqn(BlockScope scope) {
        ClassScope classScope = Extractor.findClassScope((Scope)scope);
        if (classScope != null) {
            return Extractor.getFqn(classScope);
        }
        return null;
    }

    boolean hasSourceRetention(String fqn, Annotation annotation) {
        Boolean source;
        if (this.sourceRetention == null) {
            this.sourceRetention = Maps.newHashMapWithExpectedSize((int)20);
            this.sourceRetention.put("android.support.annotation.IntDef", true);
            this.sourceRetention.put("android.support.annotation.StringDef", true);
            this.sourceRetention.put(SUPPORT_NOTNULL, false);
            this.sourceRetention.put(SUPPORT_NULLABLE, false);
        }
        if ((source = this.sourceRetention.get(fqn)) != null) {
            return source;
        }
        if (annotation == null || annotation.type == null || annotation.type.resolvedType == null) {
            this.sourceRetention.put(fqn, false);
            return false;
        }
        if (annotation.type.resolvedType.getAnnotations() != null) {
            for (AnnotationBinding binding : annotation.type.resolvedType.getAnnotations()) {
                if (!Extractor.hasSourceRetention(binding)) continue;
                this.sourceRetention.put(fqn, true);
                return true;
            }
        }
        this.sourceRetention.put(fqn, false);
        return false;
    }

    static boolean hasSourceRetention(AnnotationBinding a) {
        if (new String(a.getAnnotationType().readableName()).equals("java.lang.annotation.Retention")) {
            FieldBinding field;
            ElementValuePair[] pairs = a.getElementValuePairs();
            if (pairs == null || pairs.length != 1) {
                Extractor.warning("Expected exactly one parameter passed to @Retention");
                return false;
            }
            ElementValuePair pair = pairs[0];
            Object value = pair.getValue();
            if (value instanceof FieldBinding && "SOURCE".equals(new String((field = (FieldBinding)value).readableName()))) {
                return true;
            }
        }
        return false;
    }

    static boolean hasSourceRetention(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            String typeName = Extractor.getFqn(annotation);
            if (!"java.lang.annotation.Retention".equals(typeName)) continue;
            MemberValuePair[] pairs = annotation.memberValuePairs();
            if (pairs == null || pairs.length != 1) {
                Extractor.warning("Expected exactly one parameter passed to @Retention");
                return false;
            }
            MemberValuePair pair = pairs[0];
            Expression value = pair.value;
            if (!(value instanceof NameReference)) continue;
            NameReference reference = (NameReference)value;
            Binding binding = reference.binding;
            if (binding == null || !(binding instanceof FieldBinding)) continue;
            FieldBinding fb = (FieldBinding)binding;
            if (!"SOURCE".equals(new String(fb.name)) || !"java.lang.annotation.RetentionPolicy".equals(new String(fb.declaringClass.readableName()))) continue;
            return true;
        }
        return false;
    }

    private void addAnnotations(Annotation[] annotations, Item item) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!this.isRelevantAnnotation(annotation)) continue;
                String fqn = Extractor.getFqn(annotation);
                if (SUPPORT_KEEP.equals(fqn)) {
                    this.keepItems.add(item);
                    continue;
                }
                this.addAnnotation(annotation, fqn, item.annotations);
            }
        }
    }

    private void addAnnotation(Annotation annotation, String fqn, List<AnnotationData> list) {
        List<AnnotationData> indirect;
        if (fqn == null) {
            return;
        }
        if (fqn.equals(ANDROID_NULLABLE) || fqn.equals(SUPPORT_NULLABLE)) {
            this.recordStats(fqn);
            list.add(new AnnotationData(SUPPORT_NULLABLE));
            return;
        }
        if (fqn.equals(ANDROID_NOTNULL) || fqn.equals(SUPPORT_NOTNULL)) {
            this.recordStats(fqn);
            list.add(new AnnotationData(SUPPORT_NOTNULL));
            return;
        }
        if (fqn.startsWith("android.support.annotation.") && fqn.endsWith(RESOURCE_TYPE_ANNOTATIONS_SUFFIX)) {
            this.recordStats(fqn);
            list.add(new AnnotationData(fqn));
            return;
        }
        if (fqn.startsWith(ANDROID_ANNOTATIONS_PREFIX)) {
            if (fqn.endsWith(RESOURCE_TYPE_ANNOTATIONS_SUFFIX)) {
                String resAnnotation = "android.support.annotation." + fqn.substring(ANDROID_ANNOTATIONS_PREFIX.length());
                if (!this.includeClassRetentionAnnotations && !this.hasSourceRetention(resAnnotation, null)) {
                    return;
                }
                this.recordStats(resAnnotation);
                list.add(new AnnotationData(resAnnotation));
                return;
            }
            if (Extractor.isRelevantFrameworkAnnotation(fqn)) {
                String supportAnnotation = "android.support.annotation." + fqn.substring(ANDROID_ANNOTATIONS_PREFIX.length());
                if (!this.includeClassRetentionAnnotations && !this.hasSourceRetention(supportAnnotation, null)) {
                    return;
                }
                this.recordStats(supportAnnotation);
                list.add(this.createData(supportAnnotation, annotation));
            }
        }
        if (fqn.startsWith("android.support.annotation.")) {
            this.recordStats(fqn);
            list.add(this.createData(fqn, annotation));
            return;
        }
        if (this.isMagicConstant(fqn) && (indirect = this.types.get(fqn)) != null) {
            list.addAll(indirect);
        }
    }

    private void recordStats(String fqn) {
        Integer count = this.stats.get(fqn);
        if (count == null) {
            count = 0;
        }
        this.stats.put(fqn, count + 1);
    }

    private boolean hasRelevantAnnotations(Annotation[] annotations) {
        if (annotations == null) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (!this.isRelevantAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    private boolean isRelevantAnnotation(Annotation annotation) {
        String fqn = Extractor.getFqn(annotation);
        if (fqn == null || fqn.startsWith("java.lang.")) {
            return false;
        }
        if (fqn.startsWith("android.support.annotation.")) {
            if (fqn.equals(SUPPORT_KEEP)) {
                return true;
            }
            return this.includeClassRetentionAnnotations || this.hasSourceRetention(fqn, annotation);
        }
        if (fqn.startsWith(ANDROID_ANNOTATIONS_PREFIX)) {
            return Extractor.isRelevantFrameworkAnnotation(fqn);
        }
        if (fqn.equals(ANDROID_NULLABLE) || fqn.equals(ANDROID_NOTNULL) || this.isMagicConstant(fqn)) {
            return true;
        }
        return fqn.equals(IDEA_CONTRACT);
    }

    private static boolean isRelevantFrameworkAnnotation(String fqn) {
        return fqn.startsWith(ANDROID_ANNOTATIONS_PREFIX) && !fqn.endsWith(".Widget") && !fqn.endsWith(".TargetApi") && !fqn.endsWith(".SystemApi") && !fqn.endsWith(".SuppressLint") && !fqn.endsWith(".SdkConstant");
    }

    boolean isMagicConstant(String typeName) {
        if (this.irrelevantAnnotations.contains(typeName) || typeName.startsWith("java.lang.")) {
            return false;
        }
        if (this.types.containsKey(typeName) || typeName.equals("android.support.annotation.IntDef") || typeName.equals("android.support.annotation.StringDef") || typeName.equals("android.support.annotation.IntRange") || typeName.equals(ANDROID_INT_RANGE) || typeName.equals(ANDROID_INT_DEF) || typeName.equals(ANDROID_STRING_DEF)) {
            return true;
        }
        List<Annotation> typeDefs = this.typedefs.get(typeName);
        if (typeDefs != null) {
            boolean match = false;
            for (Annotation typeDef : typeDefs) {
                String fqn = Extractor.getFqn(typeDef);
                if (!Extractor.isNestedAnnotation(fqn)) continue;
                List<AnnotationData> list = this.types.get(typeName);
                if (list == null) {
                    list = new ArrayList<AnnotationData>(2);
                    this.types.put(typeName, list);
                }
                this.addAnnotation(typeDef, fqn, list);
                match = true;
            }
            return match;
        }
        this.irrelevantAnnotations.add(typeName);
        return false;
    }

    static boolean isNestedAnnotation(String fqn) {
        return fqn != null && (fqn.equals("android.support.annotation.IntDef") || fqn.equals("android.support.annotation.StringDef") || fqn.equals(REQUIRES_PERMISSION) || fqn.equals(ANDROID_REQUIRES_PERMISSION) || fqn.equals("android.support.annotation.IntRange") || fqn.equals(ANDROID_INT_RANGE) || fqn.equals(ANDROID_INT_DEF) || fqn.equals(ANDROID_STRING_DEF));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeKeepRules(File proguardCfg) {
        if (!this.keepItems.isEmpty()) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(proguardCfg));
                try {
                    Collections.sort(this.keepItems);
                    for (Item item : this.keepItems) {
                        writer.write(item.getKeepRule());
                        ((Writer)writer).write(10);
                    }
                }
                finally {
                    ((Writer)writer).close();
                }
            }
            catch (IOException ioe) {
                Extractor.error(ioe.toString());
                return true;
            }
            for (Item item : this.keepItems) {
                this.removeItem(item.getQualifiedClassName(), item);
            }
        } else if (proguardCfg.exists()) {
            proguardCfg.delete();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeExternalAnnotations(File annotationsZip) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(annotationsZip);
            JarOutputStream zos = new JarOutputStream(fileOutputStream);
            try {
                ArrayList<String> sortedPackages = new ArrayList<String>(this.itemMap.keySet());
                Collections.sort(sortedPackages);
                Iterator i$ = sortedPackages.iterator();
                while (i$.hasNext()) {
                    String pkg = (String)i$.next();
                    String name = pkg.replace('.', '/') + "/annotations.xml";
                    JarEntry outEntry = new JarEntry(name);
                    zos.putNextEntry(outEntry);
                    StringWriter stringWriter = new StringWriter(1000);
                    PrintWriter writer = new PrintWriter(stringWriter);
                    try {
                        Document document;
                        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root>");
                        Map<String, List<Item>> classMap = this.itemMap.get(pkg);
                        ArrayList<String> classes = new ArrayList<String>(classMap.keySet());
                        Collections.sort(classes);
                        for (String cls : classes) {
                            List<Item> items = classMap.get(cls);
                            Collections.sort(items);
                            for (Item item : items) {
                                item.write(writer);
                            }
                        }
                        writer.println("</root>\n");
                        writer.close();
                        String xml = stringWriter.toString();
                        if (LintUtils.assertionsEnabled() && (document = Extractor.checkDocument(pkg, xml, false)) == null) {
                            Extractor.error("Could not parse XML document back in for entry " + name + ": invalid XML?\n\"\"\"\n" + xml + "\n\"\"\"\n");
                            boolean bl = false;
                            return bl;
                        }
                        byte[] bytes = xml.getBytes(Charsets.UTF_8);
                        zos.write(bytes);
                        zos.closeEntry();
                    }
                    finally {
                        writer.close();
                    }
                }
                return true;
            }
            finally {
                zos.flush();
                zos.close();
            }
        }
        catch (IOException ioe) {
            Extractor.error(ioe.toString());
            return false;
        }
    }

    private void addItem(String fqn, Item item) {
        List items;
        if (this.apiFilter != null && item.isFiltered(this.apiFilter)) {
            if (this.isListIgnored()) {
                this.info("Skipping API because it is not part of the API file: " + item);
            }
            ++this.filteredCount;
            return;
        }
        String pkg = Extractor.getPackage(fqn);
        HashMap classMap = this.itemMap.get(pkg);
        if (classMap == null) {
            classMap = Maps.newHashMapWithExpectedSize((int)100);
            this.itemMap.put(pkg, classMap);
        }
        if ((items = (List)classMap.get(fqn)) == null) {
            items = Lists.newArrayList();
            classMap.put(fqn, items);
        }
        items.add(item);
    }

    private void removeItem(String classFqn, Item item) {
        List<Item> items;
        String pkg = Extractor.getPackage(classFqn);
        Map<String, List<Item>> classMap = this.itemMap.get(pkg);
        if (classMap != null && (items = classMap.get(classFqn)) != null) {
            items.remove(item);
            if (items.isEmpty()) {
                classMap.remove(classFqn);
                if (classMap.isEmpty()) {
                    this.itemMap.remove(pkg);
                }
            }
        }
    }

    private Item findItem(String fqn, Item item) {
        String pkg = Extractor.getPackage(fqn);
        Map<String, List<Item>> classMap = this.itemMap.get(pkg);
        if (classMap == null) {
            return null;
        }
        List<Item> items = classMap.get(fqn);
        if (items == null) {
            return null;
        }
        for (Item existing : items) {
            if (!existing.equals(item)) continue;
            return existing;
        }
        return null;
    }

    private static Document checkDocument(String pkg, String xml, boolean namespaceAware) {
        try {
            return XmlUtils.parseDocument((String)xml, (boolean)namespaceAware);
        }
        catch (SAXException sax) {
            Extractor.warning("Failed to parse document for package " + pkg + ": " + sax.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void mergeExisting(File file) {
        block4: {
            block5: {
                block3: {
                    if (!file.isDirectory()) break block3;
                    File[] files = file.listFiles();
                    if (files == null) break block4;
                    for (File child : files) {
                        this.mergeExisting(child);
                    }
                    break block4;
                }
                if (!file.isFile()) break block4;
                if (!file.getPath().endsWith(".jar")) break block5;
                this.mergeFromJar(file);
                break block4;
            }
            if (!file.getPath().endsWith(".xml")) break block4;
            try {
                String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
                this.mergeAnnotationsXml(file.getPath(), xml);
            }
            catch (IOException e) {
                Extractor.error("Aborting: I/O problem during transform: " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void mergeFromJar(File jar) {
        block12: {
            JarInputStream zis = null;
            FileInputStream fis = new FileInputStream(jar);
            zis = new JarInputStream(fis);
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (entry.getName().endsWith(".xml")) {
                    byte[] bytes = ByteStreams.toByteArray((InputStream)zis);
                    String xml = new String(bytes, Charsets.UTF_8);
                    this.mergeAnnotationsXml(jar.getPath() + ": " + entry, xml);
                }
                entry = zis.getNextEntry();
            }
            try {
                Closeables.close((Closeable)zis, (boolean)true);
            }
            catch (IOException e) {}
            break block12;
            catch (IOException e) {
                try {
                    Extractor.error("Aborting: I/O problem during transform: " + e.toString());
                }
                catch (Throwable throwable) {
                    try {
                        Closeables.close(zis, (boolean)true);
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    Closeables.close((Closeable)zis, (boolean)true);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void mergeAnnotationsXml(String path, String xml) {
        block3: {
            try {
                Document document = XmlUtils.parseDocument((String)xml, (boolean)false);
                this.mergeDocument(document);
            }
            catch (Exception e) {
                String message = "Failed to merge " + path + ": " + e.toString();
                if (e instanceof SAXParseException) {
                    SAXParseException spe = (SAXParseException)e;
                    message = "Line " + spe.getLineNumber() + ":" + spe.getColumnNumber() + ": " + message;
                }
                Extractor.error(message);
                if (e instanceof IOException) break block3;
                e.printStackTrace();
            }
        }
    }

    private void mergeDocument(Document document) {
        Pattern XML_SIGNATURE = Pattern.compile("(\\S+) (\\S+|((.*)\\s+)?(\\S+)\\((.*)\\)( \\d+)?)");
        Element root = document.getDocumentElement();
        String rootTag = root.getTagName();
        assert (rootTag.equals("root")) : rootTag;
        for (Element item : Extractor.getChildren(root)) {
            Matcher matcher;
            String signature = item.getAttribute("name");
            if (signature == null || signature.equals("null") || !this.hasRelevantAnnotations(item)) continue;
            if ((signature = Extractor.unescapeXml(signature)).equals("java.util.Arrays void sort(T[], java.util.Comparator<?) 0")) {
                signature = "java.util.Arrays void sort(T[], java.util.Comparator<?>) 0";
            }
            if ((matcher = XML_SIGNATURE.matcher(signature)).matches()) {
                String methodName;
                String containingClass = matcher.group(1);
                if (containingClass == null) {
                    Extractor.warning("Could not find class for " + signature);
                }
                if ((methodName = matcher.group(5)) != null) {
                    String type = matcher.group(4);
                    boolean isConstructor = type == null;
                    String parameters = matcher.group(6);
                    this.mergeMethodOrParameter(item, matcher, containingClass, methodName, type, isConstructor, parameters);
                    continue;
                }
                String fieldName = matcher.group(2);
                this.mergeField(item, containingClass, fieldName);
                continue;
            }
            if (signature.indexOf(32) == -1 && signature.indexOf(46) != -1) continue;
            Extractor.warning("No merge match for signature " + signature);
        }
    }

    private static String unescapeXml(String escaped) {
        String workingString = escaped.replace("&quot;", "\"");
        workingString = workingString.replace("&lt;", "<");
        workingString = workingString.replace("&gt;", ">");
        workingString = workingString.replace("&apos;", "'");
        workingString = workingString.replace("&amp;", "&");
        return workingString;
    }

    private static String escapeXml(String unescaped) {
        return XmlEscapers.xmlAttributeEscaper().escape(unescaped);
    }

    private void mergeField(Element item, String containingClass, String fieldName) {
        if (this.apiFilter != null && !this.apiFilter.hasField(containingClass, fieldName)) {
            if (this.isListIgnored()) {
                this.info("Skipping imported element because it is not part of the API file: " + containingClass + "#" + fieldName);
            }
            ++this.filteredCount;
        } else {
            FieldItem fieldItem = new FieldItem(containingClass, ClassKind.CLASS, fieldName, null);
            Item existing = this.findItem(containingClass, fieldItem);
            if (existing != null) {
                this.mergedCount += this.mergeAnnotations(item, existing);
            } else {
                this.addItem(containingClass, fieldItem);
                this.mergedCount += this.addAnnotations(item, (Item)fieldItem);
            }
        }
    }

    private void mergeMethodOrParameter(Element item, Matcher matcher, String containingClass, String methodName, String type, boolean constructor, String parameters) {
        parameters = Extractor.fixParameterString(parameters);
        if (this.apiFilter != null && !this.apiFilter.hasMethod(containingClass, methodName, parameters)) {
            if (this.isListIgnored()) {
                this.info("Skipping imported element because it is not part of the API file: " + containingClass + "#" + methodName + "(" + parameters + ")");
            }
            ++this.filteredCount;
            return;
        }
        String argNum = matcher.group(7);
        if (argNum != null) {
            argNum = argNum.trim();
            ParameterItem parameterItem = new ParameterItem(containingClass, ClassKind.CLASS, type, methodName, parameters, constructor, argNum);
            Item existing = this.findItem(containingClass, parameterItem);
            if ("java.util.Calendar".equals(containingClass) && "set".equals(methodName) && Integer.parseInt(argNum) > 0) {
                return;
            }
            if (existing != null) {
                this.mergedCount += this.mergeAnnotations(item, existing);
            } else {
                this.addItem(containingClass, parameterItem);
                this.mergedCount += this.addAnnotations(item, (Item)parameterItem);
            }
        } else {
            MethodItem methodItem = new MethodItem(containingClass, ClassKind.CLASS, type, methodName, parameters, constructor);
            Item existing = this.findItem(containingClass, methodItem);
            if (existing != null) {
                this.mergedCount += this.mergeAnnotations(item, existing);
            } else {
                this.addItem(containingClass, methodItem);
                this.mergedCount += this.addAnnotations(item, (Item)methodItem);
            }
        }
    }

    private static String fixParameterString(String parameters) {
        return parameters.replace("  ", " ").replace(", ", ",");
    }

    private boolean hasRelevantAnnotations(Element item) {
        for (Element annotationElement : Extractor.getChildren(item)) {
            if (!this.isRelevantAnnotation(annotationElement)) continue;
            return true;
        }
        return false;
    }

    private boolean isRelevantAnnotation(Element annotationElement) {
        AnnotationData annotation = this.createAnnotation(annotationElement);
        if (annotation == null) {
            return false;
        }
        if (Extractor.isNullable(annotation.name) || Extractor.isNonNull(annotation.name) || annotation.name.startsWith(ANDROID_ANNOTATIONS_PREFIX) || annotation.name.startsWith("android.support.annotation.")) {
            return true;
        }
        if (annotation.name.equals(IDEA_CONTRACT)) {
            return true;
        }
        if (annotation.name.equals(IDEA_NON_NLS)) {
            return false;
        }
        if (!this.ignoredAnnotations.contains(annotation.name)) {
            this.ignoredAnnotations.add(annotation.name);
            if (this.isListIgnored()) {
                this.info("(Ignoring merge annotation " + annotation.name + ")");
            }
        }
        return false;
    }

    private static List<Element> getChildren(Element element) {
        NodeList itemList = element.getChildNodes();
        int length = itemList.getLength();
        ArrayList<Element> result = new ArrayList<Element>(Math.max(5, length / 2 + 1));
        for (int i = 0; i < length; ++i) {
            Node node = itemList.item(i);
            if (node.getNodeType() != 1) continue;
            result.add((Element)node);
        }
        return result;
    }

    private int addAnnotations(Element itemElement, Item item) {
        int count = 0;
        for (Element annotationElement : Extractor.getChildren(itemElement)) {
            if (!this.isRelevantAnnotation(annotationElement)) continue;
            AnnotationData annotation = this.createAnnotation(annotationElement);
            item.annotations.add(annotation);
            ++count;
        }
        return count;
    }

    private int mergeAnnotations(Element itemElement, Item item) {
        int count = 0;
        block0: for (Element annotationElement : Extractor.getChildren(itemElement)) {
            AnnotationData annotation;
            if (!this.isRelevantAnnotation(annotationElement) || (annotation = this.createAnnotation(annotationElement)) == null) continue;
            boolean haveNullable = false;
            boolean haveNotNull = false;
            for (AnnotationData existing : item.annotations) {
                if (Extractor.isNonNull(existing.name)) {
                    haveNotNull = true;
                }
                if (Extractor.isNullable(existing.name)) {
                    haveNullable = true;
                }
                if (!existing.equals(annotation)) continue;
                continue block0;
            }
            if (Extractor.isNonNull(annotation.name) && haveNullable || Extractor.isNullable(annotation.name) && haveNotNull) {
                Extractor.warning("Found both @Nullable and @NonNull after import for " + item);
                continue;
            }
            item.annotations.add(annotation);
            ++count;
        }
        return count;
    }

    private static boolean isNonNull(String name) {
        return name.equals(IDEA_NOTNULL) || name.equals(ANDROID_NOTNULL) || name.equals(SUPPORT_NOTNULL);
    }

    private static boolean isNullable(String name) {
        return name.equals(IDEA_NULLABLE) || name.equals(ANDROID_NULLABLE) || name.equals(SUPPORT_NULLABLE);
    }

    private AnnotationData createAnnotation(Element annotationElement) {
        AnnotationData annotation;
        String tagName = annotationElement.getTagName();
        assert (tagName.equals("annotation")) : tagName;
        String name = annotationElement.getAttribute("name");
        assert (name != null && !name.isEmpty());
        if (IDEA_MAGIC.equals(name)) {
            boolean flag;
            List<Element> children = Extractor.getChildren(annotationElement);
            assert (children.size() == 1) : children.size();
            Element valueElement = children.get(0);
            String valName = valueElement.getAttribute("name");
            String value = valueElement.getAttribute(ATTR_VAL);
            boolean flagsFromClass = valName.equals("flagsFromClass");
            boolean bl = flag = valName.equals("flags") || flagsFromClass;
            if (valName.equals("valuesFromClass") || flagsFromClass) {
                boolean found = false;
                if (value.endsWith(".class")) {
                    String clsName = value.substring(0, value.length() - ".class".length());
                    StringBuilder sb = new StringBuilder();
                    sb.append('{');
                    Field[] reflectionFields = null;
                    try {
                        Class<?> cls = Class.forName(clsName);
                        reflectionFields = cls.getDeclaredFields();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    if (this.apiFilter != null) {
                        HashSet fields = this.apiFilter.getDeclaredIntFields(clsName);
                        if ("java.util.zip.ZipEntry".equals(clsName)) {
                            fields = Sets.newHashSet((Object[])new String[]{"STORED", "DEFLATED"});
                        }
                        if (fields != null) {
                            ArrayList sorted = Lists.newArrayList(fields);
                            Collections.sort(sorted);
                            if (reflectionFields != null) {
                                int i;
                                final HashMap rank = Maps.newHashMap();
                                int n = sorted.size();
                                for (i = 0; i < n; ++i) {
                                    rank.put(sorted.get(i), reflectionFields.length + i);
                                }
                                n = reflectionFields.length;
                                for (i = 0; i < n; ++i) {
                                    rank.put(reflectionFields[i].getName(), i);
                                }
                                Collections.sort(sorted, new Comparator<String>(){

                                    @Override
                                    public int compare(String o1, String o2) {
                                        int rank2;
                                        int rank1 = (Integer)rank.get(o1);
                                        int delta = rank1 - (rank2 = ((Integer)rank.get(o2)).intValue());
                                        if (delta != 0) {
                                            return delta;
                                        }
                                        return o1.compareTo(o2);
                                    }
                                });
                            }
                            boolean first = true;
                            for (String field : sorted) {
                                if (first) {
                                    first = false;
                                } else {
                                    sb.append(',').append(' ');
                                }
                                sb.append(clsName).append('.').append(field);
                            }
                            found = true;
                        }
                    }
                    if (!found && reflectionFields != null && (this.apiFilter == null || this.apiFilter.hasClass(clsName))) {
                        boolean first = true;
                        for (Field field : reflectionFields) {
                            if (field.getType() != Integer.TYPE && field.getType() != Integer.TYPE) continue;
                            if (first) {
                                first = false;
                            } else {
                                sb.append(',').append(' ');
                            }
                            sb.append(clsName).append('.').append(field.getName());
                        }
                    }
                    sb.append('}');
                    value = sb.toString();
                    if (sb.length() > 2) {
                        found = true;
                    }
                }
                if (!found) {
                    return null;
                }
            }
            if (this.apiFilter != null) {
                value = this.removeFiltered(value);
                while (value.contains(", ,")) {
                    value = value.replace(", ,", ",");
                }
                if (value.startsWith(", ")) {
                    value = value.substring(2);
                }
            }
            annotation = new AnnotationData(valName.equals("stringValues") ? "android.support.annotation.StringDef" : "android.support.annotation.IntDef", new String[]{"value", value, flag ? "flag" : null, flag ? "true" : null});
        } else if ("android.support.annotation.StringDef".equals(name) || ANDROID_STRING_DEF.equals(name) || "android.support.annotation.IntDef".equals(name) || ANDROID_INT_DEF.equals(name)) {
            List<Element> children = Extractor.getChildren(annotationElement);
            Element valueElement = children.get(0);
            String valName = valueElement.getAttribute("name");
            assert ("value".equals(valName));
            String value = valueElement.getAttribute(ATTR_VAL);
            boolean flag = false;
            if (children.size() == 2) {
                valueElement = children.get(1);
                assert ("flag".equals(valueElement.getAttribute("name")));
                flag = "true".equals(valueElement.getAttribute(ATTR_VAL));
            }
            boolean intDef = "android.support.annotation.IntDef".equals(name) || ANDROID_INT_DEF.equals(name);
            annotation = new AnnotationData(intDef ? "android.support.annotation.IntDef" : "android.support.annotation.StringDef", new String[]{"value", value, flag ? "flag" : null, flag ? "true" : null});
        } else if (IDEA_CONTRACT.equals(name)) {
            List<Element> children = Extractor.getChildren(annotationElement);
            assert (children.size() == 1) : children.size();
            Element valueElement = children.get(0);
            String value = valueElement.getAttribute(ATTR_VAL);
            annotation = new AnnotationData(name, new String[]{"value", value});
        } else if (Extractor.isNonNull(name)) {
            annotation = new AnnotationData(SUPPORT_NOTNULL);
        } else if (Extractor.isNullable(name)) {
            if (IDEA_NULLABLE.equals(name)) {
                return null;
            }
            annotation = new AnnotationData(SUPPORT_NULLABLE);
        } else {
            List<Element> children = Extractor.getChildren(annotationElement);
            if (children.isEmpty()) {
                return new AnnotationData(name);
            }
            ArrayList attributeStrings = Lists.newArrayList();
            for (Element valueElement : children) {
                attributeStrings.add(valueElement.getAttribute("name"));
                attributeStrings.add(valueElement.getAttribute(ATTR_VAL));
            }
            annotation = new AnnotationData(name, attributeStrings.toArray(new String[attributeStrings.size()]));
        }
        return annotation;
    }

    private String removeFiltered(String value) {
        assert (this.apiFilter != null);
        if (value.startsWith("{")) {
            value = value.substring(1);
        }
        if (value.endsWith("}")) {
            value = value.substring(0, value.length() - 1);
        }
        value = value.trim();
        StringBuilder sb = new StringBuilder(value.length());
        sb.append('{');
        for (String fqn : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value)) {
            String field;
            if ((fqn = Extractor.unescapeXml(fqn)).startsWith("\"")) continue;
            int index = fqn.lastIndexOf(46);
            String cls = fqn.substring(0, index);
            if (this.apiFilter.hasField(cls, field = fqn.substring(index + 1))) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append(fqn);
                continue;
            }
            if (!this.isListIgnored()) continue;
            this.info("Skipping constant from typedef because it is not part of the SDK: " + fqn);
        }
        sb.append('}');
        return Extractor.escapeXml(sb.toString());
    }

    private static String getPackage(String fqn) {
        int index = 0;
        int last = 0;
        while ((index = fqn.indexOf(46, index)) != -1) {
            char next;
            last = index;
            if (index < fqn.length() - 1 && Character.isUpperCase(next = fqn.charAt(index + 1))) break;
            ++index;
        }
        return fqn.substring(0, last);
    }

    public void setListIgnored(boolean listIgnored) {
        this.listIgnored = listIgnored;
    }

    public boolean isListIgnored() {
        return this.listIgnored;
    }

    public AnnotationData createData(String name, Annotation annotation) {
        MemberValuePair[] pairs = annotation.memberValuePairs();
        if (pairs == null || pairs.length == 0) {
            return new AnnotationData(name);
        }
        return new AnnotationData(name, pairs);
    }

    private static String getReturnType(MethodBinding binding) {
        if (binding.returnType != null) {
            return new String(binding.returnType.readableName());
        }
        if (binding.declaringClass != null) {
            assert (binding.isConstructor());
            return new String(binding.declaringClass.readableName());
        }
        return null;
    }

    private static String getMethodName(MethodBinding binding) {
        if (binding.isConstructor() && binding.declaringClass != null) {
            String classFqn = new String(binding.declaringClass.readableName());
            return classFqn.substring(classFqn.lastIndexOf(46) + 1);
        }
        if (binding.selector != null) {
            return new String(binding.selector);
        }
        assert (binding.isConstructor());
        return null;
    }

    private static String getParameterList(MethodBinding binding, boolean isVarargs) {
        StringBuilder sb = new StringBuilder();
        TypeBinding[] typeParameters = binding.parameters;
        if (typeParameters != null) {
            int n = typeParameters.length;
            for (int i = 0; i < n; ++i) {
                TypeBinding parameter = typeParameters[i];
                if (i > 0) {
                    sb.append(',');
                }
                String str = Extractor.fixParameterString(new String(parameter.readableName()));
                if (isVarargs && i == n - 1 && str.endsWith("[]")) {
                    str = str.substring(0, str.length() - 2) + "...";
                }
                sb.append(str);
            }
        }
        return sb.toString();
    }

    private class AnnotationVisitor
    extends ASTVisitor {
        private AnnotationVisitor() {
        }

        public boolean visit(Argument argument, BlockScope scope) {
            ReferenceContext referenceContext;
            Annotation[] annotations = argument.annotations;
            if (Extractor.this.hasRelevantAnnotations(annotations) && (referenceContext = scope.referenceContext()) instanceof AbstractMethodDeclaration) {
                ClassKind kind;
                MethodBinding binding = ((AbstractMethodDeclaration)referenceContext).binding;
                ClassScope classScope = Extractor.findClassScope((Scope)scope);
                if (classScope == null) {
                    return false;
                }
                String fqn = Extractor.getFqn(classScope);
                ParameterItem item = ParameterItem.create((AbstractMethodDeclaration)referenceContext, argument, fqn, kind = ClassKind.forType(classScope.referenceContext), binding, argument.binding);
                if (item != null) {
                    Extractor.this.addItem(fqn, item);
                    Extractor.this.addAnnotations(annotations, item);
                }
            }
            return false;
        }

        public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
            Argument[] arguments;
            Annotation[] annotations = constructorDeclaration.annotations;
            if (Extractor.this.hasRelevantAnnotations(annotations)) {
                ClassKind kind;
                MethodBinding constructorBinding = constructorDeclaration.binding;
                if (constructorBinding == null) {
                    return false;
                }
                String fqn = Extractor.getFqn(scope);
                MethodItem item = MethodItem.create(fqn, kind = ClassKind.forType(scope.referenceContext), (AbstractMethodDeclaration)constructorDeclaration, constructorBinding);
                if (item != null) {
                    Extractor.this.addItem(fqn, item);
                    Extractor.this.addAnnotations(annotations, item);
                }
            }
            if ((arguments = constructorDeclaration.arguments) != null) {
                for (Argument argument : arguments) {
                    argument.traverse((ASTVisitor)this, (BlockScope)constructorDeclaration.scope);
                }
            }
            return false;
        }

        public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
            Annotation[] annotations = fieldDeclaration.annotations;
            if (Extractor.this.hasRelevantAnnotations(annotations)) {
                ClassKind kind;
                FieldBinding fieldBinding = fieldDeclaration.binding;
                if (fieldBinding == null) {
                    return false;
                }
                String fqn = Extractor.getFqn(scope);
                FieldItem item = FieldItem.create(fqn, kind = scope.referenceContext instanceof TypeDeclaration ? ClassKind.forType((TypeDeclaration)scope.referenceContext) : ClassKind.CLASS, fieldBinding);
                if (item != null && fqn != null) {
                    Extractor.this.addItem(fqn, item);
                    Extractor.this.addAnnotations(annotations, item);
                }
            }
            return false;
        }

        public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
            Argument[] arguments;
            Annotation[] annotations = methodDeclaration.annotations;
            if (Extractor.this.hasRelevantAnnotations(annotations)) {
                ClassKind kind;
                MethodBinding methodBinding = methodDeclaration.binding;
                if (methodBinding == null) {
                    return false;
                }
                String fqn = Extractor.getFqn(scope);
                MethodItem item = MethodItem.create(fqn, kind = ClassKind.forType(scope.referenceContext), (AbstractMethodDeclaration)methodDeclaration, methodDeclaration.binding);
                if (item != null) {
                    Extractor.this.addItem(fqn, item);
                    boolean skipReturnAnnotations = false;
                    if ("findViewById".equals(item.getName())) {
                        skipReturnAnnotations = true;
                        if (item.annotations.isEmpty()) {
                            Extractor.this.removeItem(fqn, item);
                        }
                    }
                    if (!skipReturnAnnotations) {
                        Extractor.this.addAnnotations(annotations, item);
                    }
                }
            }
            if ((arguments = methodDeclaration.arguments) != null) {
                for (Argument argument : arguments) {
                    argument.traverse((ASTVisitor)this, (BlockScope)methodDeclaration.scope);
                }
            }
            return false;
        }

        public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
            Annotation[] annotations = localTypeDeclaration.annotations;
            if (Extractor.this.hasRelevantAnnotations(annotations)) {
                SourceTypeBinding binding = localTypeDeclaration.binding;
                if (binding == null) {
                    return true;
                }
                String fqn = Extractor.getFqn(scope);
                if (fqn == null) {
                    fqn = new String(localTypeDeclaration.binding.readableName());
                }
                ClassItem item = ClassItem.create(fqn, ClassKind.forType(localTypeDeclaration));
                Extractor.this.addItem(fqn, item);
                Extractor.this.addAnnotations(annotations, item);
            }
            return true;
        }

        public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
            Annotation[] annotations = memberTypeDeclaration.annotations;
            if (Extractor.this.hasRelevantAnnotations(annotations)) {
                SourceTypeBinding binding = memberTypeDeclaration.binding;
                if (!(binding instanceof MemberTypeBinding)) {
                    return true;
                }
                if (binding.isAnnotationType() || binding.isAnonymousType()) {
                    return false;
                }
                String fqn = new String(memberTypeDeclaration.binding.readableName());
                ClassItem item = ClassItem.create(fqn, ClassKind.forType(memberTypeDeclaration));
                Extractor.this.addItem(fqn, item);
                Extractor.this.addAnnotations(annotations, item);
            }
            return true;
        }

        public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
            Annotation[] annotations = typeDeclaration.annotations;
            if (Extractor.this.hasRelevantAnnotations(annotations)) {
                SourceTypeBinding binding = typeDeclaration.binding;
                if (binding == null) {
                    return true;
                }
                String fqn = new String(typeDeclaration.binding.readableName());
                ClassItem item = ClassItem.create(fqn, ClassKind.forType(typeDeclaration));
                Extractor.this.addItem(fqn, item);
                Extractor.this.addAnnotations(annotations, item);
            }
            return true;
        }
    }

    private static class ParameterItem
    extends MethodItem {
        public final String argIndex;

        private ParameterItem(String containingClass, ClassKind classKind, String returnType, String methodName, String parameterList, boolean isConstructor, String argIndex) {
            super(containingClass, classKind, returnType, methodName, parameterList, isConstructor);
            this.argIndex = argIndex;
        }

        static ParameterItem create(AbstractMethodDeclaration methodDeclaration, Argument argument, String classFqn, ClassKind classKind, MethodBinding methodBinding, LocalVariableBinding parameterBinding) {
            if (classFqn == null || methodBinding == null || parameterBinding == null) {
                return null;
            }
            String methodName = Extractor.getMethodName(methodBinding);
            Argument[] arguments = methodDeclaration.arguments;
            boolean isVarargs = arguments != null && arguments.length > 0 && arguments[arguments.length - 1].isVarArgs();
            String parameterList = Extractor.getParameterList(methodBinding, isVarargs);
            String returnType = Extractor.getReturnType(methodBinding);
            if (methodName == null || returnType == null) {
                return null;
            }
            int index = 0;
            boolean found = false;
            if (methodDeclaration.arguments != null) {
                for (Argument a : methodDeclaration.arguments) {
                    if (a == argument) {
                        found = true;
                        break;
                    }
                    ++index;
                }
            }
            if (!found) {
                return null;
            }
            String argNum = Integer.toString(index);
            classFqn = ApiDatabase.getRawClass(classFqn);
            methodName = ApiDatabase.getRawMethod(methodName);
            return new ParameterItem(classFqn, classKind, returnType, methodName, parameterList, methodBinding.isConstructor(), argNum);
        }

        @Override
        String getSignature() {
            return super.getSignature() + ' ' + this.argIndex;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ParameterItem that = (ParameterItem)o;
            return this.argIndex.equals(that.argIndex);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.argIndex.hashCode();
            return result;
        }

        @Override
        public String toString() {
            return "Parameter #" + this.argIndex + " in " + super.toString();
        }

        @Override
        public String getKeepRule() {
            return "";
        }
    }

    private static class MethodItem
    extends Item {
        public final String methodName;
        public final String parameterList;
        public final String returnType;
        public final boolean isConstructor;

        private MethodItem(String containingClass, ClassKind classKind, String returnType, String methodName, String parameterList, boolean isConstructor) {
            super(containingClass, classKind);
            this.returnType = returnType;
            this.methodName = methodName;
            this.parameterList = parameterList;
            this.isConstructor = isConstructor;
        }

        public String getName() {
            return this.methodName;
        }

        static MethodItem create(String classFqn, ClassKind classKind, AbstractMethodDeclaration declaration, MethodBinding binding) {
            if (classFqn == null || binding == null) {
                return null;
            }
            String returnType = Extractor.getReturnType(binding);
            String methodName = Extractor.getMethodName(binding);
            Argument[] arguments = declaration.arguments;
            boolean isVarargs = arguments != null && arguments.length > 0 && arguments[arguments.length - 1].isVarArgs();
            String parameterList = Extractor.getParameterList(binding, isVarargs);
            if (returnType == null || methodName == null) {
                return null;
            }
            classFqn = ApiDatabase.getRawClass(classFqn);
            methodName = ApiDatabase.getRawMethod(methodName);
            return new MethodItem(classFqn, classKind, returnType, methodName, parameterList, binding.isConstructor());
        }

        @Override
        String getSignature() {
            StringBuilder sb = new StringBuilder(100);
            sb.append(Extractor.escapeXml(this.containingClass));
            sb.append(' ');
            if (this.isConstructor) {
                sb.append(Extractor.escapeXml(this.methodName));
            } else {
                assert (this.returnType != null);
                sb.append(Extractor.escapeXml(this.returnType));
                sb.append(' ');
                sb.append(Extractor.escapeXml(this.methodName));
            }
            sb.append('(');
            int balance = 0;
            int n = this.parameterList.length();
            for (int i = 0; i < n; ++i) {
                char c = this.parameterList.charAt(i);
                if (c == '<') {
                    ++balance;
                    sb.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    --balance;
                    sb.append("&gt;");
                    continue;
                }
                if (c == ',') {
                    sb.append(',');
                    if (balance != 0) continue;
                    sb.append(' ');
                    continue;
                }
                sb.append(c);
            }
            sb.append(')');
            return sb.toString();
        }

        @Override
        boolean isFiltered(ApiDatabase database) {
            return !database.hasMethod(this.containingClass, this.methodName, this.parameterList);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodItem that = (MethodItem)o;
            return this.isConstructor == that.isConstructor && this.containingClass.equals(that.containingClass) && this.methodName.equals(that.methodName) && this.parameterList.equals(that.parameterList);
        }

        public int hashCode() {
            int result = this.methodName.hashCode();
            result = 31 * result + this.containingClass.hashCode();
            result = 31 * result + this.parameterList.hashCode();
            result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
            result = 31 * result + (this.isConstructor ? 1 : 0);
            return result;
        }

        public String toString() {
            return "Method " + this.containingClass + "#" + this.methodName;
        }

        @Override
        public String getKeepRule() {
            StringBuilder sb = new StringBuilder();
            sb.append("-keep ");
            sb.append(this.classKind.getKeepType());
            sb.append(" ");
            sb.append(this.containingClass);
            sb.append(" {\n");
            sb.append("    ");
            if (this.isConstructor) {
                sb.append("<init>");
            } else {
                sb.append(this.returnType);
                sb.append(" ");
                sb.append(this.methodName);
            }
            sb.append("(");
            sb.append(this.parameterList);
            sb.append(")\n");
            sb.append("}\n");
            return sb.toString();
        }

        @Override
        public String getQualifiedClassName() {
            return this.containingClass;
        }
    }

    private static class FieldItem
    extends Item {
        public final String fieldName;
        public final String fieldType;

        private FieldItem(String containingClass, ClassKind classKind, String fieldName, String fieldType) {
            super(containingClass, classKind);
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }

        static FieldItem create(String classFqn, ClassKind classKind, FieldBinding field) {
            String name = new String(field.name);
            String type = FieldItem.getFieldType(field);
            return classFqn != null ? new FieldItem(classFqn, classKind, name, type) : null;
        }

        private static String getFieldType(FieldBinding binding) {
            if (binding.type != null) {
                return new String(binding.type.readableName());
            }
            return null;
        }

        @Override
        boolean isFiltered(ApiDatabase database) {
            return !database.hasField(this.containingClass, this.fieldName);
        }

        @Override
        String getSignature() {
            return Extractor.escapeXml(this.containingClass) + ' ' + this.fieldName;
        }

        @Override
        public String getKeepRule() {
            if (this.fieldType == null) {
                return "";
            }
            return "-keep " + this.classKind.getKeepType() + " " + this.containingClass + " {\n    " + this.fieldType + " " + this.fieldName + "\n}\n";
        }

        @Override
        public String getQualifiedClassName() {
            return this.containingClass;
        }

        public String toString() {
            return "Field " + this.containingClass + "#" + this.fieldName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldItem that = (FieldItem)o;
            return this.containingClass.equals(that.containingClass) && this.fieldName.equals(that.fieldName);
        }

        public int hashCode() {
            int result = this.fieldName.hashCode();
            result = 31 * result + this.containingClass.hashCode();
            return result;
        }
    }

    private static class ClassItem
    extends Item {
        private ClassItem(String containingClass, ClassKind classKind) {
            super(containingClass, classKind);
        }

        static ClassItem create(String classFqn, ClassKind kind) {
            classFqn = ApiDatabase.getRawClass(classFqn);
            return new ClassItem(classFqn, kind);
        }

        @Override
        boolean isFiltered(ApiDatabase database) {
            return !database.hasClass(this.containingClass);
        }

        @Override
        String getSignature() {
            return Extractor.escapeXml(this.containingClass);
        }

        @Override
        public String getKeepRule() {
            return "-keep " + this.classKind.getKeepType() + " " + this.containingClass + "\n";
        }

        @Override
        public String getQualifiedClassName() {
            return this.containingClass;
        }

        public String toString() {
            return "Class " + this.containingClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassItem that = (ClassItem)o;
            return this.containingClass.equals(that.containingClass);
        }

        public int hashCode() {
            return this.containingClass.hashCode();
        }
    }

    private static abstract class Item
    implements Comparable<Item> {
        public final String containingClass;
        public final ClassKind classKind;
        public final List<AnnotationData> annotations = Lists.newArrayList();

        public Item(String containingClass, ClassKind classKind) {
            this.containingClass = containingClass;
            this.classKind = classKind;
        }

        void write(PrintWriter writer) {
            if (this.annotations.isEmpty()) {
                return;
            }
            writer.print("  <item name=\"");
            writer.print(this.getSignature());
            writer.println("\">");
            for (AnnotationData annotation : this.annotations) {
                annotation.write(writer);
            }
            writer.print("  </item>");
            writer.println();
        }

        abstract boolean isFiltered(ApiDatabase var1);

        abstract String getSignature();

        @Override
        public int compareTo(Item item) {
            String signature1 = this.getSignature();
            String signature2 = item.getSignature();
            signature1 = signature1.replace('&', '.');
            signature2 = signature2.replace('&', '.');
            return signature1.compareTo(signature2);
        }

        public abstract String getKeepRule();

        public abstract String getQualifiedClassName();
    }

    public static enum ClassKind {
        CLASS,
        INTERFACE,
        ENUM,
        ANNOTATION;


        public static ClassKind forType(TypeDeclaration declaration) {
            if (declaration == null) {
                return CLASS;
            }
            switch (TypeDeclaration.kind((int)declaration.modifiers)) {
                case 2: {
                    return INTERFACE;
                }
                case 4: {
                    return ANNOTATION;
                }
                case 3: {
                    return ENUM;
                }
            }
            return CLASS;
        }

        public String getKeepType() {
            switch (this) {
                case INTERFACE: {
                    return "interface";
                }
                case ENUM: {
                    return "enum";
                }
            }
            return "class";
        }
    }

    private class AnnotationData {
        public final String name;
        public String[] attributeStrings;
        public MemberValuePair[] attributes;

        private AnnotationData(String name) {
            this.name = name;
        }

        private AnnotationData(String name, MemberValuePair[] pairs) {
            this(name);
            this.attributes = pairs;
            assert (this.attributes == null || this.attributes.length > 0);
        }

        private AnnotationData(String name, String[] attributeStrings) {
            this(name);
            this.attributeStrings = attributeStrings;
            assert (attributeStrings != null && attributeStrings.length > 0);
        }

        void write(PrintWriter writer) {
            writer.print("    <annotation name=\"");
            writer.print(this.name);
            if (this.attributes != null) {
                MemberValuePair[] attributes;
                writer.print("\">");
                writer.println();
                if (this.attributes.length > 1 && Extractor.this.sortAnnotations) {
                    Arrays.sort(this.attributes, new Comparator<MemberValuePair>(){

                        private String getName(MemberValuePair pair) {
                            if (pair.name == null) {
                                return "value";
                            }
                            return new String(pair.name);
                        }

                        private int rank(MemberValuePair pair) {
                            return "value".equals(this.getName(pair)) ? -1 : 0;
                        }

                        @Override
                        public int compare(MemberValuePair o1, MemberValuePair o2) {
                            int r2;
                            int r1 = this.rank(o1);
                            int delta = r1 - (r2 = this.rank(o2));
                            if (delta != 0) {
                                return delta;
                            }
                            return this.getName(o1).compareTo(this.getName(o2));
                        }
                    });
                }
                if ((attributes = this.attributes).length == 1 && this.name.startsWith(Extractor.REQUIRES_PERMISSION) && this.name.length() > Extractor.REQUIRES_PERMISSION.length() && attributes[0].value instanceof SingleMemberAnnotation) {
                    SingleMemberAnnotation annotation = (SingleMemberAnnotation)attributes[0].value;
                    attributes = annotation.memberValuePairs();
                }
                for (MemberValuePair pair : attributes) {
                    writer.print("      <val name=\"");
                    if (pair.name != null) {
                        writer.print(pair.name);
                    } else {
                        writer.print("value");
                    }
                    writer.print("\" val=\"");
                    writer.print(Extractor.escapeXml(this.attributeString(pair.value)));
                    writer.println("\" />");
                }
                writer.println("    </annotation>");
            } else if (this.attributeStrings != null) {
                writer.print("\">");
                writer.println();
                for (int i = 0; i < this.attributeStrings.length; i += 2) {
                    String name = this.attributeStrings[i];
                    String value = this.attributeStrings[i + 1];
                    if (name == null) continue;
                    writer.print("      <val name=\"");
                    writer.print(name);
                    writer.print("\" val=\"");
                    writer.print(Extractor.escapeXml(value));
                    writer.println("\" />");
                }
                writer.println("    </annotation>");
            } else {
                writer.println("\" />");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationData that = (AnnotationData)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        private String attributeString(Expression value) {
            StringBuilder sb = new StringBuilder();
            this.appendExpression(sb, value);
            return sb.toString();
        }

        private boolean appendExpression(StringBuilder sb, Expression expression) {
            if (expression instanceof ArrayInitializer) {
                sb.append('{');
                ArrayInitializer initializer = (ArrayInitializer)expression;
                boolean first = true;
                int initialLength = sb.length();
                for (Expression e : initializer.expressions) {
                    int length = sb.length();
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    boolean appended = this.appendExpression(sb, e);
                    if (appended) continue;
                    sb.setLength(length);
                    if (length != initialLength) continue;
                    first = true;
                }
                sb.append('}');
                return true;
            }
            if (expression instanceof NameReference) {
                NameReference reference = (NameReference)expression;
                if (reference.binding != null) {
                    if (reference.binding instanceof FieldBinding) {
                        FieldBinding fb = (FieldBinding)reference.binding;
                        Constant constant = fb.constant();
                        if (constant != null && constant != Constant.NotAConstant && !this.name.equals("android.support.annotation.IntDef") && !this.name.equals("android.support.annotation.StringDef")) {
                            if (constant instanceof StringConstant) {
                                sb.append('\"').append(constant.stringValue()).append('\"');
                                return true;
                            }
                            if (constant instanceof IntConstant) {
                                sb.append(Integer.toString(constant.intValue()));
                                return true;
                            }
                            if (constant instanceof BooleanConstant) {
                                sb.append(Boolean.toString(constant.booleanValue()));
                                return true;
                            }
                            if (constant instanceof LongConstant) {
                                sb.append(Long.toString(constant.longValue()));
                                return true;
                            }
                            if (constant instanceof DoubleConstant) {
                                sb.append(Double.toString(constant.doubleValue()));
                                return true;
                            }
                            if (constant instanceof CharConstant) {
                                sb.append('\'').append(Character.toString(constant.charValue())).append('\'');
                                return true;
                            }
                            if (constant instanceof FloatConstant) {
                                sb.append(Float.toString(constant.floatValue()));
                                return true;
                            }
                            if (constant instanceof ShortConstant) {
                                sb.append(Short.toString(constant.shortValue()));
                                return true;
                            }
                            if (constant instanceof ByteConstant) {
                                sb.append(Byte.toString(constant.byteValue()));
                                return true;
                            }
                        }
                        if (fb.declaringClass != null) {
                            if (Extractor.this.apiFilter != null && !Extractor.this.apiFilter.hasField(new String(fb.declaringClass.readableName()), new String(fb.name))) {
                                if (Extractor.this.isListIgnored()) {
                                    Extractor.this.info("Filtering out typedef constant " + new String(fb.declaringClass.readableName()) + "." + new String(fb.name) + "");
                                }
                                return false;
                            }
                            sb.append(fb.declaringClass.readableName());
                            sb.append('.');
                            sb.append(fb.name);
                        } else {
                            sb.append(reference.binding.readableName());
                        }
                    } else {
                        sb.append(reference.binding.readableName());
                    }
                    return true;
                }
                Extractor.warning("No binding for reference " + reference);
                return false;
            }
            if (expression instanceof StringLiteral) {
                StringLiteral s = (StringLiteral)expression;
                sb.append('\"');
                sb.append(s.source());
                sb.append('\"');
                return true;
            }
            if (expression instanceof NumberLiteral) {
                NumberLiteral number = (NumberLiteral)expression;
                sb.append(number.source());
                return true;
            }
            if (expression instanceof TrueLiteral) {
                sb.append(true);
                return true;
            }
            if (expression instanceof FalseLiteral) {
                sb.append(false);
                return true;
            }
            if (expression instanceof NullLiteral) {
                sb.append("null");
                return true;
            }
            if (expression.constant != null) {
                if (expression.constant.typeID() == 10) {
                    sb.append(expression.constant.intValue());
                    return true;
                }
                if (expression.constant.typeID() == 11) {
                    sb.append('\"');
                    sb.append(expression.constant.stringValue());
                    sb.append('\"');
                    return true;
                }
                Extractor.warning("Unexpected type for constant " + expression.constant.toString());
            } else {
                Extractor.warning("Unexpected annotation expression of type " + expression.getClass() + " and is " + expression);
            }
            return false;
        }
    }
}

