/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.builder.model.MavenCoordinates;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import org.gradle.api.artifacts.ResolvedArtifact;

public class MavenCoordinatesImpl
implements MavenCoordinates,
Serializable {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String packaging;
    private final String classifier;

    public MavenCoordinatesImpl(ResolvedArtifact resolvedArtifact) {
        this(resolvedArtifact.getModuleVersion().getId().getGroup(), resolvedArtifact.getModuleVersion().getId().getName(), resolvedArtifact.getModuleVersion().getId().getVersion(), resolvedArtifact.getExtension(), resolvedArtifact.getClassifier());
    }

    MavenCoordinatesImpl(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null, null);
    }

    MavenCoordinatesImpl(String groupId, String artifactId, String version, String packaging, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.packaging = packaging != null ? packaging : "jar";
        this.classifier = classifier;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenCoordinatesImpl that = (MavenCoordinatesImpl)o;
        return Objects.equal((Object)this.groupId, (Object)that.groupId) && Objects.equal((Object)this.artifactId, (Object)that.artifactId) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.packaging, (Object)that.packaging) && Objects.equal((Object)this.classifier, (Object)that.classifier);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.groupId, this.artifactId, this.version, this.packaging, this.classifier});
    }

    public String toString() {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{this.groupId, this.artifactId, this.packaging});
        if (!Strings.isNullOrEmpty((String)this.classifier)) {
            segments.add(this.classifier);
        }
        segments.add(this.version);
        return Joiner.on((char)':').join((Iterable)segments);
    }
}

