/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public class TypedVariable {
    private static final Logger LOG = Logger.getInstance(TypedVariable.class);

    @Nullable
    public static Object parse(@NotNull Type type, @Nullable String value) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/templates/TypedVariable", "parse"));
        }
        if (value == null) {
            return null;
        }
        switch (type) {
            case STRING: {
                return value;
            }
            case BOOLEAN: {
                if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
                    return Boolean.TRUE;
                }
                if (Boolean.FALSE.toString().equalsIgnoreCase(value)) {
                    return Boolean.FALSE;
                }
                return null;
            }
            case INTEGER: {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        LOG.error("NumberFormatException while evaluating " + value);
                    }
                    return null;
                }
            }
        }
        return null;
    }

    @Nullable
    public static Object parseGlobal(@NotNull Attributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/templates/TypedVariable", "parseGlobal"));
        }
        String value = attributes.getValue("value");
        Type type = Type.get(attributes.getValue("type"));
        Object result = TypedVariable.parse(type, value);
        return result != null ? result : value;
    }

    public static enum Type {
        STRING,
        BOOLEAN,
        INTEGER;


        @NotNull
        public static Type get(@Nullable String name) {
            Type type;
            if (name == null) {
                Type type2 = STRING;
                if (type2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TypedVariable$Type", "get"));
                }
                return type2;
            }
            try {
                type = Type.valueOf(name.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.error("Unexpected global type '" + name + "'");
                    LOG.error("Expected one of :");
                    for (Type s : Type.values()) {
                        LOG.error("  " + s.name().toLowerCase(Locale.US));
                    }
                }
                Type type3 = STRING;
                if (type3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TypedVariable$Type", "get"));
                }
                return type3;
            }
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TypedVariable$Type", "get"));
            }
            return type;
        }
    }
}

