/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.StudioTemplateLoader;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.TypedVariable;
import com.android.tools.idea.templates.parse.SaxUtils;
import com.android.tools.idea.templates.recipe.Recipe;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Template {
    public static final String TEMPLATE_XML_NAME = "template.xml";
    public static final String TAG_EXECUTE = "execute";
    public static final String TAG_GLOBALS = "globals";
    public static final String TAG_GLOBAL = "global";
    public static final String TAG_PARAMETER = "parameter";
    public static final String TAG_THUMB = "thumb";
    public static final String TAG_THUMBS = "thumbs";
    public static final String TAG_DEPENDENCY = "dependency";
    public static final String TAG_ICONS = "icons";
    public static final String ATTR_FORMAT = "format";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_DEFAULT = "default";
    public static final String ATTR_SUGGEST = "suggest";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_HELP = "help";
    public static final String ATTR_FILE = "file";
    public static final String ATTR_CONSTRAINTS = "constraints";
    public static final String ATTR_VISIBILITY = "visibility";
    public static final String ATTR_ENABLED = "enabled";
    public static final String CATEGORY_ACTIVITIES = "activities";
    public static final String CATEGORY_PROJECTS = "gradle-projects";
    public static final String CATEGORY_OTHER = "other";
    public static final String CATEGORY_APPLICATION = "Application";
    static final int CURRENT_FORMAT = 5;
    static final int RELATIVE_FILES_FORMAT = 5;
    private static final int MAX_WARNINGS = 10;
    private static final String GOOGLE_GLASS_PATH_19 = "/addon-google_gdk-google-19/";
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.Template");
    private final File myTemplateRoot;
    private TemplateMetadata myMetadata;

    private Template(@NotNull File templateRoot) {
        if (templateRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateRoot", "com/android/tools/idea/templates/Template", "<init>"));
        }
        this.myTemplateRoot = templateRoot;
    }

    @NotNull
    public static Template createFromPath(@NotNull File rootPath) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/android/tools/idea/templates/Template", "createFromPath"));
        }
        Template template = new Template(rootPath);
        if (template == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "createFromPath"));
        }
        return template;
    }

    @NotNull
    public static Template createFromName(@NotNull String category, @NotNull String name) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/android/tools/idea/templates/Template", "createFromName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_NAME, "com/android/tools/idea/templates/Template", "createFromName"));
        }
        TemplateManager manager = TemplateManager.getInstance();
        List<File> templates = manager.getTemplates(category);
        for (File file : templates) {
            if (!file.getName().equals(name) || !category.equals(file.getParentFile().getName())) continue;
            Template template = new Template(file);
            if (template == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "createFromName"));
            }
            return template;
        }
        Template template = new Template(new File(TemplateManager.getTemplateRootFolder(), category + File.separator + name));
        if (template == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "createFromName"));
        }
        return template;
    }

    @NotNull
    public static Map<String, Object> createParameterMap(@NotNull Map<String, Object> args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "createParameterMap"));
        }
        Map<String, Object> paramMap = FreemarkerUtils.createParameterMap(args);
        if (ApplicationManager.getApplication() != null && TemplateManager.getTemplateRootFolder() != null) {
            paramMap.put("templateRoot", TemplateManager.getTemplateRootFolder().getAbsolutePath());
        }
        Map<String, Object> map = paramMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "createParameterMap"));
        }
        return map;
    }

    private static void enforceParameterTypes(@NotNull TemplateMetadata metadata, @NotNull Map<String, Object> args) {
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/templates/Template", "enforceParameterTypes"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "enforceParameterTypes"));
        }
        for (Parameter p : metadata.getParameters()) {
            Object o = args.get(p.id);
            if (o == null) continue;
            switch (p.type) {
                case STRING: {
                    if (o instanceof String) break;
                    args.put(p.id, o.toString());
                    break;
                }
                case BOOLEAN: {
                    if (o instanceof Boolean) break;
                    args.put(p.id, Boolean.parseBoolean(o.toString()));
                    break;
                }
                case ENUM: {
                    break;
                }
            }
        }
        Template.convertApisToInt(args);
    }

    public static void convertApisToInt(@NotNull Map<String, Object> args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "convertApisToInt"));
        }
        Template.convertToInt("buildApi", args);
        Template.convertToInt("minApiLevel", args);
        Template.convertToInt("targetApi", args);
    }

    private static void convertToInt(@NotNull String key, @NotNull Map<String, Object> args) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/templates/Template", "convertToInt"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "convertToInt"));
        }
        Object value = args.get(key);
        if (value instanceof String) {
            Integer result;
            try {
                result = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                result = SdkVersionInfo.getApiByPreviewName((String)((String)value), (boolean)true);
            }
            args.put(key, result);
        }
    }

    public boolean render(final @NotNull RenderingContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/Template", "render"));
        }
        boolean success = Template.runWriteCommandAction(context.getProject(), context.getCommandName(), new Computable<Boolean>(){

            public Boolean compute() {
                if (context.getProject().isInitialized()) {
                    return Template.this.doRender(context);
                }
                return (Boolean)PostprocessReformattingAspect.getInstance((Project)context.getProject()).disablePostprocessFormattingInside((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        return Template.this.doRender(context);
                    }
                });
            }
        });
        String title = this.myMetadata.getTitle();
        if (title != null) {
            UsageTracker.getInstance().trackEvent("template", "render", title, null);
        }
        return success;
    }

    private static <T> T runWriteCommandAction(@NotNull Project project, @NotNull String commandName, final @NotNull Computable<T> computable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/Template", "runWriteCommandAction"));
        }
        if (commandName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "com/android/tools/idea/templates/Template", "runWriteCommandAction"));
        }
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/android/tools/idea/templates/Template", "runWriteCommandAction"));
        }
        RunResult result = new WriteCommandAction<T>(project, commandName, new PsiFile[0]){

            protected void run(@NotNull Result<T> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/templates/Template$2", "run"));
                }
                result.setResult(computable.compute());
            }
        }.execute();
        return (T)result.throwException().getResultObject();
    }

    private boolean doRender(@NotNull RenderingContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/Template", "doRender"));
        }
        TemplateMetadata metadata = this.getMetadata();
        assert (metadata != null);
        Template.enforceParameterTypes(metadata, context.getParamMap());
        try {
            this.processFile(context, new File(TEMPLATE_XML_NAME));
            if (!context.showWarnings() || context.getWarnings().isEmpty()) {
                return true;
            }
            if (!context.getProject().isInitialized() && this.myTemplateRoot.getPath().contains(GOOGLE_GLASS_PATH_19)) {
                return true;
            }
            int result = Messages.showOkCancelDialog((Project)context.getProject(), (String)Template.formatWarningMessage(context), (String)String.format("%1$s %2$s", context.getCommandName(), StringUtil.pluralize((String)"Warning")), (String)"Proceed Anyway", (String)"Cancel", (Icon)Messages.getWarningIcon());
            return result == 0;
        }
        catch (FreemarkerUtils.TemplateUserVisibleException e) {
            if (!context.showErrors()) {
                throw new RuntimeException(e);
            }
            Messages.showErrorDialog((Project)context.getProject(), (String)Template.formatErrorMessage(context, e), (String)String.format("%1$s Failed", context.getCommandName()));
            return false;
        }
        catch (FreemarkerUtils.TemplateProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String formatWarningMessage(@NotNull RenderingContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/Template", "formatWarningMessage"));
        }
        int warningCount = context.getWarnings().size();
        List<String> messages = Lists.newArrayList(context.getWarnings());
        if (warningCount > 11) {
            messages = messages.subList(0, 10);
            messages.add(String.format("And %1$d more warnings...", warningCount - 10));
        }
        messages.add("\nIf you proceed the resulting project may not compile or not work as intended.");
        return Joiner.on((String)"\n\n").join((Iterable)messages);
    }

    private static String formatErrorMessage(@NotNull RenderingContext context, @NotNull FreemarkerUtils.TemplateUserVisibleException ex) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/Template", "formatErrorMessage"));
        }
        if (ex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ex", "com/android/tools/idea/templates/Template", "formatErrorMessage"));
        }
        if (!context.canCausePartialRendering()) {
            return ex.getMessage();
        }
        return ex.getMessage() + String.format("\n\n%1$s was only partially completed.", context.getCommandName()) + "\nYour project may not compile." + "\nYou may want to Undo to get back to the original state.";
    }

    @NotNull
    public File getRootPath() {
        File file = this.myTemplateRoot;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getRootPath"));
        }
        return file;
    }

    @Nullable
    public TemplateMetadata getMetadata() {
        if (this.myMetadata == null) {
            this.myMetadata = TemplateManager.getInstance().getTemplateMetadata(this.myTemplateRoot);
        }
        return this.myMetadata;
    }

    private void processFile(final @NotNull RenderingContext context, @NotNull File file) throws FreemarkerUtils.TemplateProcessingException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/Template", "processFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_FILE, "com/android/tools/idea/templates/Template", "processFile"));
        }
        if (TemplateUtils.hasExtension(file, ".xml")) {
            String xml = TemplateUtils.readTextFromDisk(this.getTemplateFile(file));
            if (xml == null) {
                return;
            }
            this.processXml(context, xml);
        } else {
            FreemarkerUtils.processFreemarkerTemplate(context, file, new FreemarkerUtils.TemplatePostProcessor(){

                @Override
                public void process(@NotNull String xml) throws FreemarkerUtils.TemplateProcessingException {
                    if (xml == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "com/android/tools/idea/templates/Template$3", "process"));
                    }
                    Template.this.processXml(context, xml);
                }
            });
        }
    }

    private void processXml(final @NotNull RenderingContext context, @NotNull String xml) throws FreemarkerUtils.TemplateProcessingException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/Template", "processXml"));
        }
        if (xml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "com/android/tools/idea/templates/Template", "processXml"));
        }
        try {
            xml = XmlUtils.stripBom((String)xml);
            InputSource inputSource = new InputSource(new StringReader(xml));
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                    try {
                        Map<String, Object> paramMap = context.getParamMap();
                        if (Template.TAG_PARAMETER.equals(name)) {
                            String id = attributes.getValue(Template.ATTR_ID);
                            if (!paramMap.containsKey(id)) {
                                String type;
                                String value = attributes.getValue(Template.ATTR_DEFAULT);
                                Object mapValue = value;
                                if (value != null && !value.isEmpty() && "boolean".equals(type = attributes.getValue(Template.ATTR_TYPE))) {
                                    mapValue = Boolean.valueOf(value);
                                }
                                paramMap.put(id, mapValue);
                            }
                        } else if (Template.TAG_GLOBAL.equals(name)) {
                            String id = attributes.getValue(Template.ATTR_ID);
                            if (!paramMap.containsKey(id)) {
                                paramMap.put(id, TypedVariable.parseGlobal(attributes));
                            }
                        } else if (Template.TAG_GLOBALS.equals(name)) {
                            File globalsFile = SaxUtils.getPath(attributes, Template.ATTR_FILE);
                            if (globalsFile != null) {
                                Template.this.processFile(context, globalsFile);
                            }
                        } else if (Template.TAG_EXECUTE.equals(name)) {
                            File recipeFile = SaxUtils.getPath(attributes, Template.ATTR_FILE);
                            if (recipeFile != null) {
                                Template.this.executeRecipeFile(context, recipeFile);
                            }
                        } else if (!(name.equals("template") || name.equals("category") || name.equals("option") || name.equals(Template.TAG_THUMBS) || name.equals(Template.TAG_THUMB) || name.equals(Template.TAG_ICONS) || name.equals(Template.TAG_DEPENDENCY) || name.equals("formfactor"))) {
                            LOG.error("WARNING: Unknown template directive " + name);
                        }
                    }
                    catch (FreemarkerUtils.TemplateProcessingException e) {
                        throw new SAXException(e);
                    }
                }
            });
        }
        catch (SAXException ex) {
            if (ex.getCause() instanceof FreemarkerUtils.TemplateProcessingException) {
                throw (FreemarkerUtils.TemplateProcessingException)ex.getCause();
            }
            throw new FreemarkerUtils.TemplateProcessingException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new FreemarkerUtils.TemplateProcessingException(ex);
        }
        catch (IOException ex) {
            throw new FreemarkerUtils.TemplateProcessingException(ex);
        }
    }

    private void executeRecipeFile(final @NotNull RenderingContext context, @NotNull File fileRecipe) throws FreemarkerUtils.TemplateProcessingException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/Template", "executeRecipeFile"));
        }
        if (fileRecipe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileRecipe", "com/android/tools/idea/templates/Template", "executeRecipeFile"));
        }
        FreemarkerUtils.processFreemarkerTemplate(context, fileRecipe, new FreemarkerUtils.TemplatePostProcessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(@NotNull String xml) throws FreemarkerUtils.TemplateProcessingException {
                block8: {
                    if (xml == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "com/android/tools/idea/templates/Template$5", "process"));
                    }
                    try {
                        xml = XmlUtils.stripBom((String)xml);
                        Recipe recipe = Recipe.parse(new StringReader(xml));
                        RecipeExecutor recipeExecutor = context.getRecipeExecutor();
                        TemplateMetadata metadata = Template.this.getMetadata();
                        assert (metadata != null);
                        if (!metadata.useImplicitRootFolder()) {
                            recipe.execute(recipeExecutor);
                            break block8;
                        }
                        StudioTemplateLoader loader = context.getLoader();
                        try {
                            loader.pushTemplateFolder(new File(Template.this.getRootPath(), "root"));
                            recipe.execute(recipeExecutor);
                        }
                        finally {
                            loader.popTemplateFolder();
                        }
                    }
                    catch (JAXBException ex) {
                        throw new FreemarkerUtils.TemplateProcessingException((Exception)((Object)ex));
                    }
                }
            }
        });
    }

    @NotNull
    private File getTemplateFile(@NotNull File relativeFile) {
        if (relativeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeFile", "com/android/tools/idea/templates/Template", "getTemplateFile"));
        }
        File file = new File(this.myTemplateRoot, relativeFile.getPath());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getTemplateFile"));
        }
        return file;
    }
}

