/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.idea.stats.UsageUploader;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageTrackerAnalyticsImpl
extends UsageTracker {
    private static final ExtensionPointName<UsageUploader> EP_NAME = ExtensionPointName.create((String)"com.android.tools.idea.stats.tracker");
    private static final String GLOGS_CATEGORY_LIBCOUNT = "gradlelibs";
    private static final String GLOGS_CATEGORY_MODUDLE_COUNT = "gradlemodules";
    private static final String GLOGS_CATEGORY_ANDROID_MODUDLE = "gradleAndroidModule";
    private static final String GLOGS_CATEGORY_VERSIONS = "gradleVersions";
    private static final String GLOGS_CATEGORY_LEGACY_IDEA_ANDROID_PROJECT = "legacyIdeaAndroidProject";
    private static final String GLOGS_CATEGORY_INSTANT_RUN = "irstats2";
    private static final String GLOGS_CATEGORY_INSTANT_RUN_TIMINGS = "irtimings";
    private final UsageUploader myUploader;

    public UsageTrackerAnalyticsImpl() {
        UsageUploader[] uploaders = (UsageUploader[])EP_NAME.getExtensions();
        this.myUploader = uploaders.length > 0 ? uploaders[0] : null;
    }

    private boolean trackingEnabled() {
        return this.myUploader != null && this.canTrack();
    }

    @Override
    public void trackEvent(@NotNull String eventCategory, @NotNull String eventAction, @Nullable String eventLabel, @Nullable Integer eventValue) {
        if (eventCategory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventCategory", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "trackEvent"));
        }
        if (eventAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventAction", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "trackEvent"));
        }
        if (!this.trackingEnabled()) {
            return;
        }
        this.myUploader.trackEvent(eventCategory, eventAction, eventLabel, eventValue);
    }

    @Override
    public void trackLibraryCount(@NotNull String applicationId, int jarDependencyCount, int aarDependencyCount) {
        if (applicationId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationId", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "trackLibraryCount"));
        }
        if (!this.trackingEnabled()) {
            return;
        }
        this.myUploader.trackEvent(GLOGS_CATEGORY_LIBCOUNT, (Map<String, String>)ImmutableMap.of((Object)"appId", (Object)UsageTrackerAnalyticsImpl.anonymize(applicationId), (Object)"jars", (Object)Integer.toString(jarDependencyCount), (Object)"aars", (Object)Integer.toString(aarDependencyCount)));
    }

    @Override
    public void trackModuleCount(@NotNull String applicationId, int total, int appModuleCount, int libModuleCount) {
        if (applicationId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationId", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "trackModuleCount"));
        }
        if (!this.trackingEnabled()) {
            return;
        }
        this.myUploader.trackEvent(GLOGS_CATEGORY_MODUDLE_COUNT, (Map<String, String>)ImmutableMap.of((Object)"appId", (Object)UsageTrackerAnalyticsImpl.anonymize(applicationId), (Object)"total", (Object)String.valueOf(total), (Object)"apps", (Object)String.valueOf(appModuleCount), (Object)"libs", (Object)String.valueOf(libModuleCount)));
    }

    @Override
    public void trackAndroidModule(@NotNull String applicationId, @NotNull String moduleName, boolean isLibrary, int signingConfigCount, int buildTypeCount, int flavorCount, int flavorDimension) {
        if (applicationId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationId", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "trackAndroidModule"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "trackAndroidModule"));
        }
        if (!this.trackingEnabled()) {
            return;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"appId", (Object)UsageTrackerAnalyticsImpl.anonymize(applicationId));
        builder.put((Object)"moduleName", (Object)UsageTrackerAnalyticsImpl.anonymize(moduleName));
        builder.put((Object)"isLibrary", (Object)String.valueOf(isLibrary));
        builder.put((Object)"buildTypeCount", (Object)String.valueOf(buildTypeCount));
        builder.put((Object)"flavorCount", (Object)String.valueOf(flavorCount));
        builder.put((Object)"flavorDimension", (Object)String.valueOf(flavorDimension));
        this.myUploader.trackEvent(GLOGS_CATEGORY_ANDROID_MODUDLE, (Map<String, String>)builder.build());
    }

    @Override
    public void trackGradleArtifactVersions(@NotNull String applicationId, @NotNull String androidPluginVersion, @NotNull String gradleVersion, @NotNull Map<String, String> instantRunSettings) {
        if (applicationId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationId", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "trackGradleArtifactVersions"));
        }
        if (androidPluginVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidPluginVersion", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "trackGradleArtifactVersions"));
        }
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "trackGradleArtifactVersions"));
        }
        if (instantRunSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instantRunSettings", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "trackGradleArtifactVersions"));
        }
        if (!this.trackingEnabled()) {
            return;
        }
        ImmutableMap params = ImmutableMap.builder().put((Object)"appId", (Object)UsageTrackerAnalyticsImpl.anonymize(applicationId)).put((Object)"pluginVer", (Object)androidPluginVersion).put((Object)"gradleVer", (Object)gradleVersion).putAll(instantRunSettings).build();
        this.myUploader.trackEvent(GLOGS_CATEGORY_VERSIONS, (Map<String, String>)params);
    }

    @Override
    public void trackLegacyIdeaAndroidProject(@NotNull String applicationId) {
        if (applicationId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationId", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "trackLegacyIdeaAndroidProject"));
        }
        if (!this.trackingEnabled()) {
            return;
        }
        this.myUploader.trackEvent(GLOGS_CATEGORY_LEGACY_IDEA_ANDROID_PROJECT, (Map<String, String>)ImmutableMap.of((Object)"appId", (Object)UsageTrackerAnalyticsImpl.anonymize(applicationId)));
    }

    @Override
    public void trackInstantRunStats(@NotNull Map<String, String> kv) {
        if (kv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kv", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "trackInstantRunStats"));
        }
        if (!this.trackingEnabled()) {
            return;
        }
        this.myUploader.trackEvent(GLOGS_CATEGORY_INSTANT_RUN, kv);
    }

    @Override
    public void trackInstantRunTimings(@NotNull Map<String, String> kv) {
        if (kv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kv", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "trackInstantRunTimings"));
        }
        if (!this.trackingEnabled()) {
            return;
        }
        this.myUploader.trackEvent(GLOGS_CATEGORY_INSTANT_RUN_TIMINGS, kv);
    }

    @NotNull
    private static String anonymize(@NotNull String applicationId) {
        if (applicationId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationId", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "anonymize"));
        }
        String string = Hashing.md5().hashString((CharSequence)applicationId, Charsets.UTF_8).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/stats/UsageTrackerAnalyticsImpl", "anonymize"));
        }
        return string;
    }
}

