/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdkv2;

import com.android.repository.api.ProgressIndicator;
import com.android.tools.idea.sdk.remote.internal.ITaskMonitor;
import org.jetbrains.annotations.NotNull;

public class TaskMonitorProgressIndicatorAdapter
implements ITaskMonitor {
    private final ProgressIndicator myProgressIndicator;
    private int myProgressMax;
    private int myProgress;

    public TaskMonitorProgressIndicatorAdapter(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdkv2/TaskMonitorProgressIndicatorAdapter", "<init>"));
        }
        this.myProgressIndicator = progress;
    }

    @Override
    public void setDescription(@NotNull String format, Object ... args) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/android/tools/idea/sdkv2/TaskMonitorProgressIndicatorAdapter", "setDescription"));
        }
        this.myProgressIndicator.setText(String.format(format, args));
    }

    @Override
    public void log(@NotNull String format, Object ... args) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/android/tools/idea/sdkv2/TaskMonitorProgressIndicatorAdapter", "log"));
        }
        this.myProgressIndicator.logInfo(String.format(format, args));
    }

    @Override
    public void logError(@NotNull String format, Object ... args) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/android/tools/idea/sdkv2/TaskMonitorProgressIndicatorAdapter", "logError"));
        }
        this.myProgressIndicator.logError(String.format(format, args));
    }

    @Override
    public void logVerbose(@NotNull String format, Object ... args) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/android/tools/idea/sdkv2/TaskMonitorProgressIndicatorAdapter", "logVerbose"));
        }
    }

    @Override
    public void setProgressMax(int max) {
        this.myProgressMax = max;
    }

    @Override
    public int getProgressMax() {
        return this.myProgressMax;
    }

    @Override
    public void incProgress(int delta) {
        this.myProgress += delta;
        this.myProgressIndicator.setFraction((double)((float)this.myProgress / (float)this.myProgressMax));
    }

    @Override
    public int getProgress() {
        return this.myProgress;
    }

    @Override
    public ITaskMonitor createSubMonitor(final int tickCount) {
        final TaskMonitorProgressIndicatorAdapter parent = this;
        return new TaskMonitorProgressIndicatorAdapter(this.myProgressIndicator){

            @Override
            public void incProgress(int delta) {
                TaskMonitorProgressIndicatorAdapter.this.myProgress = TaskMonitorProgressIndicatorAdapter.this.myProgress + delta;
                parent.incProgress((int)((float)delta * (float)tickCount / (float)TaskMonitorProgressIndicatorAdapter.this.myProgressMax));
            }
        };
    }

    public void error(Throwable t, String msgFormat, Object ... args) {
        this.myProgressIndicator.logError(msgFormat == null ? "" : String.format(msgFormat, args), t);
    }

    public void warning(String msgFormat, Object ... args) {
        this.myProgressIndicator.logWarning(String.format(msgFormat, args));
    }

    public void info(String msgFormat, Object ... args) {
        this.myProgressIndicator.logInfo(String.format(msgFormat, args));
    }

    public void verbose(String msgFormat, Object ... args) {
    }
}

