/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.tasks.HotSwapTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.tasks.PredicateLaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.collect.Lists;
import com.intellij.execution.runners.ExecutionEnvironment;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HotSwapTasksProvider
implements LaunchTasksProvider {
    private final AndroidRunConfigurationBase myRunConfig;
    private final ExecutionEnvironment myEnv;
    private final AndroidFacet myFacet;
    private final ApkProvider myApkProvider;
    private final LaunchOptions myLaunchOptions;

    public HotSwapTasksProvider(@NotNull AndroidRunConfigurationBase runConfig, @NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet, @NotNull ApkProvider apkProvider, @NotNull LaunchOptions launchOptions) {
        if (runConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfig", "com/android/tools/idea/run/HotSwapTasksProvider", "<init>"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/HotSwapTasksProvider", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/HotSwapTasksProvider", "<init>"));
        }
        if (apkProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkProvider", "com/android/tools/idea/run/HotSwapTasksProvider", "<init>"));
        }
        if (launchOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchOptions", "com/android/tools/idea/run/HotSwapTasksProvider", "<init>"));
        }
        this.myRunConfig = runConfig;
        this.myEnv = env;
        this.myFacet = facet;
        this.myApkProvider = apkProvider;
        this.myLaunchOptions = launchOptions;
    }

    @Override
    @NotNull
    public List<LaunchTask> getTasks(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter consolePrinter) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/HotSwapTasksProvider", "getTasks"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/HotSwapTasksProvider", "getTasks"));
        }
        if (consolePrinter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consolePrinter", "com/android/tools/idea/run/HotSwapTasksProvider", "getTasks"));
        }
        ArrayList tasks = Lists.newArrayListWithCapacity((int)2);
        final HotSwapTask hotSwapTask = new HotSwapTask(this.myEnv, this.myFacet);
        tasks.add(hotSwapTask);
        LaunchTask appLaunchTask = this.myRunConfig.getApplicationLaunchTask(this.myApkProvider, this.myFacet, this.myLaunchOptions.isDebug(), launchStatus);
        if (appLaunchTask != null) {
            tasks.add(new PredicateLaunchTask(appLaunchTask, new PredicateLaunchTask.Predicate(){

                @Override
                public boolean isSuccess() {
                    return hotSwapTask.needsActivityLaunch();
                }
            }));
        }
        ArrayList arrayList = tasks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/HotSwapTasksProvider", "getTasks"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public DebugConnectorTask getConnectDebuggerTask(@NotNull LaunchStatus launchStatus) {
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/HotSwapTasksProvider", "getConnectDebuggerTask"));
        }
        return null;
    }

    @Override
    public boolean createsNewProcess() {
        return false;
    }

    @Override
    public boolean monitorRemoteProcess() {
        return true;
    }
}

