/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidProgramRunner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProcessHandler
extends DefaultDebugProcessHandler
implements AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IClientChangeListener {
    private static final Logger LOG = Logger.getInstance(AndroidProcessHandler.class);
    private static final long TIMEOUT_MS = 10000L;
    @NotNull
    private final String myApplicationId;
    private final boolean myMonitoringRemoteProcess;
    @NotNull
    private final List<String> myDevices;
    @NotNull
    private final Set<Client> myClients;
    private long myDeviceAdded;
    private boolean myNoKill;

    public AndroidProcessHandler(@NotNull String applicationId) {
        if (applicationId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationId", "com/android/tools/idea/run/AndroidProcessHandler", "<init>"));
        }
        this(applicationId, true);
    }

    public AndroidProcessHandler(@NotNull String applicationId, boolean monitorRemoteProcess) {
        if (applicationId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationId", "com/android/tools/idea/run/AndroidProcessHandler", "<init>"));
        }
        this.myApplicationId = applicationId;
        this.myDevices = new SmartList();
        this.myClients = Sets.newHashSet();
        this.myMonitoringRemoteProcess = monitorRemoteProcess;
        if (this.myMonitoringRemoteProcess) {
            AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        }
    }

    public void addTargetDevice(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidProcessHandler", "addTargetDevice"));
        }
        this.myDevices.add(device.getSerialNumber());
        this.setMinDeviceApiLevel(device.getVersion());
        Client client = device.getClient(this.myApplicationId);
        if (client != null) {
            boolean added = this.myClients.add(client);
            if (added) {
                this.notifyTextAvailable("Connected to process " + client.getClientData().getPid() + " on device " + device.getName() + "\n", ProcessOutputTypes.STDOUT);
            }
        } else {
            this.notifyTextAvailable("Client not ready yet..", ProcessOutputTypes.STDOUT);
        }
        LOG.info("Adding device " + device.getName() + " to monitor for launched app: " + this.myApplicationId);
        this.myDeviceAdded = System.currentTimeMillis();
    }

    private void setMinDeviceApiLevel(@NotNull AndroidVersion deviceVersion) {
        if (deviceVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceVersion", "com/android/tools/idea/run/AndroidProcessHandler", "setMinDeviceApiLevel"));
        }
        AndroidVersion apiLevel = (AndroidVersion)this.getUserData(AndroidProgramRunner.ANDROID_DEVICE_API_LEVEL);
        if (apiLevel == null || apiLevel.compareTo(deviceVersion) > 0) {
            this.putUserData(AndroidProgramRunner.ANDROID_DEVICE_API_LEVEL, deviceVersion);
        }
    }

    public boolean detachIsDefault() {
        return false;
    }

    public boolean isSilentlyDestroyOnClose() {
        return true;
    }

    protected void detachProcessImpl() {
        super.detachProcessImpl();
        this.cleanup();
    }

    protected void destroyProcessImpl() {
        super.destroyProcessImpl();
        this.killProcesses();
        this.cleanup();
    }

    private void killProcesses() {
        if (this.myNoKill) {
            return;
        }
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge == null) {
            return;
        }
        for (IDevice device : bridge.getDevices()) {
            if (!this.myDevices.contains(device.getSerialNumber())) continue;
            try {
                device.executeShellCommand("am force-stop " + this.myApplicationId, (IShellOutputReceiver)new NullOutputReceiver());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Client client = device.getClient(this.myApplicationId);
            if (client == null) continue;
            client.kill();
        }
    }

    public void setNoKill() {
        this.myNoKill = true;
    }

    private void cleanup() {
        this.myDevices.clear();
        this.myClients.clear();
        if (this.myMonitoringRemoteProcess) {
            AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        }
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidProcessHandler", "deviceConnected"));
        }
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidProcessHandler", "deviceDisconnected"));
        }
        if (!this.myDevices.contains(device.getSerialNumber())) {
            return;
        }
        this.print("Device " + device.getName() + "disconnected, monitoring stopped.");
        this.stopMonitoring(device);
    }

    private void stopMonitoring(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidProcessHandler", "stopMonitoring"));
        }
        this.myDevices.remove(device.getSerialNumber());
        if (this.myDevices.isEmpty()) {
            this.detachProcess();
        }
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidProcessHandler", "deviceChanged"));
        }
        if ((changeMask & 2) != 2) {
            return;
        }
        if (!this.myDevices.contains(device.getSerialNumber())) {
            return;
        }
        Client client = device.getClient(this.myApplicationId);
        if (client != null) {
            this.print("Connected to process " + client.getClientData().getPid() + " on device " + device.getName());
            this.myClients.add(client);
            return;
        }
        if (!this.myClients.isEmpty()) {
            for (Client c : this.myClients) {
                if (!device.equals(c.getDevice())) continue;
                this.stopMonitoring(device);
                this.print("Application terminated.");
                return;
            }
        }
        if (System.currentTimeMillis() - this.myDeviceAdded > 10000L) {
            this.print("Timed out waiting for process to appear on " + device.getName());
            this.stopMonitoring(device);
        } else {
            this.print("Waiting for process to come online");
        }
    }

    public void clientChanged(@NotNull Client client, int changeMask) {
        String name;
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/idea/run/AndroidProcessHandler", "clientChanged"));
        }
        if ((changeMask & 1) != 1) {
            return;
        }
        if (!this.myDevices.contains(client.getDevice().getSerialNumber())) {
            return;
        }
        if (StringUtil.equals((CharSequence)this.myApplicationId, (CharSequence)client.getClientData().getClientDescription())) {
            this.print("Connected to process " + client.getClientData().getPid() + " on device " + client.getDevice().getName());
            this.myClients.add(client);
        }
        if ((name = client.getClientData().getClientDescription()) != null && this.myApplicationId.equals(name) && !client.isValid()) {
            this.print("Process " + client.getClientData().getPid() + " is not valid anymore!");
            this.stopMonitoring(client.getDevice());
        }
    }

    @NotNull
    public List<IDevice> getDevices() {
        HashSet devices = Sets.newHashSet();
        for (Client client : this.myClients) {
            devices.add(client.getDevice());
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)devices);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidProcessHandler", "getDevices"));
        }
        return arrayList;
    }

    @Nullable
    public Client getClient(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidProcessHandler", "getClient"));
        }
        String serial = device.getSerialNumber();
        for (Client client : this.myClients) {
            if (!StringUtil.equals((CharSequence)client.getDevice().getSerialNumber(), (CharSequence)serial)) continue;
            return client;
        }
        return null;
    }

    @NotNull
    public Set<Client> getClients() {
        Set<Client> set = this.myClients;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidProcessHandler", "getClients"));
        }
        return set;
    }

    private void print(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/run/AndroidProcessHandler", "print"));
        }
        this.notifyTextAvailable(s + "\n", ProcessOutputTypes.STDOUT);
    }

    public void reset() {
        this.myDevices.clear();
        this.myClients.clear();
    }
}

