/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.ToggleOfflineModeHyperlink;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class MissingDependencyErrorHandler
extends AbstractSyncErrorHandler {
    private static final Pattern MISSING_MATCHING_DEPENDENCY_PATTERN = Pattern.compile("Could not find any version that matches (.*)\\.");
    private static final Pattern MISSING_DEPENDENCY_PATTERN = Pattern.compile("Could not find (.*)\\.");

    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/service/notification/errors/MissingDependencyErrorHandler", "handleError"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/service/notification/errors/MissingDependencyErrorHandler", "handleError"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/MissingDependencyErrorHandler", "handleError"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/MissingDependencyErrorHandler", "handleError"));
        }
        String firstLine = message.get(0);
        Matcher matcher = MISSING_MATCHING_DEPENDENCY_PATTERN.matcher(firstLine);
        if (matcher.matches()) {
            String dependency = matcher.group(1);
            MissingDependencyErrorHandler.handleMissingDependency(notification, project, firstLine, dependency, new NotificationHyperlink[0]);
            return true;
        }
        String lastLine = message.get(message.size() - 1);
        matcher = MISSING_DEPENDENCY_PATTERN.matcher(firstLine);
        if (matcher.matches() && message.size() > 1 && message.get(1).startsWith("Required by:")) {
            String dependency = matcher.group(1);
            NotificationHyperlink[] hyperlinks = EMPTY;
            if (StringUtil.isNotEmpty((String)dependency)) {
                Pair<String, Integer> errorLocation;
                if (lastLine != null && (errorLocation = MissingDependencyErrorHandler.getErrorLocation(lastLine)) != null) {
                    String filePath = (String)errorLocation.getFirst();
                    int line = (Integer)errorLocation.getSecond();
                    hyperlinks = new NotificationHyperlink[]{new OpenFileHyperlink(filePath, line - 1)};
                }
                MissingDependencyErrorHandler.handleMissingDependency(notification, project, error.getMessage(), dependency, hyperlinks);
                return true;
            }
        }
        for (String line : message) {
            if (line == null || !(matcher = MISSING_MATCHING_DEPENDENCY_PATTERN.matcher(line)).matches()) continue;
            String dependency = matcher.group(1);
            MissingDependencyErrorHandler.handleMissingDependency(notification, project, line, dependency, new NotificationHyperlink[0]);
            return true;
        }
        return false;
    }

    private static void handleMissingDependency(@NotNull NotificationData notification, @NotNull Project project, @NotNull String msg, @NotNull String dependency, NotificationHyperlink ... additionalHyperlinks) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/MissingDependencyErrorHandler", "handleMissingDependency"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/MissingDependencyErrorHandler", "handleMissingDependency"));
        }
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/android/tools/idea/gradle/service/notification/errors/MissingDependencyErrorHandler", "handleMissingDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/service/notification/errors/MissingDependencyErrorHandler", "handleMissingDependency"));
        }
        if (additionalHyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalHyperlinks", "com/android/tools/idea/gradle/service/notification/errors/MissingDependencyErrorHandler", "handleMissingDependency"));
        }
        ArrayList hyperlinks = Lists.newArrayList((Object[])additionalHyperlinks);
        ToggleOfflineModeHyperlink disableOfflineMode = ToggleOfflineModeHyperlink.disableOfflineMode(project);
        if (disableOfflineMode != null) {
            hyperlinks.add(0, disableOfflineMode);
        }
        hyperlinks.add(new SearchInBuildFilesHyperlink(dependency));
        MissingDependencyErrorHandler.updateNotification(notification, project, msg, hyperlinks);
    }
}

