/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.qualifiers;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceEnum;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.android.tools.idea.editors.theme.qualifiers.QualifierUtils;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedEnum;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedLocale;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedQualifier;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedValue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestrictedConfiguration {
    private final RestrictedQualifier[] myRestrictedQualifiers = new RestrictedQualifier[FolderConfiguration.getQualifierCount()];
    private final Class<? extends ResourceQualifier>[] myQualifiersClasses = new Class[FolderConfiguration.getQualifierCount()];

    public RestrictedConfiguration() {
        FolderConfiguration configuration = new FolderConfiguration();
        configuration.createDefault();
        for (int i = 0; i < FolderConfiguration.getQualifierCount(); ++i) {
            ResourceQualifier qualifier = configuration.getQualifier(i);
            assert (qualifier != null);
            this.myQualifiersClasses[i] = qualifier.getClass();
            if (this.myQualifiersClasses[i].equals(LocaleQualifier.class)) {
                this.myRestrictedQualifiers[i] = new RestrictedLocale();
                continue;
            }
            if (this.myQualifiersClasses[i].equals(VersionQualifier.class)) {
                this.myRestrictedQualifiers[i] = new RestrictedValue();
                continue;
            }
            Class getValueType = QualifierUtils.getValueReturnType(this.myQualifiersClasses[i]);
            if (getValueType == null) continue;
            if (getValueType.equals(Integer.TYPE)) {
                this.myRestrictedQualifiers[i] = new RestrictedValue();
                continue;
            }
            assert (Arrays.asList(getValueType.getInterfaces()).contains(ResourceEnum.class));
            this.myRestrictedQualifiers[i] = new RestrictedEnum(getValueType);
        }
    }

    @Nullable(value="if empty intersection, i.e some of the qualifiers can't have any value due to the restrictions in both")
    public RestrictedConfiguration intersect(@NotNull RestrictedConfiguration otherRestricted) {
        if (otherRestricted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherRestricted", "com/android/tools/idea/editors/theme/qualifiers/RestrictedConfiguration", "intersect"));
        }
        RestrictedConfiguration resultRestricted = new RestrictedConfiguration();
        for (int i = 0; i < FolderConfiguration.getQualifierCount(); ++i) {
            RestrictedQualifier thisQualifier = this.myRestrictedQualifiers[i];
            RestrictedQualifier otherQualifier = otherRestricted.myRestrictedQualifiers[i];
            if (thisQualifier == null) {
                assert (otherQualifier == null);
                continue;
            }
            RestrictedQualifier intersection = thisQualifier.intersect(otherQualifier);
            if (intersection == null) {
                return null;
            }
            resultRestricted.myRestrictedQualifiers[i] = intersection;
        }
        return resultRestricted;
    }

    @NotNull
    public FolderConfiguration getAny() {
        FolderConfiguration configuration = new FolderConfiguration();
        for (int i = 0; i < FolderConfiguration.getQualifierCount(); ++i) {
            Object value;
            if (this.myRestrictedQualifiers[i] == null || (value = this.myRestrictedQualifiers[i].getAny()) == null) continue;
            configuration.addQualifier(QualifierUtils.createNewResourceQualifier(this.myQualifiersClasses[i], value));
        }
        FolderConfiguration folderConfiguration = configuration;
        if (folderConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/qualifiers/RestrictedConfiguration", "getAny"));
        }
        return folderConfiguration;
    }

    @Nullable(value="if there is no configuration that matches the constraints")
    public static RestrictedConfiguration restrict(@NotNull FolderConfiguration compatible, @NotNull Collection<FolderConfiguration> incompatibles) {
        if (compatible == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compatible", "com/android/tools/idea/editors/theme/qualifiers/RestrictedConfiguration", "restrict"));
        }
        if (incompatibles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incompatibles", "com/android/tools/idea/editors/theme/qualifiers/RestrictedConfiguration", "restrict"));
        }
        RestrictedConfiguration restricted = new RestrictedConfiguration();
        if (incompatibles.isEmpty()) {
            return restricted;
        }
        ArrayList matchingIncompatibles = Lists.newArrayList(incompatibles);
        for (int qualifierIndex = 0; qualifierIndex < FolderConfiguration.getQualifierCount(); ++qualifierIndex) {
            ResourceQualifier compatibleQualifier = compatible.getQualifier(qualifierIndex);
            RestrictedQualifier restrictedQualifier = restricted.myRestrictedQualifiers[qualifierIndex];
            ArrayList incompatibleQualifiers = Lists.newArrayList();
            for (FolderConfiguration matching : matchingIncompatibles) {
                ResourceQualifier qualifier = matching.getQualifier(qualifierIndex);
                if (qualifier == null) continue;
                incompatibleQualifiers.add(qualifier);
            }
            if (compatibleQualifier == null && incompatibleQualifiers.isEmpty()) continue;
            assert (restrictedQualifier != null);
            restrictedQualifier.setRestrictions(compatibleQualifier, incompatibleQualifiers);
            if (restrictedQualifier.isEmpty()) {
                return null;
            }
            Iterator matchingIterator = matchingIncompatibles.iterator();
            while (matchingIterator.hasNext()) {
                ResourceQualifier incompatibleQualifier = ((FolderConfiguration)matchingIterator.next()).getQualifier(qualifierIndex);
                if (compatibleQualifier != null && !restrictedQualifier.isMatchFor(incompatibleQualifier)) {
                    matchingIterator.remove();
                    continue;
                }
                if (compatibleQualifier != null || incompatibleQualifier == null) continue;
                matchingIterator.remove();
            }
            if (!matchingIncompatibles.isEmpty()) continue;
            return restricted;
        }
        return null;
    }

    @Nullable(value="if there is no configuration that matches the constraints")
    public static <T> FolderConfiguration restrict(@NotNull ConfiguredElement<T> compatible, Collection<ConfiguredElement<T>> allItems) {
        if (compatible == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compatible", "com/android/tools/idea/editors/theme/qualifiers/RestrictedConfiguration", "restrict"));
        }
        ArrayList incompatibleConfigurations = Lists.newArrayListWithCapacity((int)allItems.size());
        boolean found = false;
        for (ConfiguredElement<T> configuredItem : allItems) {
            FolderConfiguration configuration = configuredItem.getConfiguration();
            if (configuredItem.equals(compatible)) {
                found = true;
                continue;
            }
            incompatibleConfigurations.add(configuration);
        }
        assert (found);
        RestrictedConfiguration restricted = RestrictedConfiguration.restrict(compatible.getConfiguration(), incompatibleConfigurations);
        return restricted != null ? restricted.getAny() : null;
    }
}

