/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.macros;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import java.util.ArrayList;
import java.util.List;

public class CodeTemplate {
    private final List<String> myParameters;
    private final PsiElement myBody;

    public CodeTemplate(List<String> parameters, PsiElement body) {
        this.myParameters = parameters;
        this.myBody = body;
    }

    public List<String> getParameters() {
        return this.myParameters;
    }

    public PsiElement getBody() {
        return this.myBody;
    }

    public static CodeTemplate fromMethod(PsiMethod method) {
        ArrayList<String> parameters = new ArrayList<String>();
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            parameters.add(parameter.getName());
        }
        PsiCodeBlock methodBody = method.getBody();
        assert (methodBody != null);
        PsiStatement[] statements = methodBody.getStatements();
        assert (statements.length == 1);
        PsiElement templateBody = statements[0].getFirstChild();
        return new CodeTemplate(parameters, templateBody);
    }
}

