/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.controllers.AtomController;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.controllers.FrameBufferController;
import com.android.tools.idea.editors.gfxtrace.controllers.MemoryController;
import com.android.tools.idea.editors.gfxtrace.controllers.ScrubberController;
import com.android.tools.idea.editors.gfxtrace.controllers.StateController;
import com.android.tools.idea.editors.gfxtrace.controllers.TexturesController;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class MainController
extends Controller {
    @NotNull
    private JBPanel myPanel;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new MainController((GfxTraceEditor)editor).myPanel;
    }

    private MainController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/MainController", "<init>"));
        }
        super(editor);
        this.myPanel = new JBPanel((LayoutManager)new BorderLayout());
        this.myPanel.add((Component)new JBLabel(){
            {
                this.setText("The GPU debugger is experimental software.");
                this.setIcon(AllIcons.General.BalloonWarning);
                this.setBackground((Color)new JBColor(0xFFEE88, 10785106));
                this.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
                this.setOpaque(true);
            }
        }, (Object)"North");
        ThreeComponentsSplitter threePanes = new ThreeComponentsSplitter(true);
        this.myPanel.add((Component)threePanes, (Object)"Center");
        threePanes.setDividerWidth(5);
        threePanes.setFirstComponent(ScrubberController.createUI(editor));
        threePanes.setFirstSize(150);
        JBRunnerTabs imageTabs = new JBRunnerTabs(editor.getProject(), ActionManager.getInstance(), IdeFocusManager.findInstance(), (Disposable)this);
        imageTabs.setPaintBorder(0, 0, 0, 0).setTabSidePaintBorder(1).setPaintFocus(UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()).setAlwaysPaintSelectedTab(UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF());
        imageTabs.setBorder((Border)JBUI.Borders.empty((int)0, (int)2, (int)0, (int)0));
        imageTabs.addTab(new TabInfo(FrameBufferController.createUI(editor)).setText("Framebuffer"));
        imageTabs.addTab(new TabInfo(TexturesController.createUI(editor)).setText("Textures"));
        JBSplitter middleSplitter = new JBSplitter(false);
        middleSplitter.setMinimumSize((Dimension)JBUI.size((int)100, (int)10));
        middleSplitter.setFirstComponent(AtomController.createUI(editor));
        middleSplitter.setSecondComponent((JComponent)imageTabs);
        middleSplitter.setProportion(0.3f);
        threePanes.setInnerComponent((JComponent)middleSplitter);
        JBSplitter bottomSplitter = new JBSplitter(false);
        bottomSplitter.setMinimumSize((Dimension)JBUI.size((int)100, (int)10));
        bottomSplitter.setFirstComponent(StateController.createUI(editor));
        bottomSplitter.setSecondComponent(MemoryController.createUI(editor));
        threePanes.setLastComponent((JComponent)bottomSplitter);
        threePanes.setLastSize(300);
        threePanes.setHonorComponentsMinimumSize(true);
        Disposer.register((Disposable)this, (Disposable)threePanes);
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
    }

    @Override
    public void clear() {
        this.myPanel.removeAll();
    }
}

