/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.ide.common.res2.DataBindingResourceType;
import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceType;
import com.android.tools.idea.databinding.BrUtil;
import com.android.tools.idea.databinding.ResourceCacheValueProvider;
import com.android.tools.idea.lang.databinding.DbFile;
import com.android.tools.idea.lang.databinding.psi.DbTokenTypes;
import com.android.tools.idea.lang.databinding.psi.PsiDbConstantValue;
import com.android.tools.idea.lang.databinding.psi.PsiDbDefaults;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.rendering.DataBindingInfo;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.PsiDataBindingResourceItem;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.light.LightField;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingUtil {
    public static final String BR = "BR";
    private static List<String> VIEW_PACKAGE_ELEMENTS = Arrays.asList("View", "ViewGroup", "ViewStub", "TextureView", "SurfaceView");
    private static AtomicLong ourDataBindingEnabledModificationCount = new AtomicLong(0L);
    public static ModificationTracker DATA_BINDING_ENABLED_TRACKER = new ModificationTracker(){

        public long getModificationCount() {
            return ourDataBindingEnabledModificationCount.longValue();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LightBrClass getOrCreateBrClassFor(AndroidFacet facet) {
        LightBrClass existing = facet.getLightBrClass();
        if (existing == null) {
            AndroidFacet androidFacet = facet;
            synchronized (androidFacet) {
                existing = facet.getLightBrClass();
                if (existing == null) {
                    existing = new LightBrClass(PsiManager.getInstance((Project)facet.getModule().getProject()), facet);
                    facet.setLightBrClass(existing);
                }
            }
        }
        return existing;
    }

    private static PsiType parsePsiType(String text, AndroidFacet facet, PsiElement context) {
        PsiElementFactory instance = PsiElementFactory.SERVICE.getInstance((Project)facet.getModule().getProject());
        try {
            PsiType type = instance.createTypeFromText(text, context);
            if (type instanceof PsiClassReferenceType && ((PsiClassReferenceType)type).getClassName() == null) {
                return null;
            }
            return type;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public static PsiType resolveViewPsiType(DataBindingInfo.ViewWithId viewWithId, AndroidFacet facet) {
        String viewClassName = DataBindingUtil.getViewClassName(viewWithId.tag, facet);
        if (StringUtil.isNotEmpty((String)viewClassName)) {
            return DataBindingUtil.parsePsiType(viewClassName, facet, null);
        }
        return null;
    }

    @Nullable
    private static String getViewClassName(XmlTag tag, AndroidFacet facet) {
        String elementName = DataBindingUtil.getViewName(tag);
        if (elementName.indexOf(46) == -1) {
            if (VIEW_PACKAGE_ELEMENTS.contains(elementName)) {
                return "android.view." + elementName;
            }
            if ("WebView".equals(elementName)) {
                return "android.webkit." + elementName;
            }
            if ("merge".equals(elementName)) {
                return DataBindingUtil.getViewClassNameFromMerge(tag, facet);
            }
            if ("include".equals(elementName)) {
                return DataBindingUtil.getViewClassNameFromInclude(tag, facet);
            }
            return "android.widget." + elementName;
        }
        return elementName;
    }

    private static String getViewClassNameFromInclude(XmlTag tag, AndroidFacet facet) {
        String reference = DataBindingUtil.getViewClassNameFromLayoutReferenceTag(tag, facet);
        return reference == null ? "android.view.View" : reference;
    }

    private static String getViewClassNameFromMerge(XmlTag tag, AndroidFacet facet) {
        return DataBindingUtil.getViewClassNameFromLayoutReferenceTag(tag, facet);
    }

    private static String getViewClassNameFromLayoutReferenceTag(XmlTag tag, AndroidFacet facet) {
        String layout = tag.getAttributeValue("layout");
        if (layout == null) {
            return null;
        }
        LocalResourceRepository moduleResources = facet.getModuleResources(false);
        if (moduleResources == null) {
            return null;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)layout);
        if (resourceUrl == null || resourceUrl.type != ResourceType.LAYOUT) {
            return null;
        }
        DataBindingInfo info = moduleResources.getDataBindingInfoForLayout(resourceUrl.name);
        if (info == null) {
            return null;
        }
        return info.getQualifiedName();
    }

    private static String getViewName(XmlTag tag) {
        String viewName = tag.getName();
        if ("view".equals(viewName)) {
            viewName = tag.getAttributeValue("class", "http://schemas.android.com/apk/res/android");
        }
        return viewName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PsiClass getOrCreatePsiClass(DataBindingInfo info) {
        PsiClass psiClass = info.getPsiClass();
        if (psiClass == null) {
            DataBindingInfo dataBindingInfo = info;
            synchronized (dataBindingInfo) {
                psiClass = info.getPsiClass();
                if (psiClass == null) {
                    psiClass = new LightBindingClass(info.getFacet(), PsiManager.getInstance((Project)info.getProject()), info);
                    info.setPsiClass(psiClass);
                }
            }
        }
        return psiClass;
    }

    public static String convertToJavaClassName(String name) {
        int dotIndex = name.indexOf(46);
        if (dotIndex >= 0) {
            name = name.substring(0, dotIndex);
        }
        String[] split = name.split("[_-]");
        StringBuilder out = new StringBuilder();
        for (String section : split) {
            out.append(StringUtil.capitalize((String)section));
        }
        return out.toString();
    }

    public static String convertToJavaFieldName(String name) {
        int dotIndex = name.indexOf(46);
        if (dotIndex >= 0) {
            name = name.substring(0, dotIndex);
        }
        String[] split = name.split("[_-]");
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (String section : split) {
            if (first) {
                first = false;
                out.append(section);
                continue;
            }
            out.append(StringUtil.capitalize((String)section));
        }
        return out.toString();
    }

    public static String getBrQualifiedName(AndroidFacet facet) {
        return DataBindingUtil.getGeneratedPackageName(facet) + "." + BR;
    }

    public static String getGeneratedPackageName(AndroidFacet facet) {
        return ManifestInfo.get(facet.getModule(), false).getPackage();
    }

    public static void onIdeaProjectSet(AndroidFacet facet) {
        AndroidModel androidModel = facet.getAndroidModel();
        if (androidModel != null) {
            boolean wasEnabled = facet.isDataBindingEnabled();
            boolean enabled = androidModel.getDataBindingEnabled();
            if (enabled != wasEnabled) {
                facet.setDataBindingEnabled(enabled);
                ourDataBindingEnabledModificationCount.incrementAndGet();
            }
        }
    }

    @Nullable
    public static String getBindingExprDefault(@NotNull XmlAttribute psiAttribute) {
        if (psiAttribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAttribute", "com/android/tools/idea/databinding/DataBindingUtil", "getBindingExprDefault"));
        }
        XmlAttributeValue attrValue = psiAttribute.getValueElement();
        if (attrValue instanceof PsiLanguageInjectionHost) {
            PsiDbDefaults defaults;
            final Ref injections = Ref.create();
            InjectedLanguageUtil.enumerate((PsiElement)attrValue, (PsiLanguageInjectionHost.InjectedPsiVisitor)new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                    if (injectedPsi == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/android/tools/idea/databinding/DataBindingUtil$1", "visit"));
                    }
                    if (places == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/android/tools/idea/databinding/DataBindingUtil$1", "visit"));
                    }
                    if (injectedPsi instanceof DbFile) {
                        injections.set((Object)injectedPsi);
                    }
                }
            });
            if (injections.get() != null && (defaults = (PsiDbDefaults)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)injections.get()), PsiDbDefaults.class)) != null) {
                PsiDbConstantValue constantValue = defaults.getConstantValue();
                if (constantValue.getNode().getElementType() == DbTokenTypes.STRING_LITERAL) {
                    String text = constantValue.getText();
                    return text.substring(1, text.length() - 1);
                }
                return constantValue.getText();
            }
        }
        return null;
    }

    @Nullable
    public static String getBindingExprDefault(@NotNull String exprn) {
        if (exprn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exprn", "com/android/tools/idea/databinding/DataBindingUtil", "getBindingExprDefault"));
        }
        if (!exprn.contains(DbTokenTypes.DEFAULT_KEYWORD.toString())) {
            return null;
        }
        Pattern defaultCheck = Pattern.compile(",\\s*default\\s*=\\s*");
        int index = 0;
        Matcher matcher = defaultCheck.matcher(exprn);
        while (matcher.find()) {
            index = matcher.end();
        }
        String def = exprn.substring(index, exprn.length() - 1).trim();
        if (def.startsWith("\"") && def.endsWith("\"")) {
            def = def.substring(1, def.length() - 1);
        }
        return def;
    }

    public static boolean isBindingExpression(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/android/tools/idea/databinding/DataBindingUtil", "isBindingExpression"));
        }
        return string.startsWith("@{") || string.startsWith("@={");
    }

    static class LightBRField
    extends LightField {
        public LightBRField(@NotNull PsiManager manager, @NotNull PsiField field, @NotNull PsiClass containingClass) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/databinding/DataBindingUtil$LightBRField", "<init>"));
            }
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/databinding/DataBindingUtil$LightBRField", "<init>"));
            }
            if (containingClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/android/tools/idea/databinding/DataBindingUtil$LightBRField", "<init>"));
            }
            super(manager, field, containingClass);
        }
    }

    public static class LightBrClass
    extends AndroidLightClassBase {
        private static final String BINDABLE_QUALIFIED_NAME = "android.databinding.Bindable";
        private final AndroidFacet myFacet;
        private CachedValue<PsiField[]> myFieldCache;
        @NotNull
        private String[] myCachedFieldNames;
        private final String myQualifiedName;
        private PsiFile myContainingFile;

        public LightBrClass(@NotNull PsiManager psiManager, final AndroidFacet facet) {
            if (psiManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/android/tools/idea/databinding/DataBindingUtil$LightBrClass", "<init>"));
            }
            super(psiManager);
            this.myCachedFieldNames = new String[]{"_all"};
            this.myQualifiedName = DataBindingUtil.getBrQualifiedName(facet);
            this.myFacet = facet;
            this.myFieldCache = CachedValuesManager.getManager((Project)facet.getModule().getProject()).createCachedValue((CachedValueProvider)new ResourceCacheValueProvider<PsiField[]>(facet, new ModificationTracker[]{psiManager.getModificationTracker().getJavaStructureModificationTracker()}){

                @Override
                PsiField[] doCompute() {
                    Project project = facet.getModule().getProject();
                    PsiElementFactory elementFactory = PsiElementFactory.SERVICE.getInstance((Project)project);
                    LocalResourceRepository moduleResources = facet.getModuleResources(false);
                    if (moduleResources == null) {
                        return this.defaultValue();
                    }
                    Map<String, DataBindingInfo> dataBindingResourceFiles = moduleResources.getDataBindingResourceFiles();
                    if (dataBindingResourceFiles == null) {
                        return this.defaultValue();
                    }
                    HashSet variableNames = new HashSet();
                    for (DataBindingInfo info : dataBindingResourceFiles.values()) {
                        for (PsiDataBindingResourceItem item : info.getItems(DataBindingResourceType.VARIABLE)) {
                            variableNames.add(item.getName());
                        }
                    }
                    Set bindables = LightBrClass.this.collectVariableNamesFromBindables();
                    if (bindables != null) {
                        variableNames.addAll(bindables);
                    }
                    PsiField[] result = new PsiField[variableNames.size() + 1];
                    result[0] = LightBrClass.this.createPsiField(project, elementFactory, "_all");
                    int i = 1;
                    for (String variable : variableNames) {
                        result[i++] = LightBrClass.this.createPsiField(project, elementFactory, variable);
                    }
                    LightBrClass.access$702(LightBrClass.this, ArrayUtil.toStringArray((Collection)variableNames));
                    return result;
                }

                @Override
                PsiField[] defaultValue() {
                    Project project = facet.getModule().getProject();
                    return new PsiField[]{LightBrClass.this.createPsiField(project, PsiElementFactory.SERVICE.getInstance((Project)project), "_all")};
                }
            });
        }

        private Set<String> collectVariableNamesFromBindables() {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myFacet.getModule().getProject());
            PsiClass aClass = facade.findClass(BINDABLE_QUALIFIED_NAME, this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(false));
            if (aClass == null) {
                return null;
            }
            Collection psiElements = AnnotatedElementsSearch.searchElements((PsiClass)aClass, (SearchScope)this.myFacet.getModule().getModuleScope(), (Class[])new Class[]{PsiMethod.class, PsiField.class}).findAll();
            return BrUtil.collectIds(psiElements);
        }

        private PsiField createPsiField(Project project, PsiElementFactory factory, String id) {
            PsiField field = factory.createField(id, (PsiType)PsiType.INT);
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"public", (boolean)true);
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"static", (boolean)true);
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
            return new LightBRField(PsiManager.getInstance((Project)project), field, this);
        }

        public String toString() {
            return "BR class for " + (Object)((Object)this.myFacet);
        }

        @Nullable
        public String getQualifiedName() {
            return this.myQualifiedName;
        }

        public String getName() {
            return DataBindingUtil.BR;
        }

        @NotNull
        public String[] getAllFieldNames() {
            if (this.myCachedFieldNames == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingUtil$LightBrClass", "getAllFieldNames"));
            }
            return this.myCachedFieldNames;
        }

        @Nullable
        public PsiClass getContainingClass() {
            return null;
        }

        @Override
        @NotNull
        public PsiField[] getFields() {
            PsiField[] psiFieldArray = (PsiField[])this.myFieldCache.getValue();
            if (psiFieldArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingUtil$LightBrClass", "getFields"));
            }
            return psiFieldArray;
        }

        @Override
        @NotNull
        public PsiField[] getAllFields() {
            PsiField[] psiFieldArray = this.getFields();
            if (psiFieldArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingUtil$LightBrClass", "getAllFields"));
            }
            return psiFieldArray;
        }

        @Override
        @Nullable
        public PsiFile getContainingFile() {
            PsiClass aClass;
            if (this.myContainingFile == null && (aClass = JavaPsiFacade.getInstance((Project)this.myFacet.getModule().getProject()).findClass(DataBindingUtil.getGeneratedPackageName(this.myFacet) + ".R", this.myFacet.getModule().getModuleScope())) != null) {
                this.myContainingFile = aClass.getContainingFile();
            }
            return this.myContainingFile;
        }

        @Override
        public PsiIdentifier getNameIdentifier() {
            return new LightIdentifier(this.getManager(), this.getName());
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiFile containingFile = this.getContainingFile();
            Object object = containingFile == null ? super.getNavigationElement() : containingFile;
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingUtil$LightBrClass", "getNavigationElement"));
            }
            return object;
        }

        static /* synthetic */ String[] access$702(LightBrClass x0, String[] x1) {
            x0.myCachedFieldNames = x1;
            return x1;
        }
    }

    static class LightDataBindingField
    extends LightField {
        private final DataBindingInfo.ViewWithId myViewWithId;

        public LightDataBindingField(DataBindingInfo.ViewWithId viewWithId, @NotNull PsiManager manager, @NotNull PsiField field, @NotNull PsiClass containingClass) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/databinding/DataBindingUtil$LightDataBindingField", "<init>"));
            }
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/databinding/DataBindingUtil$LightDataBindingField", "<init>"));
            }
            if (containingClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/android/tools/idea/databinding/DataBindingUtil$LightDataBindingField", "<init>"));
            }
            super(manager, field, containingClass);
            this.myViewWithId = viewWithId;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            XmlTag xmlTag = this.myViewWithId.tag;
            if (xmlTag == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingUtil$LightDataBindingField", "getNavigationElement"));
            }
            return xmlTag;
        }
    }

    static class LightDataBindingMethod
    extends LightMethod {
        private PsiElement myNavigationElement;

        public LightDataBindingMethod(@NotNull PsiElement navigationElement, @NotNull PsiManager manager, @NotNull PsiMethod method, @NotNull PsiClass containingClass, @NotNull Language language) {
            if (navigationElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationElement", "com/android/tools/idea/databinding/DataBindingUtil$LightDataBindingMethod", "<init>"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/databinding/DataBindingUtil$LightDataBindingMethod", "<init>"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/android/tools/idea/databinding/DataBindingUtil$LightDataBindingMethod", "<init>"));
            }
            if (containingClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/android/tools/idea/databinding/DataBindingUtil$LightDataBindingMethod", "<init>"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/android/tools/idea/databinding/DataBindingUtil$LightDataBindingMethod", "<init>"));
            }
            super(manager, method, containingClass, language);
            this.myNavigationElement = navigationElement;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myNavigationElement;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingUtil$LightDataBindingMethod", "getNavigationElement"));
            }
            return psiElement;
        }

        public PsiIdentifier getNameIdentifier() {
            return new LightIdentifier(this.getManager(), this.getName());
        }
    }

    static class LightBindingClass
    extends AndroidLightClassBase {
        static final int STATIC_METHOD_COUNT = 6;
        private DataBindingInfo myInfo;
        private CachedValue<PsiMethod[]> myPsiMethodsCache;
        private CachedValue<PsiField[]> myPsiFieldsCache;
        private CachedValue<Map<String, String>> myAliasCache;
        private PsiReferenceList myExtendsList;
        private PsiClassType[] myExtendsListTypes;
        private final AndroidFacet myFacet;
        private static Lexer ourJavaLexer;

        protected LightBindingClass(AndroidFacet facet, @NotNull PsiManager psiManager, DataBindingInfo info) {
            if (psiManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/android/tools/idea/databinding/DataBindingUtil$LightBindingClass", "<init>"));
            }
            super(psiManager);
            this.myInfo = info;
            this.myFacet = facet;
            CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)info.getProject());
            this.myAliasCache = cachedValuesManager.createCachedValue((CachedValueProvider)new ResourceCacheValueProvider<Map<String, String>>(facet, new ModificationTracker[0]){

                @Override
                Map<String, String> doCompute() {
                    HashMap<String, String> result = new HashMap<String, String>();
                    for (PsiDataBindingResourceItem imp : LightBindingClass.this.myInfo.getItems(DataBindingResourceType.IMPORT)) {
                        String alias = imp.getExtra("alias");
                        if (alias == null) continue;
                        result.put(alias, imp.getExtra("type"));
                    }
                    return result;
                }

                @Override
                Map<String, String> defaultValue() {
                    return Maps.newHashMap();
                }
            }, false);
            this.myPsiMethodsCache = cachedValuesManager.createCachedValue((CachedValueProvider)new ResourceCacheValueProvider<PsiMethod[]>(facet, new ModificationTracker[0]){

                @Override
                PsiMethod[] doCompute() {
                    List<PsiDataBindingResourceItem> variables = LightBindingClass.this.myInfo.getItems(DataBindingResourceType.VARIABLE);
                    if (variables.isEmpty()) {
                        return PsiMethod.EMPTY_ARRAY;
                    }
                    ArrayList methods = Lists.newArrayListWithCapacity((int)(variables.size() * 2 + 6));
                    PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance((Project)LightBindingClass.this.myInfo.getProject());
                    for (PsiDataBindingResourceItem variable : variables) {
                        LightBindingClass.this.createVariableMethods(factory, variable, methods);
                    }
                    LightBindingClass.this.createStaticMethods(factory, methods);
                    return methods.toArray(new PsiMethod[methods.size()]);
                }

                @Override
                PsiMethod[] defaultValue() {
                    return PsiMethod.EMPTY_ARRAY;
                }
            });
            this.myPsiFieldsCache = cachedValuesManager.createCachedValue((CachedValueProvider)new ResourceCacheValueProvider<PsiField[]>(facet, new ModificationTracker[0]){

                @Override
                PsiField[] doCompute() {
                    List<DataBindingInfo.ViewWithId> viewsWithIds = LightBindingClass.this.myInfo.getViewsWithIds();
                    PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance((Project)LightBindingClass.this.myInfo.getProject());
                    PsiField[] result = new PsiField[viewsWithIds.size()];
                    int i = 0;
                    int unresolved = 0;
                    for (DataBindingInfo.ViewWithId viewWithId : viewsWithIds) {
                        PsiField psiField = LightBindingClass.this.createPsiField(factory, viewWithId);
                        if (psiField == null) {
                            ++unresolved;
                            continue;
                        }
                        result[i++] = psiField;
                    }
                    if (unresolved > 0) {
                        PsiField[] validResult = new PsiField[i];
                        System.arraycopy(result, 0, validResult, 0, i);
                        return validResult;
                    }
                    return result;
                }

                @Override
                PsiField[] defaultValue() {
                    return PsiField.EMPTY_ARRAY;
                }
            });
        }

        public String toString() {
            return this.myInfo.getClassName();
        }

        @Nullable
        public String getQualifiedName() {
            return this.myInfo.getQualifiedName();
        }

        @Nullable
        public PsiClass getContainingClass() {
            return null;
        }

        @Override
        @NotNull
        public PsiField[] getFields() {
            PsiField[] psiFieldArray = (PsiField[])this.myPsiFieldsCache.getValue();
            if (psiFieldArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingUtil$LightBindingClass", "getFields"));
            }
            return psiFieldArray;
        }

        @Override
        @NotNull
        public PsiField[] getAllFields() {
            PsiField[] psiFieldArray = this.getFields();
            if (psiFieldArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingUtil$LightBindingClass", "getAllFields"));
            }
            return psiFieldArray;
        }

        @Override
        @NotNull
        public PsiMethod[] getMethods() {
            PsiMethod[] psiMethodArray = (PsiMethod[])this.myPsiMethodsCache.getValue();
            if (psiMethodArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingUtil$LightBindingClass", "getMethods"));
            }
            return psiMethodArray;
        }

        @Override
        public PsiClass getSuperClass() {
            return JavaPsiFacade.getInstance((Project)this.myInfo.getProject()).findClass("android.databinding.ViewDataBinding", this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(false));
        }

        @Override
        public PsiReferenceList getExtendsList() {
            if (this.myExtendsList == null) {
                PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance((Project)this.myInfo.getProject());
                PsiJavaCodeReferenceElement referenceElementByType = factory.createReferenceElementByType(this.getExtendsListTypes()[0]);
                this.myExtendsList = factory.createReferenceList(new PsiJavaCodeReferenceElement[]{referenceElementByType});
            }
            return this.myExtendsList;
        }

        @Override
        @NotNull
        public PsiClassType[] getSuperTypes() {
            PsiClassType[] psiClassTypeArray = this.getExtendsListTypes();
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingUtil$LightBindingClass", "getSuperTypes"));
            }
            return psiClassTypeArray;
        }

        @Override
        @NotNull
        public PsiClassType[] getExtendsListTypes() {
            if (this.myExtendsListTypes == null) {
                this.myExtendsListTypes = new PsiClassType[]{PsiType.getTypeByName((String)"android.databinding.ViewDataBinding", (Project)this.myInfo.getProject(), (GlobalSearchScope)this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(false))};
            }
            if (this.myExtendsListTypes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingUtil$LightBindingClass", "getExtendsListTypes"));
            }
            return this.myExtendsListTypes;
        }

        @Override
        @NotNull
        public PsiMethod[] getAllMethods() {
            PsiMethod[] psiMethodArray = this.getMethods();
            if (psiMethodArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingUtil$LightBindingClass", "getAllMethods"));
            }
            return psiMethodArray;
        }

        @Override
        @NotNull
        public PsiMethod[] findMethodsByName(@NonNls String name, boolean checkBases) {
            List matched = null;
            for (PsiMethod method : this.getMethods()) {
                if (!name.equals(method.getName())) continue;
                if (matched == null) {
                    matched = Lists.newArrayList();
                }
                matched.add(method);
            }
            PsiMethod[] psiMethodArray = matched == null ? PsiMethod.EMPTY_ARRAY : matched.toArray(new PsiMethod[matched.size()]);
            if (psiMethodArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingUtil$LightBindingClass", "findMethodsByName"));
            }
            return psiMethodArray;
        }

        @Override
        public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/android/tools/idea/databinding/DataBindingUtil$LightBindingClass", "processDeclarations"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/databinding/DataBindingUtil$LightBindingClass", "processDeclarations"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/android/tools/idea/databinding/DataBindingUtil$LightBindingClass", "processDeclarations"));
            }
            boolean continueProcessing = super.processDeclarations(processor, state, lastParent, place);
            if (!continueProcessing) {
                return false;
            }
            List<PsiDataBindingResourceItem> imports = this.myInfo.getItems(DataBindingResourceType.IMPORT);
            if (imports.isEmpty()) {
                return true;
            }
            ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
            if (classHint != null && classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
                NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
                String name = nameHint != null ? nameHint.getName(state) : null;
                for (PsiDataBindingResourceItem imp : imports) {
                    String qName;
                    String alias = imp.getExtra("alias");
                    if (alias != null || (qName = imp.getExtra("type")) == null || name != null && !qName.endsWith("." + name)) continue;
                    Module module = this.myInfo.getModule();
                    if (module == null) {
                        return true;
                    }
                    PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(qName, module.getModuleWithDependenciesAndLibrariesScope(true));
                    if (aClass == null || processor.execute((PsiElement)aClass, state)) continue;
                    return false;
                }
            }
            return true;
        }

        private static Lexer getJavaLexer() {
            if (ourJavaLexer == null) {
                ourJavaLexer = JavaParserDefinition.createLexer((LanguageLevel)LanguageLevel.JDK_1_6);
            }
            return ourJavaLexer;
        }

        private String replaceImportAliases(String type) {
            Map lookup = (Map)this.myAliasCache.getValue();
            if (lookup == null || lookup.isEmpty()) {
                return type;
            }
            Lexer lexer = LightBindingClass.getJavaLexer();
            lexer.start((CharSequence)type);
            boolean checkNext = true;
            StringBuilder out = new StringBuilder();
            IElementType tokenType = lexer.getTokenType();
            while (tokenType != null) {
                if (checkNext && tokenType == JavaTokenType.IDENTIFIER) {
                    String tokenText = lexer.getTokenText();
                    String replacement = (String)lookup.get(tokenText);
                    if (replacement != null) {
                        out.append(replacement);
                    } else {
                        out.append(tokenText);
                    }
                } else {
                    out.append(lexer.getTokenText());
                }
                if (tokenType != TokenType.WHITE_SPACE) {
                    checkNext = tokenType == JavaTokenType.LT || tokenType == JavaTokenType.COMMA;
                }
                lexer.advance();
                tokenType = lexer.getTokenType();
            }
            return out.toString();
        }

        private void createVariableMethods(PsiElementFactory factory, PsiDataBindingResourceItem item, List<PsiMethod> outPsiMethods) {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myInfo.getProject());
            PsiMethod setter = factory.createMethod("set" + StringUtil.capitalize((String)item.getName()), (PsiType)PsiType.VOID);
            String variableType = this.replaceImportAliases(item.getExtra("type"));
            PsiType type = DataBindingUtil.parsePsiType(variableType, this.myFacet, (PsiElement)this);
            if (type == null) {
                return;
            }
            PsiParameter param = factory.createParameter(item.getName(), type);
            setter.getParameterList().add((PsiElement)param);
            PsiUtil.setModifierProperty((PsiModifierListOwner)setter, (String)"public", (boolean)true);
            outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)item.getXmlTag(), psiManager, setter, this, (Language)JavaLanguage.INSTANCE));
            PsiMethod getter = factory.createMethod("get" + StringUtil.capitalize((String)item.getName()), type);
            PsiUtil.setModifierProperty((PsiModifierListOwner)getter, (String)"public", (boolean)true);
            outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)item.getXmlTag(), psiManager, getter, this, (Language)JavaLanguage.INSTANCE));
        }

        private void createStaticMethods(PsiElementFactory factory, List<PsiMethod> outPsiMethods) {
            PsiClassType myType = factory.createType((PsiClass)this);
            PsiClassType viewGroupType = PsiType.getTypeByName((String)"android.view.ViewGroup", (Project)this.myInfo.getProject(), (GlobalSearchScope)this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(true));
            PsiClassType layoutInflaterType = PsiType.getTypeByName((String)"android.view.LayoutInflater", (Project)this.myInfo.getProject(), (GlobalSearchScope)this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(true));
            PsiClassType dataBindingComponent = PsiType.getTypeByName((String)"android.databinding.DataBindingComponent", (Project)this.myInfo.getProject(), (GlobalSearchScope)this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(true));
            PsiClassType viewType = PsiType.getTypeByName((String)"android.view.View", (Project)this.myInfo.getProject(), (GlobalSearchScope)this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(true));
            PsiParameter layoutInflaterParam = factory.createParameter("inflater", (PsiType)layoutInflaterType);
            PsiParameter rootParam = factory.createParameter("root", (PsiType)viewGroupType);
            PsiParameter attachToRootParam = factory.createParameter("attachToRoot", (PsiType)PsiType.BOOLEAN);
            PsiParameter viewParam = factory.createParameter("view", (PsiType)viewType);
            PsiParameter componentParam = factory.createParameter("bindingComponent", (PsiType)dataBindingComponent);
            PsiMethod inflate4Arg = factory.createMethod("inflate", (PsiType)myType);
            inflate4Arg.getParameterList().add((PsiElement)layoutInflaterParam);
            inflate4Arg.getParameterList().add((PsiElement)rootParam);
            inflate4Arg.getParameterList().add((PsiElement)attachToRootParam);
            inflate4Arg.getParameterList().add((PsiElement)componentParam);
            PsiMethod inflate3Arg = factory.createMethod("inflate", (PsiType)myType);
            inflate3Arg.getParameterList().add((PsiElement)layoutInflaterParam);
            inflate3Arg.getParameterList().add((PsiElement)rootParam);
            inflate3Arg.getParameterList().add((PsiElement)attachToRootParam);
            PsiMethod inflate2Arg = factory.createMethod("inflate", (PsiType)myType);
            inflate2Arg.getParameterList().add((PsiElement)layoutInflaterParam);
            inflate2Arg.getParameterList().add((PsiElement)componentParam);
            PsiMethod inflate1Arg = factory.createMethod("inflate", (PsiType)myType);
            inflate1Arg.getParameterList().add((PsiElement)layoutInflaterParam);
            PsiMethod bind = factory.createMethod("bind", (PsiType)myType);
            bind.getParameterList().add((PsiElement)viewParam);
            PsiMethod bindWithComponent = factory.createMethod("bind", (PsiType)myType);
            bindWithComponent.getParameterList().add((PsiElement)viewParam);
            bindWithComponent.getParameterList().add((PsiElement)componentParam);
            PsiMethod[] methods = new PsiMethod[]{inflate1Arg, inflate2Arg, inflate3Arg, inflate4Arg, bind, bindWithComponent};
            PsiManager psiManager = PsiManager.getInstance((Project)this.myInfo.getProject());
            for (PsiMethod method : methods) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)true);
                PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"static", (boolean)true);
                outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)this.myInfo.getPsiFile(), psiManager, method, this, (Language)JavaLanguage.INSTANCE));
            }
        }

        @Nullable
        private PsiField createPsiField(PsiElementFactory factory, DataBindingInfo.ViewWithId viewWithId) {
            PsiType type = DataBindingUtil.resolveViewPsiType(viewWithId, this.myFacet);
            if (type == null) {
                return null;
            }
            PsiField field = factory.createField(viewWithId.name, type);
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"public", (boolean)true);
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
            return new LightDataBindingField(viewWithId, PsiManager.getInstance((Project)this.myInfo.getProject()), field, this);
        }

        @Override
        public boolean isInterface() {
            return false;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myInfo.getNavigationElement();
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingUtil$LightBindingClass", "getNavigationElement"));
            }
            return psiElement;
        }

        public String getName() {
            return this.myInfo.getClassName();
        }

        @Override
        @Nullable
        public PsiFile getContainingFile() {
            return this.myInfo.getPsiFile();
        }
    }
}

