/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.ProjectResourceCachedValueProvider;
import com.android.tools.idea.databinding.ResourceCacheValueProvider;
import com.android.tools.idea.rendering.DataBindingInfo;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingShortNamesCache
extends PsiShortNamesCache {
    private DataBindingProjectComponent myComponent;
    private CachedValue<Map<String, List<DataBindingInfo>>> myNameCache;
    private CachedValue<String[]> myAllClassNamesCache;
    private CachedValue<Map<String, List<PsiMethod>>> myMethodsByNameCache;
    private CachedValue<Map<String, List<PsiField>>> myFieldsByNameCache;
    private CachedValue<String[]> myAllMethodNamesCache;
    private CachedValue<String[]> myAllFieldNamesCache;

    public DataBindingShortNamesCache(DataBindingProjectComponent dataBindingProjectComponent) {
        this.myComponent = dataBindingProjectComponent;
        final NameCacheProvider nameCacheProvider = new NameCacheProvider(this.myComponent);
        Project project = dataBindingProjectComponent.getProject();
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project);
        this.myNameCache = cachedValuesManager.createCachedValue((CachedValueProvider)nameCacheProvider, false);
        this.myAllClassNamesCache = cachedValuesManager.createCachedValue((CachedValueProvider)new CachedValueProvider<String[]>(){

            @Nullable
            public CachedValueProvider.Result<String[]> compute() {
                return CachedValueProvider.Result.create((Object)ArrayUtil.toStringArray(((Map)DataBindingShortNamesCache.this.myNameCache.getValue()).keySet()), (Object[])new Object[]{nameCacheProvider});
            }
        }, false);
        this.myMethodsByNameCache = cachedValuesManager.createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, List<PsiMethod>>>(){

            @Nullable
            public CachedValueProvider.Result<Map<String, List<PsiMethod>>> compute() {
                final HashMap result = Maps.newHashMap();
                DataBindingShortNamesCache.this.traverseAllClasses((Function<PsiClass, Void>)((Function)new Function<PsiClass, Void>(){

                    public Void fun(PsiClass psiClass) {
                        for (PsiMethod method : psiClass.getMethods()) {
                            List psiMethods = (List)result.get(method.getName());
                            if (psiMethods == null) {
                                psiMethods = Lists.newArrayList();
                                result.put(method.getName(), psiMethods);
                            }
                            psiMethods.add(method);
                        }
                        return null;
                    }
                }));
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{nameCacheProvider});
            }
        }, false);
        this.myFieldsByNameCache = cachedValuesManager.createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, List<PsiField>>>(){

            @Nullable
            public CachedValueProvider.Result<Map<String, List<PsiField>>> compute() {
                final HashMap result = Maps.newHashMap();
                DataBindingShortNamesCache.this.traverseAllClasses((Function<PsiClass, Void>)((Function)new Function<PsiClass, Void>(){

                    public Void fun(PsiClass psiClass) {
                        for (PsiField field : psiClass.getFields()) {
                            List psiFields = (List)result.get(field.getName());
                            if (psiFields == null) {
                                psiFields = Lists.newArrayList();
                                result.put(field.getName(), psiFields);
                            }
                            psiFields.add(field);
                        }
                        return null;
                    }
                }));
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{nameCacheProvider});
            }
        }, false);
        this.myAllMethodNamesCache = cachedValuesManager.createCachedValue((CachedValueProvider)new CachedValueProvider<String[]>(){

            @Nullable
            public CachedValueProvider.Result<String[]> compute() {
                Set names = ((Map)DataBindingShortNamesCache.this.myMethodsByNameCache.getValue()).keySet();
                return CachedValueProvider.Result.create((Object)ArrayUtil.toStringArray(names), (Object[])new Object[]{nameCacheProvider});
            }
        }, false);
        this.myAllFieldNamesCache = cachedValuesManager.createCachedValue((CachedValueProvider)new CachedValueProvider<String[]>(){

            @Nullable
            public CachedValueProvider.Result<String[]> compute() {
                Set names = ((Map)DataBindingShortNamesCache.this.myFieldsByNameCache.getValue()).keySet();
                return CachedValueProvider.Result.create((Object)ArrayUtil.toStringArray(names), (Object[])new Object[]{nameCacheProvider});
            }
        }, false);
    }

    private void traverseAllClasses(Function<PsiClass, Void> receiver) {
        for (List infoList : ((Map)this.myNameCache.getValue()).values()) {
            for (DataBindingInfo info : infoList) {
                PsiClass psiClass = DataBindingUtil.getOrCreatePsiClass(info);
                receiver.fun((Object)psiClass);
            }
        }
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getClassesByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getClassesByName"));
        }
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getClassesByName"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        List infoList = (List)((Map)this.myNameCache.getValue()).get(name);
        if (infoList == null || infoList.size() == 0) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getClassesByName"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList selected = Lists.newArrayList();
        for (DataBindingInfo info : infoList) {
            if (!scope.accept(info.getPsiFile().getVirtualFile())) continue;
            selected.add(DataBindingUtil.getOrCreatePsiClass(info));
        }
        if (selected.isEmpty()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getClassesByName"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = selected.toArray(new PsiClass[selected.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getClassesByName"));
        }
        return psiClassArray;
    }

    @NotNull
    public String[] getAllClassNames() {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getAllClassNames"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = (String[])this.myAllClassNamesCache.getValue();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getAllClassNames"));
        }
        return stringArray;
    }

    public void getAllClassNames(@NotNull HashSet<String> dest) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getAllClassNames"));
        }
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            return;
        }
        Collections.addAll(dest, this.getAllClassNames());
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getMethodsByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getMethodsByName"));
        }
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getMethodsByName"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        List methods = (List)((Map)this.myMethodsByNameCache.getValue()).get(name);
        PsiMethod[] psiMethodArray = (PsiMethod[])DataBindingShortNamesCache.filterByScope((List)methods, (GlobalSearchScope)scope, PsiMethod.class, (PsiElement[])PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getMethodsByName"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getMethodsByNameIfNotMoreThan"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getMethodsByNameIfNotMoreThan"));
        }
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getMethodsByNameIfNotMoreThan"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] methods = this.getMethodsByName(name, scope);
        if (methods.length > maxCount) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getMethodsByNameIfNotMoreThan"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        if (methods == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getMethodsByNameIfNotMoreThan"));
        }
        return methods;
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getFieldsByNameIfNotMoreThan"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getFieldsByNameIfNotMoreThan"));
        }
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            if (PsiField.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getFieldsByNameIfNotMoreThan"));
            }
            return PsiField.EMPTY_ARRAY;
        }
        List psiFields = (List)((Map)this.myFieldsByNameCache.getValue()).get(name);
        PsiField[] selected = (PsiField[])DataBindingShortNamesCache.filterByScope((List)psiFields, (GlobalSearchScope)scope, PsiField.class, (PsiElement[])PsiField.EMPTY_ARRAY);
        if (selected.length > maxCount) {
            if (PsiField.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getFieldsByNameIfNotMoreThan"));
            }
            return PsiField.EMPTY_ARRAY;
        }
        if (selected == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getFieldsByNameIfNotMoreThan"));
        }
        return selected;
    }

    private static <T extends PsiElement> T[] filterByScope(List<T> items, @NotNull GlobalSearchScope scope, Class<T> klass, T[] defaultValue) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "filterByScope"));
        }
        if (items == null || items.isEmpty()) {
            return defaultValue;
        }
        ArrayList selected = Lists.newArrayList();
        for (PsiElement item : items) {
            if (item.getContainingFile() == null || !scope.accept(item.getContainingFile().getVirtualFile())) continue;
            selected.add(item);
        }
        return selected.toArray((PsiElement[])Array.newInstance(klass, selected.size()));
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiMethod> processor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "processMethodsWithName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "processMethodsWithName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "processMethodsWithName"));
        }
        for (PsiMethod method : this.getMethodsByName(name, scope)) {
            if (processor.process((Object)method)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String[] getAllMethodNames() {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getAllMethodNames"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = (String[])this.myAllMethodNamesCache.getValue();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getAllMethodNames"));
        }
        return stringArray;
    }

    public void getAllMethodNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getAllMethodNames"));
        }
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            return;
        }
        Collections.addAll(set, this.getAllClassNames());
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getFieldsByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getFieldsByName"));
        }
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            if (PsiField.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getFieldsByName"));
            }
            return PsiField.EMPTY_ARRAY;
        }
        List psiFields = (List)((Map)this.myFieldsByNameCache.getValue()).get(name);
        PsiField[] psiFieldArray = (PsiField[])DataBindingShortNamesCache.filterByScope((List)psiFields, (GlobalSearchScope)scope, PsiField.class, (PsiElement[])PsiField.EMPTY_ARRAY);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getFieldsByName"));
        }
        return psiFieldArray;
    }

    @NotNull
    public String[] getAllFieldNames() {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getAllFieldNames"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = (String[])this.myAllFieldNamesCache.getValue();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getAllFieldNames"));
        }
        return stringArray;
    }

    public void getAllFieldNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/android/tools/idea/databinding/DataBindingShortNamesCache", "getAllFieldNames"));
        }
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            return;
        }
        Collections.addAll(set, this.getAllFieldNames());
    }

    private static class FacetNameCacheProvider
    extends ResourceCacheValueProvider<Map<String, List<DataBindingInfo>>> {
        public FacetNameCacheProvider(AndroidFacet facet) {
            super(facet, new ModificationTracker[0]);
        }

        @Override
        Map<String, List<DataBindingInfo>> doCompute() {
            LocalResourceRepository moduleResources = this.getFacet().getModuleResources(false);
            if (moduleResources == null) {
                return this.defaultValue();
            }
            Map<String, DataBindingInfo> dataBindingResourceFiles = moduleResources.getDataBindingResourceFiles();
            if (dataBindingResourceFiles == null) {
                return this.defaultValue();
            }
            HashMap cache = Maps.newHashMap();
            for (DataBindingInfo info : dataBindingResourceFiles.values()) {
                List infoList = (List)cache.get(info.getClassName());
                if (infoList == null) {
                    infoList = Lists.newArrayList();
                    cache.put(info.getClassName(), infoList);
                }
                infoList.add(info);
            }
            return cache;
        }

        @Override
        Map<String, List<DataBindingInfo>> defaultValue() {
            return Maps.newHashMap();
        }
    }

    private static class NameCacheProvider
    extends ProjectResourceCachedValueProvider.MergedMapValueProvider<String, DataBindingInfo> {
        public NameCacheProvider(DataBindingProjectComponent component) {
            super(component, new ModificationTracker[0]);
        }

        @Override
        ResourceCacheValueProvider<Map<String, List<DataBindingInfo>>> createCacheProvider(AndroidFacet facet) {
            return new FacetNameCacheProvider(facet);
        }
    }
}

