/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.Density;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repositoryv2.targets.SystemImage;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorNotificationPanel;
import com.android.tools.idea.avdmanager.ApiLevelComparator;
import com.android.tools.idea.avdmanager.AvdActionPanel;
import com.android.tools.idea.avdmanager.AvdListDialog;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.tools.idea.avdmanager.CreateAvdAction;
import com.android.tools.idea.avdmanager.DeleteAvdAction;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.EditAvdAction;
import com.android.tools.idea.avdmanager.EmptyAvdListPanel;
import com.android.tools.idea.avdmanager.RunAvdAction;
import com.android.tools.idea.npw.WizardUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdDisplayList
extends JPanel
implements ListSelectionListener,
AvdActionPanel.AvdRefreshProvider,
AvdUiAction.AvdInfoProvider {
    private static final Logger LOG = Logger.getInstance(AvdDisplayList.class);
    public static final String NONEMPTY = "nonempty";
    public static final String EMPTY = "empty";
    private final Project myProject;
    private final JButton myRefreshButton;
    private final JPanel myCenterCardPanel;
    private final JPanel myNotificationPanel;
    private final AvdListDialog myDialog;
    private TableView<AvdInfo> myTable;
    private ListTableModel<AvdInfo> myModel;
    private Set<AvdSelectionListener> myListeners;
    private final AvdActionsColumnInfo myActionsColumnRenderer;
    private final MouseAdapter myEditingListener;
    private final ColumnInfo[] myColumnInfos;

    public AvdDisplayList(@NotNull AvdListDialog dialog, @Nullable Project project) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/android/tools/idea/avdmanager/AvdDisplayList", "<init>"));
        }
        this.myRefreshButton = new JButton(AllIcons.Actions.Refresh);
        this.myModel = new ListTableModel(new ColumnInfo[0]);
        this.myListeners = Sets.newHashSet();
        this.myActionsColumnRenderer = new AvdActionsColumnInfo(this, "Actions", 2);
        this.myEditingListener = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                AvdDisplayList.this.possiblySwitchEditors(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                AvdDisplayList.this.possiblySwitchEditors(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AvdDisplayList.this.possiblySwitchEditors(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                AvdDisplayList.this.possiblySwitchEditors(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                AvdDisplayList.this.possiblyShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                AvdDisplayList.this.possiblyShowPopup(e);
            }
        };
        this.myColumnInfos = new ColumnInfo[]{new AvdIconColumnInfo("Type"){

            @Nullable
            public Icon valueOf(AvdInfo avdInfo) {
                return AvdDisplayList.getIcon(avdInfo);
            }
        }, new AvdColumnInfo("Name"){

            @Nullable
            public String valueOf(AvdInfo info) {
                return AvdManagerConnection.getAvdDisplayName(info);
            }
        }, new AvdColumnInfo("Resolution"){

            @Nullable
            public String valueOf(AvdInfo avdInfo) {
                return AvdDisplayList.getResolution(avdInfo);
            }

            @Override
            @Nullable
            public Comparator<AvdInfo> getComparator() {
                return new Comparator<AvdInfo>(){

                    @Override
                    public int compare(AvdInfo o1, AvdInfo o2) {
                        Dimension d2;
                        Dimension d1 = AvdDisplayList.getScreenSize(o1);
                        if (d1 == (d2 = AvdDisplayList.getScreenSize(o2))) {
                            return 0;
                        }
                        if (d1 == null) {
                            return -1;
                        }
                        if (d2 == null) {
                            return 1;
                        }
                        return d1.width * d1.height - d2.width * d2.height;
                    }
                };
            }
        }, new AvdColumnInfo("API", JBUI.scale((int)50)){

            @NotNull
            public String valueOf(AvdInfo avdInfo) {
                String string = avdInfo.getAndroidVersion().getApiString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDisplayList$7", "valueOf"));
                }
                return string;
            }

            @Override
            @Nullable
            public Comparator<AvdInfo> getComparator() {
                final ApiLevelComparator comparator = new ApiLevelComparator();
                return new Comparator<AvdInfo>(){

                    @Override
                    public int compare(AvdInfo o1, AvdInfo o2) {
                        return comparator.compare(this.valueOf(o1), this.valueOf(o2));
                    }
                };
            }
        }, new AvdColumnInfo("Target"){

            @Nullable
            public String valueOf(AvdInfo info) {
                String result = "Android " + SdkVersionInfo.getVersionString((int)info.getAndroidVersion().getFeatureLevel());
                if (!info.getTag().equals((Object)SystemImage.DEFAULT_TAG)) {
                    result = result + " (" + info.getTag().getDisplay() + ")";
                }
                return result;
            }
        }, new AvdColumnInfo("CPU/ABI", JBUI.scale((int)60)){

            @Nullable
            public String valueOf(AvdInfo avdInfo) {
                return avdInfo.getCpuArch();
            }
        }, new AvdSizeColumnInfo("Size on Disk"), this.myActionsColumnRenderer};
        this.myDialog = dialog;
        this.myProject = project;
        this.myModel.setColumnInfos(this.myColumnInfos);
        this.myModel.setSortable(true);
        this.myTable = new TableView();
        this.myTable.setModelAndUpdateColumns(this.myModel);
        this.myTable.setDefaultRenderer(Object.class, (TableCellRenderer)new MyRenderer(this.myTable.getDefaultRenderer(Object.class)));
        this.setLayout(new BorderLayout());
        this.myCenterCardPanel = new JPanel(new CardLayout());
        this.myNotificationPanel = new JPanel();
        this.myNotificationPanel.setLayout(new BoxLayout(this.myNotificationPanel, 1));
        JPanel nonemptyPanel = new JPanel(new BorderLayout());
        this.myCenterCardPanel.add((Component)nonemptyPanel, NONEMPTY);
        nonemptyPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myTable), "Center");
        nonemptyPanel.add((Component)this.myNotificationPanel, "North");
        this.myCenterCardPanel.add((Component)new EmptyAvdListPanel(this), EMPTY);
        this.add((Component)this.myCenterCardPanel, "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)this.myRefreshButton, "East");
        this.myRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvdDisplayList.this.refreshAvds();
            }
        });
        this.myRefreshButton.putClientProperty("JButton.buttonType", "segmented-only");
        CreateAvdAction createAvdAction = new CreateAvdAction(this);
        JButton newButton = new JButton(createAvdAction);
        newButton.putClientProperty("JButton.buttonType", "segmented-only");
        southPanel.add((Component)newButton, "West");
        nonemptyPanel.add((Component)southPanel, "South");
        this.myTable.getSelectionModel().setSelectionMode(0);
        this.myTable.getSelectionModel().addListSelectionListener(this);
        this.myTable.addMouseListener((MouseListener)this.myEditingListener);
        this.myTable.addMouseMotionListener((MouseMotionListener)this.myEditingListener);
        LaunchListener launchListener = new LaunchListener();
        this.myTable.addMouseListener((MouseListener)launchListener);
        ActionMap am = this.myTable.getActionMap();
        am.put("selectPreviousColumnCell", new CycleAction(true));
        am.put("selectNextColumnCell", new CycleAction(false));
        am.put("deleteAvd", new DeleteAvdAction(this));
        this.myTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.myTable.getInputMap(1).put(KeyStroke.getKeyStroke(32, 0), "enter");
        this.myTable.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "deleteAvd");
        this.myTable.getInputMap(1).put(KeyStroke.getKeyStroke(8, 0), "deleteAvd");
        am.put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvdDisplayList.this.doAction();
            }
        });
        this.refreshAvds();
    }

    public void addSelectionListener(AvdSelectionListener listener) {
        this.myListeners.add(listener);
    }

    public void removeSelectionListener(AvdSelectionListener listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.myTable.editCellAt(this.myTable.getSelectedRow(), this.myTable.getSelectedColumn());
        AvdInfo selected = (AvdInfo)this.myTable.getSelectedObject();
        for (AvdSelectionListener listener : this.myListeners) {
            listener.onAvdSelected(selected);
        }
    }

    @Override
    @Nullable
    public AvdInfo getAvdInfo() {
        return (AvdInfo)this.myTable.getSelectedObject();
    }

    @Override
    public void refreshAvds() {
        List<AvdInfo> avds = AvdManagerConnection.getDefaultAvdManagerConnection().getAvds(true);
        this.myModel.setItems(avds);
        if (avds.isEmpty()) {
            ((CardLayout)this.myCenterCardPanel.getLayout()).show(this.myCenterCardPanel, EMPTY);
        } else {
            ((CardLayout)this.myCenterCardPanel.getLayout()).show(this.myCenterCardPanel, NONEMPTY);
        }
        this.refreshErrorCheck();
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        AvdDisplayList avdDisplayList = this;
        if (avdDisplayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDisplayList", "getComponent"));
        }
        return avdDisplayList;
    }

    private void possiblySwitchEditors(MouseEvent e) {
        Point p = e.getPoint();
        int row = this.myTable.rowAtPoint(p);
        int col = this.myTable.columnAtPoint(p);
        if ((row != this.myTable.getEditingRow() || col != this.myTable.getEditingColumn()) && row != -1 && col != -1 && this.myTable.isCellEditable(row, col)) {
            this.myTable.editCellAt(row, col);
        }
    }

    private void possiblyShowPopup(MouseEvent e) {
        int lastColumn;
        Component maybeActionPanel;
        if (!e.isPopupTrigger()) {
            return;
        }
        Point p = e.getPoint();
        int row = this.myTable.rowAtPoint(p);
        int col = this.myTable.columnAtPoint(p);
        if (row != -1 && col != -1 && (maybeActionPanel = this.myTable.getCellRenderer(row, lastColumn = this.myTable.getColumnCount() - 1).getTableCellRendererComponent((JTable)this.myTable, this.myTable.getValueAt(row, lastColumn), false, true, row, lastColumn)) instanceof AvdActionPanel) {
            ((AvdActionPanel)maybeActionPanel).showPopup((Component)this.myTable, e);
        }
    }

    static Dimension getScreenSize(@NotNull AvdInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/avdmanager/AvdDisplayList", "getScreenSize"));
        }
        DeviceManagerConnection deviceManager = DeviceManagerConnection.getDefaultDeviceManagerConnection();
        Device device = deviceManager.getDevice(info.getDeviceName(), info.getDeviceManufacturer());
        if (device == null) {
            return null;
        }
        return device.getScreenSize(device.getDefaultState().getOrientation());
    }

    static String getResolution(@NotNull AvdInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/avdmanager/AvdDisplayList", "getResolution"));
        }
        DeviceManagerConnection deviceManager = DeviceManagerConnection.getDefaultDeviceManagerConnection();
        Device device = deviceManager.getDevice(info.getDeviceName(), info.getDeviceManufacturer());
        Dimension res = null;
        Density density = null;
        if (device != null) {
            res = device.getScreenSize(device.getDefaultState().getOrientation());
            density = device.getDefaultHardware().getScreen().getPixelDensity();
        }
        String densityString = density == null ? "Unknown Density" : density.getResourceValue();
        String resolution = res != null ? String.format(Locale.getDefault(), "%1$d \u00d7 %2$d: %3$s", res.width, res.height, densityString) : "Unknown Resolution";
        return resolution;
    }

    private static Icon getIcon(@NotNull AvdInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/avdmanager/AvdDisplayList", "getIcon"));
        }
        String id = info.getTag().getId();
        if (id.contains("android-")) {
            String path = String.format("/icons/formfactors/%s_32.png", id.substring("android-".length()));
            return IconLoader.getIcon((String)path, AvdDisplayList.class);
        }
        return AndroidIcons.FormFactors.Mobile_32;
    }

    private void refreshErrorCheck() {
        boolean refreshUI = this.myNotificationPanel.getComponentCount() > 0;
        this.myNotificationPanel.removeAll();
        AccelerationErrorCode error = AvdManagerConnection.getDefaultAvdManagerConnection().checkAcceration();
        if (error != AccelerationErrorCode.ALREADY_INSTALLED) {
            refreshUI = true;
            this.myNotificationPanel.add((Component)((Object)new AccelerationErrorNotificationPanel(error, this.myProject, new Runnable(){

                @Override
                public void run() {
                    AvdDisplayList.this.refreshErrorCheck();
                }
            })));
        }
        if (refreshUI) {
            this.myNotificationPanel.revalidate();
            this.myNotificationPanel.repaint();
        }
    }

    private void doAction() {
        AvdInfo info = this.getAvdInfo();
        if (info != null) {
            if (info.getStatus() == AvdInfo.AvdStatus.OK) {
                new RunAvdAction(this).actionPerformed(null);
            } else {
                new EditAvdAction(this).actionPerformed(null);
            }
        }
    }

    private static class MyRenderer
    implements TableCellRenderer {
        private static final Border myBorder = IdeBorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)10);
        TableCellRenderer myDefaultRenderer;

        MyRenderer(TableCellRenderer defaultRenderer) {
            this.myDefaultRenderer = defaultRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent result = (JComponent)this.myDefaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            result.setBorder(myBorder);
            return result;
        }
    }

    private class CycleAction
    extends AbstractAction {
        boolean myBackward;

        CycleAction(boolean backward) {
            this.myBackward = backward;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int selectedRow = AvdDisplayList.this.myTable.getSelectedRow();
            int selectedColumn = AvdDisplayList.this.myTable.getSelectedColumn();
            int actionsColumn = AvdDisplayList.this.myModel.findColumn(AvdDisplayList.this.myActionsColumnRenderer.getName());
            if (this.myBackward) {
                this.cycleBackward(selectedRow, selectedColumn, actionsColumn);
            } else {
                this.cycleForward(selectedRow, selectedColumn, actionsColumn);
            }
            selectedRow = AvdDisplayList.this.myTable.getSelectedRow();
            if (selectedRow != -1) {
                AvdDisplayList.this.myTable.editCellAt(selectedRow, AvdDisplayList.this.myTable.getSelectedColumn());
            }
            AvdDisplayList.this.repaint();
        }

        private void cycleForward(int selectedRow, int selectedColumn, int actionsColumn) {
            if (selectedColumn == actionsColumn && selectedRow == AvdDisplayList.this.myTable.getRowCount() - 1) {
                if (!AvdDisplayList.this.myActionsColumnRenderer.cycleFocus((AvdInfo)AvdDisplayList.this.myTable.getSelectedObject(), false)) {
                    AvdDisplayList.this.myActionsColumnRenderer.getEditor(AvdDisplayList.this.getAvdInfo()).stopCellEditing();
                    AvdDisplayList.this.myTable.removeRowSelectionInterval(selectedRow, selectedRow);
                    KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    manager.focusNextComponent((Component)AvdDisplayList.this.myTable);
                }
            } else if (selectedColumn != actionsColumn && selectedRow != -1) {
                AvdDisplayList.this.myTable.setColumnSelectionInterval(actionsColumn, actionsColumn);
                AvdDisplayList.this.myActionsColumnRenderer.cycleFocus((AvdInfo)AvdDisplayList.this.myTable.getSelectedObject(), false);
            } else if (selectedRow == -1 || !AvdDisplayList.this.myActionsColumnRenderer.cycleFocus((AvdInfo)AvdDisplayList.this.myTable.getSelectedObject(), false)) {
                AvdDisplayList.this.myTable.setColumnSelectionInterval(0, 0);
                AvdDisplayList.this.myTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
            }
        }

        private void cycleBackward(int selectedRow, int selectedColumn, int actionsColumn) {
            if (selectedColumn == 0 && selectedRow == 0) {
                AvdDisplayList.this.myTable.removeRowSelectionInterval(selectedRow, selectedRow);
                KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                manager.focusPreviousComponent();
            } else if (selectedColumn == actionsColumn && selectedRow != -1 && !AvdDisplayList.this.myActionsColumnRenderer.cycleFocus((AvdInfo)AvdDisplayList.this.myTable.getSelectedObject(), true)) {
                AvdDisplayList.this.myTable.setColumnSelectionInterval(0, 0);
            } else if (selectedRow == -1 || selectedColumn != actionsColumn) {
                if (selectedRow == -1) {
                    selectedRow = AvdDisplayList.this.myTable.getRowCount();
                }
                AvdDisplayList.this.myTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
                AvdDisplayList.this.myTable.setColumnSelectionInterval(actionsColumn, actionsColumn);
                AvdDisplayList.this.myActionsColumnRenderer.cycleFocus((AvdInfo)AvdDisplayList.this.myTable.getSelectedObject(), true);
            }
        }
    }

    private class LaunchListener
    extends MouseAdapter {
        private LaunchListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                AvdDisplayList.this.doAction();
            }
        }
    }

    private class AvdSizeColumnInfo
    extends AvdColumnInfo {
        public AvdSizeColumnInfo(String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdSizeColumnInfo", "<init>"));
            }
            super(name);
        }

        @NotNull
        private Storage getSize(AvdInfo avdInfo) {
            long sizeInBytes = 0L;
            if (avdInfo != null) {
                File avdDir = new File(avdInfo.getDataFolderPath());
                for (File file : WizardUtils.listFiles(avdDir)) {
                    sizeInBytes += file.length();
                }
            }
            Storage storage = new Storage(sizeInBytes);
            if (storage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdSizeColumnInfo", "getSize"));
            }
            return storage;
        }

        @Nullable
        public String valueOf(AvdInfo avdInfo) {
            Storage size = this.getSize(avdInfo);
            String unitString = "MB";
            Long value = size.getSizeAsUnit(Storage.Unit.MiB);
            if (value > 1024L) {
                unitString = "GB";
                value = size.getSizeAsUnit(Storage.Unit.GiB);
            }
            return String.format(Locale.getDefault(), "%1$d %2$s", value, unitString);
        }

        @Override
        @Nullable
        public Comparator<AvdInfo> getComparator() {
            return new Comparator<AvdInfo>(){

                @Override
                public int compare(AvdInfo o1, AvdInfo o2) {
                    Storage s1 = AvdSizeColumnInfo.this.getSize(o1);
                    Storage s2 = AvdSizeColumnInfo.this.getSize(o2);
                    return Comparing.compare((long)s1.getSize(), (long)s2.getSize());
                }
            };
        }
    }

    private class AvdActionsColumnInfo
    extends ColumnInfo<AvdInfo, AvdInfo> {
        private int myWidth;
        private int myNumVisibleActions;
        private final Map<Object, ActionRenderer> ourActionPanelRendererEditor;
        final /* synthetic */ AvdDisplayList this$0;

        public AvdActionsColumnInfo(@NotNull AvdDisplayList avdDisplayList, String name, int numVisibleActions) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdActionsColumnInfo", "<init>"));
            }
            this.this$0 = avdDisplayList;
            super(name);
            this.ourActionPanelRendererEditor = Maps.newHashMap();
            this.myNumVisibleActions = numVisibleActions;
            this.myWidth = numVisibleActions == -1 ? -1 : JBUI.scale((int)45) * numVisibleActions + JBUI.scale((int)75);
        }

        public AvdActionsColumnInfo(@NotNull AvdDisplayList avdDisplayList, String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdActionsColumnInfo", "<init>"));
            }
            this(avdDisplayList, name, -1);
        }

        @Nullable
        public AvdInfo valueOf(AvdInfo avdInfo) {
            return avdInfo;
        }

        @Nullable
        public Comparator<AvdInfo> getComparator() {
            return new Comparator<AvdInfo>(){

                @Override
                public int compare(AvdInfo o1, AvdInfo o2) {
                    return o1.getStatus().compareTo((Enum)o2.getStatus());
                }
            };
        }

        @Nullable
        public TableCellRenderer getRenderer(AvdInfo avdInfo) {
            return this.getComponent(avdInfo);
        }

        public ActionRenderer getComponent(AvdInfo avdInfo) {
            ActionRenderer renderer = this.ourActionPanelRendererEditor.get(avdInfo);
            if (renderer == null) {
                renderer = this.this$0.new ActionRenderer(this.myNumVisibleActions, avdInfo);
                this.ourActionPanelRendererEditor.put(avdInfo, renderer);
            }
            return renderer;
        }

        @Nullable
        public TableCellEditor getEditor(AvdInfo avdInfo) {
            return this.getComponent(avdInfo);
        }

        public boolean isCellEditable(AvdInfo avdInfo) {
            return true;
        }

        public int getWidth(JTable table) {
            return this.myWidth;
        }

        public boolean cycleFocus(AvdInfo info, boolean backward) {
            return this.getComponent(info).cycleFocus(backward);
        }
    }

    private class ActionRenderer
    extends AbstractTableCellEditor
    implements TableCellRenderer {
        AvdActionPanel myComponent;
        private int myNumVisibleActions = -1;

        ActionRenderer(int numVisibleActions, AvdInfo info) {
            this.myNumVisibleActions = numVisibleActions;
            this.myComponent = new AvdActionPanel(info, this.myNumVisibleActions, AvdDisplayList.this);
        }

        private Component getComponent(JTable table, int row, int column) {
            if (table.getSelectedRow() == row) {
                this.myComponent.setBackground(table.getSelectionBackground());
                this.myComponent.setForeground(table.getSelectionForeground());
            } else {
                this.myComponent.setBackground(table.getBackground());
                this.myComponent.setForeground(table.getForeground());
            }
            this.myComponent.setFocused(table.getSelectedRow() == row && table.getSelectedColumn() == column);
            return this.myComponent;
        }

        public boolean cycleFocus(boolean backward) {
            return this.myComponent.cycleFocus(backward);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.getComponent(table, row, column);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.getComponent(table, row, column);
        }

        public Object getCellEditorValue() {
            return null;
        }
    }

    public static abstract class AvdColumnInfo
    extends ColumnInfo<AvdInfo, String> {
        private final int myWidth;

        public AvdColumnInfo(@NotNull String name, int width) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdColumnInfo", "<init>"));
            }
            super(name);
            this.myWidth = width;
        }

        public AvdColumnInfo(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdColumnInfo", "<init>"));
            }
            this(name, -1);
        }

        @Nullable
        public Comparator<AvdInfo> getComparator() {
            return new Comparator<AvdInfo>(){

                @Override
                public int compare(AvdInfo o1, AvdInfo o2) {
                    String s1 = (String)AvdColumnInfo.this.valueOf(o1);
                    String s2 = (String)AvdColumnInfo.this.valueOf(o2);
                    return Comparing.compare((Comparable)((Object)s1), (Comparable)((Object)s2));
                }
            };
        }

        public int getWidth(JTable table) {
            return this.myWidth;
        }
    }

    private static abstract class AvdIconColumnInfo
    extends ColumnInfo<AvdInfo, Icon> {
        private final int myWidth;
        private static final TableCellRenderer ourIconRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JBLabel label = new JBLabel((Icon)value);
                if (table.getSelectedRow() == row) {
                    label.setBackground(table.getSelectionBackground());
                    label.setForeground(table.getSelectionForeground());
                    label.setOpaque(true);
                }
                return label;
            }
        };

        public AvdIconColumnInfo(@NotNull String name, int width) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdIconColumnInfo", "<init>"));
            }
            super(name);
            this.myWidth = width;
        }

        public AvdIconColumnInfo(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/AvdDisplayList$AvdIconColumnInfo", "<init>"));
            }
            this(name, JBUI.scale((int)50));
        }

        @Nullable
        public TableCellRenderer getRenderer(AvdInfo o) {
            return ourIconRenderer;
        }

        public int getWidth(JTable table) {
            return this.myWidth;
        }
    }

    public static interface AvdSelectionListener {
        public void onAvdSelected(@Nullable AvdInfo var1);
    }
}

