/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitSimpleHandler;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseActionDialog;
import git4idea.rebase.GitRebaseUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitRebaseAbort
extends GitRepositoryAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void perform(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot, Set<VirtualFile> affectedRoots, List<VcsException> exceptions) throws VcsException {
        VirtualFile root;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/actions/GitRebaseAbort", "perform"));
        }
        if (gitRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitRoots", "git4idea/actions/GitRebaseAbort", "perform"));
        }
        if (defaultRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultRoot", "git4idea/actions/GitRebaseAbort", "perform"));
        }
        Iterator<VirtualFile> i = gitRoots.iterator();
        while (i.hasNext()) {
            if (GitRebaseUtils.isRebaseInTheProgress(i.next())) continue;
            i.remove();
        }
        if (gitRoots.size() == 0) {
            Messages.showErrorDialog((Project)project, (String)GitBundle.getString("rebase.action.no.root"), (String)GitBundle.getString("rebase.action.error"));
            return;
        }
        if (gitRoots.size() == 1) {
            root = gitRoots.get(0);
        } else {
            if (!gitRoots.contains(defaultRoot)) {
                defaultRoot = gitRoots.get(0);
            }
            GitRebaseActionDialog d = new GitRebaseActionDialog(project, this.getActionName(), gitRoots, defaultRoot);
            d.show();
            root = d.selectRoot();
            if (root == null) {
                return;
            }
        }
        affectedRoots.add(root);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.REBASE);
        h.setStdoutSuppressed(false);
        h.addParameters("--abort");
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)project);
        try {
            GitHandlerUtil.doSynchronously(h, this.getActionName(), h.printableCommandLine());
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{root});
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)project, (AccessToken)token);
        }
    }

    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("rebase.abort.action.name");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/actions/GitRebaseAbort", "getActionName"));
        }
        return string;
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        return super.isEnabled(e) && GitRebaseAbort.isRebasing(e);
    }
}

