/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsUser;
import git4idea.GitVcs;
import git4idea.config.GitConfigUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUserRegistry
implements Disposable,
VcsListener {
    private static final Logger LOG = Logger.getInstance(GitUserRegistry.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final VcsLogObjectsFactory myFactory;
    @NotNull
    private final Map<VirtualFile, VcsUser> myUserMap;

    public GitUserRegistry(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager, @NotNull VcsLogObjectsFactory factory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitUserRegistry", "<init>"));
        }
        if (vcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsManager", "git4idea/GitUserRegistry", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/GitUserRegistry", "<init>"));
        }
        this.myUserMap = ContainerUtil.newConcurrentMap();
        this.myProject = project;
        this.myVcsManager = vcsManager;
        this.myFactory = factory;
        Disposer.register((Disposable)this.myProject, (Disposable)this);
    }

    public void activate() {
        this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
        this.directoryMappingChanged();
    }

    @Nullable
    public VcsUser getUser(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/GitUserRegistry", "getUser"));
        }
        return this.myUserMap.get(root);
    }

    @Nullable
    public VcsUser getOrReadUser(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/GitUserRegistry", "getOrReadUser"));
        }
        VcsUser user = this.myUserMap.get(root);
        if (user == null) {
            try {
                user = this.readCurrentUser(this.myProject, root);
                if (user != null) {
                    this.myUserMap.put(root, user);
                }
            }
            catch (VcsException e) {
                LOG.warn("Could not retrieve user name in " + root, (Throwable)e);
            }
        }
        return user;
    }

    @Nullable
    private VcsUser readCurrentUser(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitUserRegistry", "readCurrentUser"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/GitUserRegistry", "readCurrentUser"));
        }
        String userName = GitConfigUtil.getValue(project, root, "user.name");
        String userEmail = StringUtil.notNullize((String)GitConfigUtil.getValue(project, root, "user.email"));
        return userName == null ? null : this.myFactory.createUser(userName, userEmail);
    }

    public void dispose() {
        this.myUserMap.clear();
    }

    public void directoryMappingChanged() {
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        if (vcs == null) {
            return;
        }
        Object[] roots = this.myVcsManager.getRootsUnderVcs((AbstractVcs)vcs);
        final List rootsToCheck = ContainerUtil.filter((Object[])roots, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile root) {
                return GitUserRegistry.this.getUser(root) == null;
            }
        });
        if (!rootsToCheck.isEmpty()) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    for (VirtualFile root : rootsToCheck) {
                        GitUserRegistry.this.getOrReadUser(root);
                    }
                }
            });
        }
    }
}

