/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal.progress;

import java.util.HashMap;
import java.util.Map;
import org.gradle.logging.internal.progress.ProgressOperation;

public class ProgressOperations {
    private final Map<Long, ProgressOperation> operationsById = new HashMap<Long, ProgressOperation>();

    public ProgressOperation start(String description, String status, long operationId, Long parentOperationId) {
        ProgressOperation parent = null;
        if (parentOperationId != null) {
            parent = this.operationsById.get(parentOperationId);
        }
        ProgressOperation operation = new ProgressOperation(description, status, parent);
        this.operationsById.put(operationId, operation);
        return operation;
    }

    public ProgressOperation progress(String description, long operationId) {
        ProgressOperation op = this.operationsById.get(operationId);
        if (op == null) {
            throw new IllegalStateException("Received progress event for an unknown operation (id: " + operationId + ")");
        }
        op.setStatus(description);
        return op;
    }

    public ProgressOperation complete(long operationId) {
        ProgressOperation op = this.operationsById.remove(operationId);
        if (op == null) {
            throw new IllegalStateException("Received complete event for an unknown operation (id: " + operationId + ")");
        }
        return op;
    }
}

