/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.TaskDependency;

public class StringBackedTextResource
implements TextResource {
    private final TemporaryFileProvider tempFileProvider;
    private final String string;

    public StringBackedTextResource(TemporaryFileProvider tempFileProvider, String string) {
        this.tempFileProvider = tempFileProvider;
        this.string = string;
    }

    public String asString() {
        return this.string;
    }

    public Reader asReader() {
        return new StringReader(this.string);
    }

    public File asFile(String charset) {
        File file = this.tempFileProvider.createTemporaryFile("string", ".txt", "resource");
        try {
            Files.write((CharSequence)this.string, (File)file, (Charset)Charset.forName(charset));
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        return file;
    }

    public File asFile() {
        return this.asFile(Charset.defaultCharset().name());
    }

    public TaskDependency getBuildDependencies() {
        return new DefaultTaskDependency();
    }

    public Object getInputProperties() {
        return this.string;
    }

    public FileCollection getInputFiles() {
        return null;
    }
}

