/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.multidex;

import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@ParallelizableTask
public class CreateManifestKeepList
extends DefaultAndroidTask {
    private File manifest;
    private File outputFile;
    private File proguardFile;
    private Filter filter;
    private static final String DEFAULT_KEEP_SPEC = "{ <init>(); }";
    private static final Map<String, String> KEEP_SPECS = ImmutableMap.builder().put((Object)"application", (Object)"{\n    <init>();\n    void attachBaseContext(android.content.Context);\n}").put((Object)"activity", (Object)"{ <init>(); }").put((Object)"service", (Object)"{ <init>(); }").put((Object)"receiver", (Object)"{ <init>(); }").put((Object)"provider", (Object)"{ <init>(); }").put((Object)"instrumentation", (Object)"{ <init>(); }").build();

    @InputFile
    public File getManifest() {
        return this.manifest;
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @InputFile
    @Optional
    public File getProguardFile() {
        return this.proguardFile;
    }

    public void setProguardFile(File proguardFile) {
        this.proguardFile = proguardFile;
    }

    @Deprecated
    public void setFilter(Filter filter) {
        this.filter = filter;
        this.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return false;
            }
        });
    }

    @TaskAction
    public void generateKeepListFromManifest() throws ParserConfigurationException, SAXException, IOException {
        CreateManifestKeepList.generateKeepListFromManifest(this.getManifest(), this.getOutputFile(), this.getProguardFile(), this.filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void generateKeepListFromManifest(File manifest, File outputFile, File proguardFile, Filter filter) throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        BufferedWriter out = new BufferedWriter(new FileWriter(outputFile));
        try {
            parser.parse(manifest, (DefaultHandler)new ManifestHandler(out, filter));
            out.write("-keep public class * extends android.app.backup.BackupAgent {\n    <init>();\n}\n-keep public class * extends java.lang.annotation.Annotation {\n    *;\n}\n-keep class com.android.tools.fd.** {\n    *;\n}\n-dontnote com.android.tools.fd.**,android.support.multidex.MultiDexExtractor\n");
            if (proguardFile != null) {
                out.write(Files.toString((File)proguardFile, (Charset)Charsets.UTF_8));
            }
        }
        finally {
            ((Writer)out).close();
        }
    }

    private static void keepClass(String className, String keepSpec, Writer out) {
        if (className != null) {
            try {
                out.write("-keep class ");
                out.write(className);
                out.write(" ");
                out.write(keepSpec);
                out.write("\n");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface Filter {
        public boolean keep(String var1, Map<String, String> var2);
    }

    public static class ConfigAction
    implements TaskConfigAction<CreateManifestKeepList> {
        private VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("collect", "MultiDexComponents");
        }

        @Override
        public Class<CreateManifestKeepList> getType() {
            return CreateManifestKeepList.class;
        }

        @Override
        public void execute(CreateManifestKeepList manifestKeepListTask) {
            manifestKeepListTask.setVariantName(this.scope.getVariantConfiguration().getFullName());
            final BaseVariantOutputData output = this.scope.getVariantData().getOutputs().get(0);
            ConventionMappingHelper.map((Task)manifestKeepListTask, "manifest", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return output.getScope().getManifestOutputFile();
                }
            });
            manifestKeepListTask.proguardFile = this.scope.getVariantConfiguration().getMultiDexKeepProguard();
            manifestKeepListTask.outputFile = this.scope.getManifestKeepListFile();
        }
    }

    private static class ManifestHandler
    extends DefaultHandler {
        private Writer out;
        private final Filter filter;

        ManifestHandler(Writer out, Filter filter) {
            this.out = out;
            this.filter = filter;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attr) {
            String keepSpec = (String)KEEP_SPECS.get(qName);
            if (!Strings.isNullOrEmpty((String)keepSpec) && (this.filter == null || this.filter.keep(qName, (Map<String, String>)ManifestHandler.makeAttrMap(attr)))) {
                CreateManifestKeepList.keepClass(attr.getValue("android:name"), keepSpec, this.out);
                CreateManifestKeepList.keepClass(attr.getValue("name"), keepSpec, this.out);
            }
        }

        private static ImmutableMap<String, String> makeAttrMap(Attributes attr) {
            ImmutableMap.Builder attrMap = ImmutableMap.builder();
            for (int i = 0; i < attr.getLength(); ++i) {
                attrMap.put((Object)attr.getQName(i), (Object)attr.getValue(i));
            }
            return attrMap.build();
        }
    }
}

