/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.toolresults;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.toolresults.ToolresultsRequest;
import com.google.api.services.toolresults.ToolresultsRequestInitializer;
import com.google.api.services.toolresults.model.Execution;
import com.google.api.services.toolresults.model.History;
import com.google.api.services.toolresults.model.ListExecutionsResponse;
import com.google.api.services.toolresults.model.ListHistoriesResponse;
import com.google.api.services.toolresults.model.ListStepThumbnailsResponse;
import com.google.api.services.toolresults.model.ListStepsResponse;
import com.google.api.services.toolresults.model.ProjectSettings;
import com.google.api.services.toolresults.model.PublishXunitXmlFilesRequest;
import com.google.api.services.toolresults.model.Step;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Toolresults
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "toolresults/v1beta3/projects/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/toolresults/v1beta3/projects/";

    public Toolresults(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Toolresults(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.20.0 of the Cloud Tool Results API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Toolresults.DEFAULT_ROOT_URL, Toolresults.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Toolresults build() {
            return new Toolresults(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setToolresultsRequestInitializer(ToolresultsRequestInitializer toolresultsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)toolresultsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public GetSettings getSettings(String projectId) throws IOException {
            GetSettings result = new GetSettings(projectId);
            Toolresults.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public InitializeSettings initializeSettings(String projectId) throws IOException {
            InitializeSettings result = new InitializeSettings(projectId);
            Toolresults.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Histories histories() {
            return new Histories();
        }

        public class Histories {
            public Create create(String projectId, History content) throws IOException {
                Create result = new Create(projectId, content);
                Toolresults.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String projectId, String historyId) throws IOException {
                Get result = new Get(projectId, historyId);
                Toolresults.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String projectId) throws IOException {
                List result = new List(projectId);
                Toolresults.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Executions executions() {
                return new Executions();
            }

            public class Executions {
                public Create create(String projectId, String historyId, Execution content) throws IOException {
                    Create result = new Create(projectId, historyId, content);
                    Toolresults.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String projectId, String historyId, String executionId) throws IOException {
                    Get result = new Get(projectId, historyId, executionId);
                    Toolresults.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String projectId, String historyId) throws IOException {
                    List result = new List(projectId, historyId);
                    Toolresults.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String projectId, String historyId, String executionId, Execution content) throws IOException {
                    Patch result = new Patch(projectId, historyId, executionId, content);
                    Toolresults.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Steps steps() {
                    return new Steps();
                }

                public class Steps {
                    public Create create(String projectId, String historyId, String executionId, Step content) throws IOException {
                        Create result = new Create(projectId, historyId, executionId, content);
                        Toolresults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String projectId, String historyId, String executionId, String stepId) throws IOException {
                        Get result = new Get(projectId, historyId, executionId, stepId);
                        Toolresults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String projectId, String historyId, String executionId) throws IOException {
                        List result = new List(projectId, historyId, executionId);
                        Toolresults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String projectId, String historyId, String executionId, String stepId, Step content) throws IOException {
                        Patch result = new Patch(projectId, historyId, executionId, stepId, content);
                        Toolresults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public PublishXunitXmlFiles publishXunitXmlFiles(String projectId, String historyId, String executionId, String stepId, PublishXunitXmlFilesRequest content) throws IOException {
                        PublishXunitXmlFiles result = new PublishXunitXmlFiles(projectId, historyId, executionId, stepId, content);
                        Toolresults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Thumbnails thumbnails() {
                        return new Thumbnails();
                    }

                    public class Thumbnails {
                        public List list(String projectId, String historyId, String executionId, String stepId) throws IOException {
                            List result = new List(projectId, historyId, executionId, stepId);
                            Toolresults.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        public class List
                        extends ToolresultsRequest<ListStepThumbnailsResponse> {
                            private static final String REST_PATH = "{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}/thumbnails";
                            @Key
                            private String projectId;
                            @Key
                            private String historyId;
                            @Key
                            private String executionId;
                            @Key
                            private String stepId;
                            @Key
                            private Integer pageSize;
                            @Key
                            private String pageToken;

                            protected List(String projectId, String historyId, String executionId, String stepId) {
                                super(Toolresults.this, "GET", REST_PATH, null, ListStepThumbnailsResponse.class);
                                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                                this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                                this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                                this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUserIp(String userIp) {
                                return (List)super.setUserIp(userIp);
                            }

                            public String getProjectId() {
                                return this.projectId;
                            }

                            public List setProjectId(String projectId) {
                                this.projectId = projectId;
                                return this;
                            }

                            public String getHistoryId() {
                                return this.historyId;
                            }

                            public List setHistoryId(String historyId) {
                                this.historyId = historyId;
                                return this;
                            }

                            public String getExecutionId() {
                                return this.executionId;
                            }

                            public List setExecutionId(String executionId) {
                                this.executionId = executionId;
                                return this;
                            }

                            public String getStepId() {
                                return this.stepId;
                            }

                            public List setStepId(String stepId) {
                                this.stepId = stepId;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer pageSize) {
                                this.pageSize = pageSize;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class PublishXunitXmlFiles
                    extends ToolresultsRequest<Step> {
                        private static final String REST_PATH = "{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}:publishXunitXmlFiles";
                        @Key
                        private String projectId;
                        @Key
                        private String historyId;
                        @Key
                        private String executionId;
                        @Key
                        private String stepId;

                        protected PublishXunitXmlFiles(String projectId, String historyId, String executionId, String stepId, PublishXunitXmlFilesRequest content) {
                            super(Toolresults.this, "POST", REST_PATH, (Object)content, Step.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                            this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                            this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                        }

                        public PublishXunitXmlFiles setAlt(String alt) {
                            return (PublishXunitXmlFiles)super.setAlt(alt);
                        }

                        public PublishXunitXmlFiles setFields(String fields) {
                            return (PublishXunitXmlFiles)super.setFields(fields);
                        }

                        public PublishXunitXmlFiles setKey(String key) {
                            return (PublishXunitXmlFiles)super.setKey(key);
                        }

                        public PublishXunitXmlFiles setOauthToken(String oauthToken) {
                            return (PublishXunitXmlFiles)super.setOauthToken(oauthToken);
                        }

                        public PublishXunitXmlFiles setPrettyPrint(Boolean prettyPrint) {
                            return (PublishXunitXmlFiles)super.setPrettyPrint(prettyPrint);
                        }

                        public PublishXunitXmlFiles setQuotaUser(String quotaUser) {
                            return (PublishXunitXmlFiles)super.setQuotaUser(quotaUser);
                        }

                        public PublishXunitXmlFiles setUserIp(String userIp) {
                            return (PublishXunitXmlFiles)super.setUserIp(userIp);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public PublishXunitXmlFiles setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getHistoryId() {
                            return this.historyId;
                        }

                        public PublishXunitXmlFiles setHistoryId(String historyId) {
                            this.historyId = historyId;
                            return this;
                        }

                        public String getExecutionId() {
                            return this.executionId;
                        }

                        public PublishXunitXmlFiles setExecutionId(String executionId) {
                            this.executionId = executionId;
                            return this;
                        }

                        public String getStepId() {
                            return this.stepId;
                        }

                        public PublishXunitXmlFiles setStepId(String stepId) {
                            this.stepId = stepId;
                            return this;
                        }

                        @Override
                        public PublishXunitXmlFiles set(String parameterName, Object value) {
                            return (PublishXunitXmlFiles)super.set(parameterName, value);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Patch
                    extends ToolresultsRequest<Step> {
                        private static final String REST_PATH = "{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}";
                        @Key
                        private String projectId;
                        @Key
                        private String historyId;
                        @Key
                        private String executionId;
                        @Key
                        private String stepId;

                        protected Patch(String projectId, String historyId, String executionId, String stepId, Step content) {
                            super(Toolresults.this, "PATCH", REST_PATH, (Object)content, Step.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                            this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                            this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUserIp(String userIp) {
                            return (Patch)super.setUserIp(userIp);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Patch setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getHistoryId() {
                            return this.historyId;
                        }

                        public Patch setHistoryId(String historyId) {
                            this.historyId = historyId;
                            return this;
                        }

                        public String getExecutionId() {
                            return this.executionId;
                        }

                        public Patch setExecutionId(String executionId) {
                            this.executionId = executionId;
                            return this;
                        }

                        public String getStepId() {
                            return this.stepId;
                        }

                        public Patch setStepId(String stepId) {
                            this.stepId = stepId;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class List
                    extends ToolresultsRequest<ListStepsResponse> {
                        private static final String REST_PATH = "{projectId}/histories/{historyId}/executions/{executionId}/steps";
                        @Key
                        private String projectId;
                        @Key
                        private String historyId;
                        @Key
                        private String executionId;
                        @Key
                        private String pageToken;
                        @Key
                        private Integer pageSize;

                        protected List(String projectId, String historyId, String executionId) {
                            super(Toolresults.this, "GET", REST_PATH, null, ListStepsResponse.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                            this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUserIp(String userIp) {
                            return (List)super.setUserIp(userIp);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public List setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getHistoryId() {
                            return this.historyId;
                        }

                        public List setHistoryId(String historyId) {
                            this.historyId = historyId;
                            return this;
                        }

                        public String getExecutionId() {
                            return this.executionId;
                        }

                        public List setExecutionId(String executionId) {
                            this.executionId = executionId;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Get
                    extends ToolresultsRequest<Step> {
                        private static final String REST_PATH = "{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}";
                        @Key
                        private String projectId;
                        @Key
                        private String historyId;
                        @Key
                        private String executionId;
                        @Key
                        private String stepId;

                        protected Get(String projectId, String historyId, String executionId, String stepId) {
                            super(Toolresults.this, "GET", REST_PATH, null, Step.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                            this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                            this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUserIp(String userIp) {
                            return (Get)super.setUserIp(userIp);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Get setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getHistoryId() {
                            return this.historyId;
                        }

                        public Get setHistoryId(String historyId) {
                            this.historyId = historyId;
                            return this;
                        }

                        public String getExecutionId() {
                            return this.executionId;
                        }

                        public Get setExecutionId(String executionId) {
                            this.executionId = executionId;
                            return this;
                        }

                        public String getStepId() {
                            return this.stepId;
                        }

                        public Get setStepId(String stepId) {
                            this.stepId = stepId;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Create
                    extends ToolresultsRequest<Step> {
                        private static final String REST_PATH = "{projectId}/histories/{historyId}/executions/{executionId}/steps";
                        @Key
                        private String projectId;
                        @Key
                        private String historyId;
                        @Key
                        private String executionId;

                        protected Create(String projectId, String historyId, String executionId, Step content) {
                            super(Toolresults.this, "POST", REST_PATH, (Object)content, Step.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                            this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUserIp(String userIp) {
                            return (Create)super.setUserIp(userIp);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Create setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getHistoryId() {
                            return this.historyId;
                        }

                        public Create setHistoryId(String historyId) {
                            this.historyId = historyId;
                            return this;
                        }

                        public String getExecutionId() {
                            return this.executionId;
                        }

                        public Create setExecutionId(String executionId) {
                            this.executionId = executionId;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Patch
                extends ToolresultsRequest<Execution> {
                    private static final String REST_PATH = "{projectId}/histories/{historyId}/executions/{executionId}";
                    @Key
                    private String projectId;
                    @Key
                    private String historyId;
                    @Key
                    private String executionId;

                    protected Patch(String projectId, String historyId, String executionId, Execution content) {
                        super(Toolresults.this, "PATCH", REST_PATH, (Object)content, Execution.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                        this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUserIp(String userIp) {
                        return (Patch)super.setUserIp(userIp);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Patch setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getHistoryId() {
                        return this.historyId;
                    }

                    public Patch setHistoryId(String historyId) {
                        this.historyId = historyId;
                        return this;
                    }

                    public String getExecutionId() {
                        return this.executionId;
                    }

                    public Patch setExecutionId(String executionId) {
                        this.executionId = executionId;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends ToolresultsRequest<ListExecutionsResponse> {
                    private static final String REST_PATH = "{projectId}/histories/{historyId}/executions";
                    @Key
                    private String projectId;
                    @Key
                    private String historyId;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String projectId, String historyId) {
                        super(Toolresults.this, "GET", REST_PATH, null, ListExecutionsResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUserIp(String userIp) {
                        return (List)super.setUserIp(userIp);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getHistoryId() {
                        return this.historyId;
                    }

                    public List setHistoryId(String historyId) {
                        this.historyId = historyId;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends ToolresultsRequest<Execution> {
                    private static final String REST_PATH = "{projectId}/histories/{historyId}/executions/{executionId}";
                    @Key
                    private String projectId;
                    @Key
                    private String historyId;
                    @Key
                    private String executionId;

                    protected Get(String projectId, String historyId, String executionId) {
                        super(Toolresults.this, "GET", REST_PATH, null, Execution.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                        this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUserIp(String userIp) {
                        return (Get)super.setUserIp(userIp);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getHistoryId() {
                        return this.historyId;
                    }

                    public Get setHistoryId(String historyId) {
                        this.historyId = historyId;
                        return this;
                    }

                    public String getExecutionId() {
                        return this.executionId;
                    }

                    public Get setExecutionId(String executionId) {
                        this.executionId = executionId;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends ToolresultsRequest<Execution> {
                    private static final String REST_PATH = "{projectId}/histories/{historyId}/executions";
                    @Key
                    private String projectId;
                    @Key
                    private String historyId;

                    protected Create(String projectId, String historyId, Execution content) {
                        super(Toolresults.this, "POST", REST_PATH, (Object)content, Execution.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUserIp(String userIp) {
                        return (Create)super.setUserIp(userIp);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Create setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getHistoryId() {
                        return this.historyId;
                    }

                    public Create setHistoryId(String historyId) {
                        this.historyId = historyId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ToolresultsRequest<ListHistoriesResponse> {
                private static final String REST_PATH = "{projectId}/histories";
                @Key
                private String projectId;
                @Key
                private String pageToken;
                @Key
                private String filterByName;
                @Key
                private Integer pageSize;

                protected List(String projectId) {
                    super(Toolresults.this, "GET", REST_PATH, null, ListHistoriesResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public List setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getFilterByName() {
                    return this.filterByName;
                }

                public List setFilterByName(String filterByName) {
                    this.filterByName = filterByName;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ToolresultsRequest<History> {
                private static final String REST_PATH = "{projectId}/histories/{historyId}";
                @Key
                private String projectId;
                @Key
                private String historyId;

                protected Get(String projectId, String historyId) {
                    super(Toolresults.this, "GET", REST_PATH, null, History.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Get setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getHistoryId() {
                    return this.historyId;
                }

                public Get setHistoryId(String historyId) {
                    this.historyId = historyId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends ToolresultsRequest<History> {
                private static final String REST_PATH = "{projectId}/histories";
                @Key
                private String projectId;

                protected Create(String projectId, History content) {
                    super(Toolresults.this, "POST", REST_PATH, (Object)content, History.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUserIp(String userIp) {
                    return (Create)super.setUserIp(userIp);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Create setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InitializeSettings
        extends ToolresultsRequest<ProjectSettings> {
            private static final String REST_PATH = "{projectId}:initializeSettings";
            @Key
            private String projectId;

            protected InitializeSettings(String projectId) {
                super(Toolresults.this, "POST", REST_PATH, null, ProjectSettings.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public InitializeSettings setAlt(String alt) {
                return (InitializeSettings)super.setAlt(alt);
            }

            public InitializeSettings setFields(String fields) {
                return (InitializeSettings)super.setFields(fields);
            }

            public InitializeSettings setKey(String key) {
                return (InitializeSettings)super.setKey(key);
            }

            public InitializeSettings setOauthToken(String oauthToken) {
                return (InitializeSettings)super.setOauthToken(oauthToken);
            }

            public InitializeSettings setPrettyPrint(Boolean prettyPrint) {
                return (InitializeSettings)super.setPrettyPrint(prettyPrint);
            }

            public InitializeSettings setQuotaUser(String quotaUser) {
                return (InitializeSettings)super.setQuotaUser(quotaUser);
            }

            public InitializeSettings setUserIp(String userIp) {
                return (InitializeSettings)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public InitializeSettings setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public InitializeSettings set(String parameterName, Object value) {
                return (InitializeSettings)super.set(parameterName, value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetSettings
        extends ToolresultsRequest<ProjectSettings> {
            private static final String REST_PATH = "{projectId}/settings";
            @Key
            private String projectId;

            protected GetSettings(String projectId) {
                super(Toolresults.this, "GET", REST_PATH, null, ProjectSettings.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetSettings setAlt(String alt) {
                return (GetSettings)super.setAlt(alt);
            }

            public GetSettings setFields(String fields) {
                return (GetSettings)super.setFields(fields);
            }

            public GetSettings setKey(String key) {
                return (GetSettings)super.setKey(key);
            }

            public GetSettings setOauthToken(String oauthToken) {
                return (GetSettings)super.setOauthToken(oauthToken);
            }

            public GetSettings setPrettyPrint(Boolean prettyPrint) {
                return (GetSettings)super.setPrettyPrint(prettyPrint);
            }

            public GetSettings setQuotaUser(String quotaUser) {
                return (GetSettings)super.setQuotaUser(quotaUser);
            }

            public GetSettings setUserIp(String userIp) {
                return (GetSettings)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public GetSettings setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public GetSettings set(String parameterName, Object value) {
                return (GetSettings)super.set(parameterName, value);
            }
        }
    }
}

