/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.hybrid;

import com.android.tools.ndk.run.hybrid.StepIntoNativeBreakpointType;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotSetBreakpointException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;

public class StepIntoNativeBreakpointHandler
extends CidrCodePointHandlerBase<XBreakpoint<StepIntoNativeBreakpointType.Properties>> {
    private static final Logger LOG = Logger.getInstance(StepIntoNativeBreakpointHandler.class);

    public StepIntoNativeBreakpointHandler(CidrDebugProcess process, @NotNull Class<? extends XBreakpointType<XBreakpoint<StepIntoNativeBreakpointType.Properties>, ?>> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/ndk/run/hybrid/StepIntoNativeBreakpointHandler", "<init>"));
        }
        super(process, type);
    }

    public void registerBreakpoint(final @NotNull XBreakpoint<StepIntoNativeBreakpointType.Properties> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/android/tools/ndk/run/hybrid/StepIntoNativeBreakpointHandler", "registerBreakpoint"));
        }
        final int threadId = this.myProcess.getCurrentThreadId();
        final int frameNumber = this.myProcess.getCurrentFrameNumber();
        final CountDownLatch latch = new CountDownLatch(1);
        this.myProcess.postCommand(new CidrDebugProcess.DebuggerCommand(){

            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                if (driver == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/hybrid/StepIntoNativeBreakpointHandler$1", "run"));
                }
                StepIntoNativeBreakpointHandler.this.doRegisterBreakpoint(driver, breakpoint, threadId, frameNumber);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    protected Collection<LLCodepoint> doAddCodepoints(@NotNull DebuggerDriver driver, @NotNull XBreakpoint<StepIntoNativeBreakpointType.Properties> breakpoint, int threadId, int frameNumber) throws ExecutionException {
        List<LLCodepoint> list;
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/hybrid/StepIntoNativeBreakpointHandler", "doAddCodepoints"));
        }
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/android/tools/ndk/run/hybrid/StepIntoNativeBreakpointHandler", "doAddCodepoints"));
        }
        String condition = this.convertCondition(breakpoint);
        StepIntoNativeBreakpointType.Properties properties = (StepIntoNativeBreakpointType.Properties)breakpoint.getProperties();
        if (properties == null || properties.getSymbolPattern() == null) {
            List<LLCodepoint> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/hybrid/StepIntoNativeBreakpointHandler", "doAddCodepoints"));
            }
            return list2;
        }
        try {
            DebuggerDriver.SymbolicBreakpoint symBreakpoint = new DebuggerDriver.SymbolicBreakpoint();
            symBreakpoint.setPattern(properties.getSymbolPattern());
            symBreakpoint.setRegexpPattern(true);
            symBreakpoint.setCondition(condition);
            symBreakpoint.setThreadId(properties.getTid());
            list = Arrays.asList(driver.addSymbolicBreakpoint(symBreakpoint));
        }
        catch (DBCannotSetBreakpointException e) {
            List<LLCodepoint> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/hybrid/StepIntoNativeBreakpointHandler", "doAddCodepoints"));
            }
            return list3;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/hybrid/StepIntoNativeBreakpointHandler", "doAddCodepoints"));
        }
        return list;
    }
}

