/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.editors;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewCppSourceNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.ndk.editors.newCppSource");
    @NotNull
    private final Project myProject;

    public NewCppSourceNotificationProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/editors/NewCppSourceNotificationProvider", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/editors/NewCppSourceNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/ndk/editors/NewCppSourceNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/android/tools/ndk/editors/NewCppSourceNotificationProvider", "createNotificationPanel"));
        }
        if (file.getFileType() != OCFileType.INSTANCE) {
            return null;
        }
        if (ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject) == null) {
            return null;
        }
        if (!OCSearchScope.getProjectSourcesScope((Project)this.myProject).contains(file)) {
            return new StaleCppProjectNotificationPanel("This file has been added after the last project sync with Gradle. Please sync the project again for the NDK support to work properly.");
        }
        return null;
    }

    private class StaleCppProjectNotificationPanel
    extends EditorNotificationPanel {
        StaleCppProjectNotificationPanel(String message) {
            this.setText(message);
            this.createActionLabel("Sync Now", new Runnable(){

                @Override
                public void run() {
                    GradleProjectImporter.getInstance().requestProjectSync(NewCppSourceNotificationProvider.this.myProject, null);
                }
            });
        }
    }
}

