/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.ddmlib.IDevice;
import com.android.repository.Revision;
import com.android.sdklib.devices.Abi;
import com.android.tools.ndk.GradleWorkspace;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.ArchitectureType;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NdkHelper {
    private static final Map<Abi, String> ourToolchainPrefixes = new ImmutableMap.Builder().put((Object)Abi.ARMEABI, (Object)"arm-linux-androideabi").put((Object)Abi.ARM64_V8A, (Object)"aarch64-linux-android").put((Object)Abi.ARMEABI_V7A, (Object)"arm-linux-androideabi").put((Object)Abi.X86, (Object)"x86").put((Object)Abi.X86_64, (Object)"x86_64").put((Object)Abi.MIPS, (Object)"mipsel-linux-android").put((Object)Abi.MIPS64, (Object)"mips64el-linux-android").build();

    public static Pair<File, String> getNdkGdb(@NotNull File ndkRoot, @NotNull Abi abi) {
        if (ndkRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ndkRoot", "com/android/tools/ndk/NdkHelper", "getNdkGdb"));
        }
        if (abi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abi", "com/android/tools/ndk/NdkHelper", "getNdkGdb"));
        }
        if (!ndkRoot.isDirectory()) {
            return Pair.create(null, (Object)String.format("%1$s does not point to a valid folder", ndkRoot.getPath()));
        }
        final String toolChainPrefix = ourToolchainPrefixes.get(abi);
        if (toolChainPrefix == null) {
            return Pair.create(null, (Object)("Unable to determine toolchain prefix for ABI: " + abi.getDisplayName()));
        }
        File toolchains = new File(ndkRoot, "toolchains");
        File[] toolchainsForAbi = toolchains.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(toolChainPrefix);
            }
        });
        if (toolchainsForAbi == null || toolchainsForAbi.length == 0) {
            return Pair.create(null, (Object)("No toolchains found in the NDK toolchains folder for ABI with prefix: " + toolChainPrefix));
        }
        File bestToolchain = null;
        Revision best = null;
        for (File toolchain : toolchainsForAbi) {
            String name = toolchain.getName();
            String version = name.substring(toolChainPrefix.length() + 1);
            try {
                Revision revision = Revision.parseRevision((String)version);
                if (best != null && revision.compareTo(best) <= 0) continue;
                best = revision;
                bestToolchain = toolchain;
            }
            catch (NumberFormatException e) {
                if (best != null) continue;
                best = Revision.NOT_SPECIFIED;
                bestToolchain = toolchain;
            }
        }
        File prebuilt = new File(bestToolchain, "prebuilt");
        File[] prebuilts = prebuilt.listFiles();
        if (prebuilts == null || prebuilts.length == 0) {
            return Pair.create(null, (Object)("No platforms inside prebuilts folder: " + prebuilt.getPath()));
        }
        String gdbPrefix = NdkHelper.getToolchainBinaryPrefix(abi, toolChainPrefix);
        String gdbSuffix = SystemInfo.isWindows ? ".exe" : "";
        File gdb = new File(prebuilts[0], FileUtil.join((String[])new String[]{"bin", gdbPrefix + "-gdb" + gdbSuffix}));
        if (!gdb.exists()) {
            return Pair.create(null, (Object)("No gdb at " + gdb.getAbsolutePath()));
        }
        return Pair.create((Object)gdb, null);
    }

    private static String getToolchainBinaryPrefix(@NotNull Abi abi, String toolChainPrefix) {
        if (abi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abi", "com/android/tools/ndk/NdkHelper", "getToolchainBinaryPrefix"));
        }
        String gdbPrefix = abi == Abi.X86 ? "i686-linux-android" : (abi == Abi.X86_64 ? "x86_64-linux-android" : toolChainPrefix);
        return gdbPrefix;
    }

    public static Abi getAbi(@NotNull ArchitectureType architectureType) {
        if (architectureType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "architectureType", "com/android/tools/ndk/NdkHelper", "getAbi"));
        }
        switch (architectureType) {
            case I386: {
                return Abi.X86;
            }
            case X86_64: {
                return Abi.X86_64;
            }
            case ARM: {
                return Abi.ARMEABI_V7A;
            }
        }
        throw new IllegalArgumentException("Unknown architecture: " + architectureType.name());
    }

    @NotNull
    public static String getArchitectureId(@NotNull Abi abi) {
        if (abi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abi", "com/android/tools/ndk/NdkHelper", "getArchitectureId"));
        }
        switch (abi) {
            case ARMEABI_V7A: 
            case ARMEABI: 
            case ARM64_V8A: {
                String string = ArchitectureType.ARM.name().toLowerCase();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/NdkHelper", "getArchitectureId"));
                }
                return string;
            }
            case X86_64: {
                String string = ArchitectureType.X86_64.name().toLowerCase();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/NdkHelper", "getArchitectureId"));
                }
                return string;
            }
            case X86: {
                String string = ArchitectureType.I386.name().toLowerCase();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/NdkHelper", "getArchitectureId"));
                }
                return string;
            }
        }
        String string = ArchitectureType.UNKNOWN.name().toLowerCase();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/NdkHelper", "getArchitectureId"));
        }
        return string;
    }

    @NotNull
    public static Abi getAbi(@NotNull IDevice targetDevice) {
        if (targetDevice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDevice", "com/android/tools/ndk/NdkHelper", "getAbi"));
        }
        List abis = targetDevice.getAbis();
        for (String a : abis) {
            Abi abi = Abi.getEnum((String)a);
            if (abi == null) continue;
            Abi abi2 = abi;
            if (abi2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/NdkHelper", "getAbi"));
            }
            return abi2;
        }
        Abi abi = Abi.ARMEABI_V7A;
        if (abi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/NdkHelper", "getAbi"));
        }
        return abi;
    }

    @NotNull
    private static String getHostPlatformString() {
        String platformString;
        if (SystemInfo.isLinux) {
            platformString = "linux";
        } else if (SystemInfo.isWindows) {
            platformString = "windows";
        } else if (SystemInfo.isMac) {
            platformString = "darwin";
        } else {
            if ("UNKNOWN" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/NdkHelper", "getHostPlatformString"));
            }
            return "UNKNOWN";
        }
        platformString = platformString + "-";
        if (SystemInfo.is64Bit) {
            platformString = platformString + "x86_64";
        } else if (SystemInfo.is32Bit) {
            platformString = platformString + "x86";
        } else {
            if ("UNKNOWN" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/NdkHelper", "getHostPlatformString"));
            }
            return "UNKNOWN";
        }
        String string = platformString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/NdkHelper", "getHostPlatformString"));
        }
        return string;
    }

    public static boolean isNdkProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/NdkHelper", "isNdkProject"));
        }
        return !GradleWorkspace.getInstance(project).getConfigurations().isEmpty();
    }

    @NotNull
    public static File getLibStdCxxPrintersPath(@NotNull File ndkRoot, @NotNull String gccVersion) {
        File fullPath;
        if (ndkRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ndkRoot", "com/android/tools/ndk/NdkHelper", "getLibStdCxxPrintersPath"));
        }
        if (gccVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gccVersion", "com/android/tools/ndk/NdkHelper", "getLibStdCxxPrintersPath"));
        }
        File prebuilt = new File(ndkRoot, "prebuilt");
        File hostPlatform = new File(prebuilt, NdkHelper.getHostPlatformString());
        File share = new File(hostPlatform, "share");
        File prettyPrinters = new File(share, "pretty-printers");
        File libStdCxx = new File(prettyPrinters, "libstdcxx");
        File file = fullPath = new File(libStdCxx, "gcc-" + gccVersion);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/NdkHelper", "getLibStdCxxPrintersPath"));
        }
        return file;
    }
}

