/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.progress.receiving;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.ICvsFilesVisitor;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.util.BugLog;

public class AbstractResponseProgressHandler {
    private final Set fileObjects = new HashSet(2000);
    private final Map directoryPaths = new HashMap(200);
    private final IProgressViewer progressViewer;
    private final int maxCount;
    private int count;
    private String previousDirectoryPath;

    protected AbstractResponseProgressHandler(IProgressViewer progressViewer, ICvsFiles cvsFiles) {
        BugLog.getInstance().assertNotNull(progressViewer);
        BugLog.getInstance().assertNotNull(cvsFiles);
        this.progressViewer = progressViewer;
        cvsFiles.visit(new ICvsFilesVisitor(){

            @Override
            public void handleFile(FileObject fileObject, Entry entry, boolean exists) {
                AbstractResponseProgressHandler.this.fileObjects.add(fileObject);
                AbstractResponseProgressHandler.this.addDirectory(fileObject.getParent());
            }

            @Override
            public void handleDirectory(DirectoryObject directoryObject) {
            }
        });
        this.maxCount = this.fileObjects.size();
    }

    protected final void fileProcessed(FileObject fileObject) {
        if (!this.fileObjects.remove(fileObject)) {
            return;
        }
        FileObjectsCount count = this.getFileObjectsCount(fileObject.getParentPath());
        if (count == null) {
            return;
        }
        count.dec();
        this.notifyProgressViewer(1);
    }

    protected final void directoryProcessed(String directoryPath) {
        FileObjectsCount previousDirectoryCount;
        if (this.previousDirectoryPath != null && !this.previousDirectoryPath.equals(directoryPath) && (previousDirectoryCount = this.removeFileObjectsCount(this.previousDirectoryPath)) != null) {
            this.notifyProgressViewer(previousDirectoryCount.getUnprocessedFilesInDirectory());
        }
        this.previousDirectoryPath = directoryPath;
    }

    private FileObjectsCount getFileObjectsCount(String directoryPath) {
        return (FileObjectsCount)this.directoryPaths.get(directoryPath);
    }

    private FileObjectsCount removeFileObjectsCount(String directoryPath) {
        return (FileObjectsCount)this.directoryPaths.remove(directoryPath);
    }

    private void putFileObjectsCount(String directoryPath, FileObjectsCount fileObjectsCount) {
        this.directoryPaths.put(directoryPath, fileObjectsCount);
    }

    private void addDirectory(DirectoryObject directoryObject) {
        String directoryPath = directoryObject.getPath();
        FileObjectsCount count = this.getFileObjectsCount(directoryPath);
        if (count == null) {
            count = new FileObjectsCount();
            this.putFileObjectsCount(directoryPath, count);
        }
        count.inc();
    }

    private void notifyProgressViewer(int incrementProgress) {
        if (incrementProgress == 0) {
            return;
        }
        this.count += incrementProgress;
        this.progressViewer.setProgress((double)this.count / (double)this.maxCount);
    }

    private static final class FileObjectsCount {
        private int fileObjectsPerDirectory;

        public String toString() {
            return String.valueOf(this.fileObjectsPerDirectory);
        }

        private void inc() {
            ++this.fileObjectsPerDirectory;
        }

        private void dec() {
            --this.fileObjectsPerDirectory;
        }

        private int getUnprocessedFilesInDirectory() {
            return this.fileObjectsPerDirectory;
        }
    }
}

